/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;

enum SemCompatibility {
    Unknown,
    Likely,
    Unlikely;

    private static final NodePattern drinkRelatedNouns;
    private static final NodePattern drinkRelatedVerb;
    private static final NodePattern drinkRelatedAdj;
    private static final NodePattern placeRelatedNouns;
    private static final NodePattern placeRelatedVerb;
    private static final NodePattern placeRelatedAdj;
    static final NodePattern usedWithPlacePrepositionalPhrase;
    private static final NodePattern placeRelatedPredicate;
    private static final NodePattern drinkRelatedPredicate;
    private static final NodePattern weitereNouns;

    static SemCompatibility getCompatibility(Node subject, Node predicate) {
        if (predicate.hasForm("weiter") && weitereNouns.matches(subject)) {
            return Unlikely;
        }
        if (subject.hasForm("Caf(\u00e9|ee?)")) {
            if (drinkRelatedPredicate.matches(predicate)) {
                return Unlikely;
            }
            if (placeRelatedPredicate.matches(predicate)) {
                return Likely;
            }
        }
        if (subject.hasForm("Kaf(f?ee?|\u00e9)|Caffe")) {
            if (placeRelatedPredicate.matches(predicate)) {
                return Unlikely;
            }
            if (drinkRelatedPredicate.matches(predicate)) {
                return Likely;
            }
        }
        return Unknown;
    }

    static {
        drinkRelatedNouns = NodePattern.N.lemma("Getr\u00e4nk|Strauch|Pflanze|Samen|Bohne");
        drinkRelatedVerb = NodePattern.N.lemma("trinken|kochen|zubereiten|einschenken|auf(br\u00fchen|setzen)|bestellen|servieren|mitbringen|holen|nachschenken|austrinken|ver(teilen|kosten|sch\u00fctten)|weglassen|s\u00fc\u00dfen|sch\u00e4umen|r\u00fchren|portionieren");
        drinkRelatedAdj = NodePattern.N.lemma("hei\u00df|kalt|k\u00fchl|(mittel)?kr\u00e4ftig|(mittel)?stark|weich|(natur)?mild|koffeinfrei|entkoffeiniert|bitter|s\u00fc\u00df(lich)?cremig|wachmachend|instant|gebr\u00fcht|s\u00e4urearm|sauer|nussig|schokoladig|saftig|blumig|w\u00fcrzig|samtig|ge(r\u00f6stet|mahlen)");
        placeRelatedNouns = NodePattern.N.lemma("Ort|Gastst\u00e4tte|Haus|Lokal");
        placeRelatedVerb = NodePattern.N.lemma("be(treiben|treten|finden|suchen|sitzen)|((wieder)?er?)\u00f6ffnen|gehen|sitzen|essen|treffen|f\u00fchren|arbeiten\u00fcbernehmen|schlie(\u00df|ss)en|zumachen|einrichten|gestalten|umbauen|re(novieren|servieren)|mieten|verlassen");
        placeRelatedAdj = NodePattern.N.lemma("gem\u00fctlich|klein|modern|bequem|(stil|geschmack)voll|rustikal|einladend|romantisch|freundlich|zentral|r?uhig|.+freundlich|charmant|historisch|urban|(multi|inter)kulturell|minimalistisch|boho|konzeptuell");
        usedWithPlacePrepositionalPhrase = NodePattern.or(NodePattern.N.lemma("sitzen|(hinein)?gehen|fahren|laufen|spazieren|begeben|verabreden|einladen|wollen|arbeiten"), NodePattern.N.lemma("setzen").withDependent(".*", NodePattern.N.pos("PRO:REF.*")));
        placeRelatedPredicate = NodePattern.or(placeRelatedNouns, placeRelatedVerb, placeRelatedAdj, usedWithPlacePrepositionalPhrase);
        drinkRelatedPredicate = NodePattern.or(drinkRelatedNouns, drinkRelatedVerb, drinkRelatedAdj);
        weitereNouns = NodePattern.N.lemma(".*(Information|Platz|Foto|Arbeit|Qualifikation|Termin|Hilfe|Vorschlag|Ma(ss|\u00df)nahme|Auspacken)");
    }
}

