/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.downloader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Downloader.class)
public class DefaultDownloader
implements Downloader {
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;

    @Override
    public File download(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws DownloadException, DownloadNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        Artifact artifactPom = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "pom");
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(remoteRepositories);
        if (repositories.isEmpty() && archetypeRepository != null) {
            repositories.add(archetypeRepository);
        } else if (repositories.isEmpty() && localRepository != null) {
            repositories.add(localRepository);
        }
        ArtifactRepository localRepo = localRepository;
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepo);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading " + artifact.getId() + ".", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested " + artifact.getId() + " download does not exist.", e);
        }
        try {
            this.artifactResolver.resolve(artifactPom, repositories, localRepo);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading POM for " + artifact.getId() + ".", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested " + artifact.getId() + " download's POM does not exist.", e);
        }
        return artifact.getFile();
    }

    @Override
    public File downloadOld(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws DownloadException, DownloadNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        try {
            this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading " + artifact.getId() + ".", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested " + artifact.getId() + " download does not exist.", e);
        }
        return artifact.getFile();
    }
}

