/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortShortAssociativeContainer;
import com.carrotsearch.hppc.ShortShortHashMap;
import com.carrotsearch.hppc.ShortShortMap;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.comparators.ShortShortComparator;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.predicates.ShortShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.procedures.ShortShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortShortHashMap
implements ShortShortMap {
    public final ShortShortHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortShortHashMap(ShortShortHashMap delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortShortHashMap(ShortShortHashMap delegate, ShortShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortShortComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final short[] values;
            {
                this.keys = SortedIterationShortShortHashMap.this.delegate.keys;
                this.values = SortedIterationShortShortHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortShortCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortShortPredicate predicate) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortShortProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortShortPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public short get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public short getOrDefault(short key, short defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public short put(short key, short value) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortShortAssociativeContainer container) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortShortCursor> iterable) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public short putOrAdd(short key, short putValue, short incrementValue) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public short addTo(short key, short additionValue) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public short remove(short key) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public short indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public short indexReplace(int index, short newValue) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key, short value) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public short indexRemove(int index) {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortShortHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortShortCursor> {
        private final ShortShortCursor cursor = new ShortShortCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortShortCursor fetch() {
            if (this.index < SortedIterationShortShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortShortHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortShortHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortShortCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortShortHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortShortHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final SortedIterationShortShortHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (ShortShortCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortShortHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortShortHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

