/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultIntelliJSettings;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageReportBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\f\b\u0001\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/IntelliJProjectSettingsBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "reportErrorMessage", "", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
public final class IntelliJProjectSettingsBuilder
implements ModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)IntelliJProjectSettings.class.getName());
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.getParent() == null) {
            Object obj;
            ExtensionAware extensionAware;
            IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
            IdeaProject ideaProject = ideaPlugin != null && (ideaPlugin = ideaPlugin.getModel()) != null ? ideaPlugin.getProject() : null;
            ExtensionAware extensionAware2 = extensionAware = ideaProject instanceof ExtensionAware ? (ExtensionAware)ideaProject : null;
            if (extensionAware != null && (obj = extensionAware.getExtensions().findByName("settings")) != null) {
                return new DefaultIntelliJSettings(obj.toString());
            }
        }
        return null;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        MessageReportBuilder messageReportBuilder = context.getMessageReporter().createMessage().withGroup("gradle.intellijProjectSettingsModel.group").withKind(Message.Kind.WARNING).withTitle("IntelliJ project settings import failure").withText("Unable to build IntelliJ project settings").withException(exception);
        Intrinsics.checkNotNullExpressionValue((Object)messageReportBuilder, (String)"withException(...)");
        MessageReportBuilder message = messageReportBuilder;
        message.reportMessage(project);
    }
}

