/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.data;

import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMethodStorage {
    private static final String CLASS_MARKER = "__$$CLASS_MARKER$$__()V";
    private Set<String> myIncludedMethods;
    private Set<String> myIgnoredMethods;

    /*
     * WARNING - void declaration
     */
    public boolean checkClassIncluded(InstrumentationData context) {
        void var3_5;
        if (this.isNoFilters(context)) {
            return true;
        }
        List<Pattern> includeAnnotations = context.getProjectContext().getOptions().includeAnnotations;
        List<Pattern> excludeAnnotations = context.getProjectContext().getOptions().excludeAnnotations;
        List<String> classAnnotations = InstrumentationUtils.getClassAnnotations(context.get(Key.CLASS_READER));
        boolean included = !FilteredMethodStorage.matchesPatterns(excludeAnnotations, classAnnotations) && !this.isOuterClassRegistered(context, false);
        if (!included) {
            this.addMethod(context.get(Key.CLASS_NAME), CLASS_MARKER, false);
        } else {
            void var2_2;
            boolean bl = !includeAnnotations.isEmpty();
            boolean bl2 = bl && (FilteredMethodStorage.matchesPatterns((List<Pattern>)var2_2, classAnnotations) || this.isOuterClassRegistered(context, true));
            if (bl2) {
                void var1_1;
                this.addMethod(var1_1.get(Key.CLASS_NAME), CLASS_MARKER, true);
            }
        }
        return (boolean)var3_5;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkMethodIncluded(InstrumentationData context) {
        void var3_5;
        void var2_3;
        if (this.isNoFilters(context)) {
            return true;
        }
        List<Pattern> includeAnnotations = context.getProjectContext().getOptions().includeAnnotations;
        List<Pattern> excludeAnnotations = context.getProjectContext().getOptions().excludeAnnotations;
        List<String> methodAnnotations = context.get(Key.METHOD_ANNOTATIONS);
        String owner = context.get(Key.CLASS_NAME);
        String filteredSignature = KotlinDefaultArgsBranchFilter.getOriginalNameAndDesc(context);
        boolean includeAnnotationsUsed = !includeAnnotations.isEmpty();
        boolean forceExclude = FilteredMethodStorage.matchesPatterns(excludeAnnotations, methodAnnotations) || this.isMethodRegistered(owner, filteredSignature, false);
        boolean forceInclude = includeAnnotationsUsed && (FilteredMethodStorage.matchesPatterns(includeAnnotations, methodAnnotations) || this.isMethodRegistered(owner, filteredSignature, true));
        boolean included = !forceExclude && (!includeAnnotationsUsed || forceInclude);
        if (!included) {
            this.addMethod(owner, context.getMethodName() + context.getMethodDesc(), false);
        } else if (var2_3 != false) {
            void var1_1;
            this.addMethod(owner, context.getMethodName() + var1_1.getMethodDesc(), true);
        }
        return (boolean)var3_5;
    }

    public synchronized boolean isMethodNameRegistered(String owner, String methodName, boolean included) {
        String string;
        Iterator iterator;
        Set<String> methods = included ? this.myIncludedMethods : this.myIgnoredMethods;
        if (methods == null) {
            return false;
        }
        String target = owner + "#" + (String)((Object)iterator);
        iterator = string.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.startsWith(target)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void addIgnoredMethod(String owner, String methodSignature) {
        void var2_2;
        void var1_1;
        this.addMethod((String)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNoFilters(InstrumentationData context) {
        void var1_1;
        return !(!context.getProjectContext().getOptions().excludeAnnotations.isEmpty() || this.myIgnoredMethods != null && !this.myIgnoredMethods.isEmpty() || !var1_1.getProjectContext().getOptions().includeAnnotations.isEmpty() || this.myIncludedMethods != null && !this.myIncludedMethods.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOuterClassRegistered(InstrumentationData context, boolean included) {
        void var2_2;
        void var1_1;
        return this.isRegisteredCompanionObject(context, included) || this.isAnonymousClassInRegisteredMethod((InstrumentationData)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRegisteredCompanionObject(InstrumentationData context, boolean included) {
        void var2_2;
        void var1_1;
        String className = context.get(Key.CLASS_NAME);
        if (!className.endsWith("$Companion")) {
            return false;
        }
        String subjectName = className.substring(0, className.indexOf("$Companion"));
        return this.isClassRegistered((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAnonymousClassInRegisteredMethod(InstrumentationData context, boolean included) {
        void var2_2;
        void var1_1;
        void var3_3;
        InstrumentationUtils.MethodDescriptor outerMethod = InstrumentationUtils.getOuterClass(context.get(Key.CLASS_READER));
        if (outerMethod == null) {
            return false;
        }
        String ownerName = ClassNameUtil.convertToFQName(outerMethod.owner);
        return this.isMethodRegistered((String)var3_3, outerMethod.name + var1_1.descriptor, (boolean)var2_2);
    }

    private static boolean matchesPatterns(List<Pattern> patterns, List<String> annotations) {
        Iterator iterator;
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!ClassNameUtil.matchesPatterns(string = ClassNameUtil.convertVMNameToFQN(string), patterns)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMethodRegistered(String owner, String methodSignature, boolean included) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.isClassRegistered(owner, included) || this.isMethodRegisteredInternal((String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isClassRegistered(String owner, boolean included) {
        void var2_2;
        void var1_1;
        return this.isMethodRegisteredInternal((String)var1_1, CLASS_MARKER, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized boolean isMethodRegisteredInternal(String owner, String methodSignature, boolean included) {
        void var2_2;
        void var1_1;
        void var3_4;
        Set<String> methods = included ? this.myIncludedMethods : this.myIgnoredMethods;
        return methods != null && var3_4.contains(FilteredMethodStorage.createDesc((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addMethod(String owner, String methodSignature, boolean included) {
        void var2_2;
        void var1_1;
        Set<String> methods = included ? this.myIncludedMethods : this.myIgnoredMethods;
        if (methods == null) {
            void var3_3;
            methods = new HashSet<String>();
            if (var3_3 != false) {
                this.myIncludedMethods = methods;
            } else {
                this.myIgnoredMethods = methods;
            }
        }
        methods.add(FilteredMethodStorage.createDesc((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static String createDesc(String owner, String methodSignature) {
        void var1_1;
        String string;
        return string + "#" + (String)var1_1;
    }
}

