/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias;

import com.intellij.openapi.Disposable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.ExtractionModelKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceTypeAlias.TypeReferenceInfo;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/IntroduceTypeAliasData;", "Lcom/intellij/openapi/Disposable;", "originalTypeElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "targetSibling", "Lcom/intellij/psi/PsiElement;", "extractTypeConstructor", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/psi/PsiElement;Z)V", "getOriginalTypeElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getTargetSibling", "()Lcom/intellij/psi/PsiElement;", "getExtractTypeConstructor", "()Z", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "getResolutionFacade", "()Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "markReferences", "", "dispose", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nextractionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extractionModel.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/IntroduceTypeAliasData\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,70:1\n376#2,9:71\n395#2:80\n*S KotlinDebug\n*F\n+ 1 extractionModel.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/introduceTypeAlias/IntroduceTypeAliasData\n*L\n54#1:71,9\n54#1:80\n*E\n"})
public final class IntroduceTypeAliasData
implements Disposable {
    @NotNull
    private final KtElement originalTypeElement;
    @NotNull
    private final PsiElement targetSibling;
    private final boolean extractTypeConstructor;
    @NotNull
    private final ResolutionFacade resolutionFacade;
    @NotNull
    private final BindingContext bindingContext;

    public IntroduceTypeAliasData(@NotNull KtElement originalTypeElement, @NotNull PsiElement targetSibling, boolean extractTypeConstructor) {
        Intrinsics.checkNotNullParameter((Object)originalTypeElement, (String)"originalTypeElement");
        Intrinsics.checkNotNullParameter((Object)targetSibling, (String)"targetSibling");
        this.originalTypeElement = originalTypeElement;
        this.targetSibling = targetSibling;
        this.extractTypeConstructor = extractTypeConstructor;
        this.resolutionFacade = ResolutionUtils.getResolutionFacade(this.originalTypeElement);
        this.bindingContext = this.resolutionFacade.analyze(this.originalTypeElement, BodyResolveMode.PARTIAL);
        this.markReferences();
    }

    public /* synthetic */ IntroduceTypeAliasData(KtElement ktElement, PsiElement psiElement, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(ktElement, psiElement, bl);
    }

    @NotNull
    public final KtElement getOriginalTypeElement() {
        return this.originalTypeElement;
    }

    @NotNull
    public final PsiElement getTargetSibling() {
        return this.targetSibling;
    }

    public final boolean getExtractTypeConstructor() {
        return this.extractTypeConstructor;
    }

    @NotNull
    public final ResolutionFacade getResolutionFacade() {
        return this.resolutionFacade;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    private final void markReferences() {
        KtTreeVisitorVoid visitor2 = new KtTreeVisitorVoid(this){
            final /* synthetic */ IntroduceTypeAliasData this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitTypeReference(KtTypeReference typeReference) {
                Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
                KtTypeElement ktTypeElement = typeReference.getTypeElement();
                if (ktTypeElement == null) {
                    return;
                }
                KtTypeElement typeElement2 = ktTypeElement;
                KotlinType kotlinType = (KotlinType)this.this$0.getBindingContext().get((ReadOnlySlice)BindingContext.ABBREVIATED_TYPE, (Object)typeReference);
                if (kotlinType == null && (kotlinType = (KotlinType)this.this$0.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference)) == null) {
                    return;
                }
                KotlinType kotlinType2 = kotlinType;
                ExtractionModelKt.setResolveInfo(typeReference, new TypeReferenceInfo(typeReference, kotlinType2));
                List list2 = typeElement2.getTypeArgumentsAsTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArgumentsAsTypes(...)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = it;
                    if (ktTypeReference == null) continue;
                    ktTypeReference.accept((PsiElementVisitor)this);
                }
            }
        };
        PsiElement psiElement = this.originalTypeElement.getParent();
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        (ktTypeReference != null ? (KtElement)ktTypeReference : this.originalTypeElement).accept((PsiElementVisitor)visitor2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        void $this$forEachDescendantOfType$iv$iv;
        void $this$forEachDescendantOfType$iv;
        if (!this.originalTypeElement.isValid()) {
            return;
        }
        PsiElement psiElement = (PsiElement)this.originalTypeElement;
        Function1 action$iv = IntroduceTypeAliasData::dispose$lambda$0;
        boolean $i$f$forEachDescendantOfType = false;
        void var4_4 = $this$forEachDescendantOfType$iv;
        Function1 action$iv$iv = action$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtTypeReference) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    private static final Unit dispose$lambda$0(KtTypeReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExtractionModelKt.setResolveInfo(it, null);
        return Unit.INSTANCE;
    }
}

