/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ExecuteRunConfigurationTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleInitScriptParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GroovyGradleApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration;", "<init>", "()V", "generateInitScript", "", "params", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "getMainClass", "profile", "Lcom/intellij/execution/JavaRunConfigurationBase;", "getConfigurationRunName", "configureParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "runProfile", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "intellij.gradle.java"})
public final class GroovyGradleApplicationEnvironmentProvider
extends GradleBaseApplicationEnvironmentProvider<GroovyScriptRunConfiguration> {
    @Override
    @NotNull
    public String generateInitScript(@NotNull GradleInitScriptParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String scriptText = GradleInitScriptUtil.loadApplicationInitScript((String)params.getGradleTaskPath(), (String)params.getRunAppTaskName(), (String)params.getMainClass(), (String)params.getJavaExePath(), (String)params.getSourceSetName(), (String)params.getParams(), (String)params.getDefinitions(), null, (String)params.getWorkingDirectory(), (boolean)false, (boolean)false, (boolean)false, (String)params.getJavaModuleName());
        return scriptText;
    }

    @Override
    @NotNull
    protected String getMainClass(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return "org.codehaus.groovy.tools.GroovyStarter";
    }

    @Override
    @Nullable
    protected String getConfigurationRunName(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        GroovyScriptRunConfiguration groovyScriptRunConfiguration = profile instanceof GroovyScriptRunConfiguration ? (GroovyScriptRunConfiguration)profile : null;
        return groovyScriptRunConfiguration != null ? groovyScriptRunConfiguration.getName() : null;
    }

    @Override
    @Nullable
    protected JavaParameters configureParameters(@NotNull JavaRunConfigurationBase runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        if (!(runProfile instanceof GroovyScriptRunConfiguration)) {
            return null;
        }
        VirtualFile virtualFile = ScriptFileUtil.findScriptFileByPath((String)((GroovyScriptRunConfiguration)runProfile).getScriptPath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile scriptFile = virtualFile;
        GroovyScriptRunner groovyScriptRunner = ((GroovyScriptRunConfiguration)runProfile).getScriptRunner();
        if (groovyScriptRunner == null) {
            return null;
        }
        GroovyScriptRunner runner = groovyScriptRunner;
        return ((GroovyScriptRunConfiguration)runProfile).createJavaParameters(scriptFile, runner);
    }

    public boolean isApplicable(@Nullable ExecuteRunConfigurationTask task) {
        ExecuteRunConfigurationTask executeRunConfigurationTask = task;
        if (executeRunConfigurationTask == null || (executeRunConfigurationTask = executeRunConfigurationTask.getRunProfile()) == null) {
            return false;
        }
        ExecuteRunConfigurationTask runProfile = executeRunConfigurationTask;
        if (!(runProfile instanceof GroovyScriptRunConfiguration)) {
            return false;
        }
        return GroovyConfigUtils.getInstance().isVersionAtLeast(((GroovyScriptRunConfiguration)runProfile).getModule(), "5.0", false);
    }
}

