/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.FixedSizeScrollPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingChangesPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LoadingChangesPanel.class);
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final JScrollPane myErrorPanel;
    @NotNull
    private final JBLabel myErrorLabel;
    @Nullable
    private ProgressIndicator myIndicator;

    public LoadingChangesPanel(@NotNull JComponent panel, @Nullable StatusText emptyText, @NotNull Disposable disposable) {
        if (panel == null) {
            LoadingChangesPanel.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            LoadingChangesPanel.$$$reportNull$$$0(1);
        }
        this(panel, disposable);
    }

    public LoadingChangesPanel(@NotNull JComponent panel, @NotNull Disposable disposable) {
        if (panel == null) {
            LoadingChangesPanel.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            LoadingChangesPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable);
        this.myLoadingPanel.add((Component)panel, (Object)"Center");
        this.add((Component)this.myLoadingPanel, "Center");
        this.myErrorLabel = new JBLabel();
        this.myErrorLabel.setCopyable(true);
        this.myErrorLabel.setForeground(UIUtil.getErrorForeground());
        this.myErrorPanel = new FixedSizeScrollPanel((Component)this.myErrorLabel, (Dimension)new JBDimension(400, 100));
        this.myErrorPanel.setVisible(false);
        this.add((Component)this.myErrorPanel, "North");
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    @RequiresEdt
    public <T> void loadChangesInBackground(@NotNull ThrowableComputable<? extends T, ? extends VcsException> loadChanges2, @NotNull Consumer<@Nullable T> applyResult) {
        if (loadChanges2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(4);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
        this.myIndicator = BackgroundTaskUtil.executeAndTryWait(indicator -> this.doLoadChanges(loadChanges2, applyResult), this::startLoadingProgress);
    }

    protected void startLoadingProgress() {
        this.myLoadingPanel.startLoading();
        this.myErrorPanel.setVisible(false);
    }

    @NotNull
    private <T> Runnable doLoadChanges(@NotNull ThrowableComputable<? extends T, ? extends VcsException> loadChanges2, @NotNull Consumer<@Nullable T> applyResult) {
        Runnable runnable;
        if (loadChanges2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(6);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(7);
        }
        try {
            Object changes = loadChanges2.compute();
            runnable = () -> {
                this.myLoadingPanel.stopLoading();
                applyResult.accept(changes);
            };
        }
        catch (ProcessCanceledException e) {
            Runnable runnable2 = EmptyRunnable.INSTANCE;
            if (runnable2 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(9);
            }
            return runnable2;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Runnable runnable3 = () -> {
                this.myLoadingPanel.stopLoading();
                String text = StringUtilRt.notNullize((String)e.getMessage(), (String)VcsBundle.message((String)"changes.cant.load.changes", (Object[])new Object[0]));
                this.myErrorLabel.setText(StringUtil.replace((String)text.trim(), (String)"\n", (String)"<br/>"));
                this.myErrorPanel.setVisible(true);
                applyResult.accept(null);
            };
            if (runnable3 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(10);
            }
            return runnable3;
        }
        if (runnable == null) {
            LoadingChangesPanel.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    public void dispose() {
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadChanges";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyResult";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doLoadChanges";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

