/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.model.Comments;
import org.ec4j.core.model.Version;
import org.ec4j.core.parser.EditorConfigModelHandler;
import org.ec4j.core.parser.ErrorHandler;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.ParseContext;
import org.ec4j.core.parser.Span;

public class LocationAwareModelHandler
extends EditorConfigModelHandler {
    private Comments.CommentBlock.Builder commentBlockBuilder;
    private Comments.CommentBlocks.Builder commentBlocksBuilder;
    private Span.Builder commentSpan;
    private Span.Builder globSpan;
    private Span.Builder propertySpan;
    private Span.Builder propertyNameSpan;
    private Span.Builder propertyValueSpan;
    private Span.Builder sectionSpan;

    public LocationAwareModelHandler(PropertyTypeRegistry registry, Version version, ErrorHandler errorHandler) {
        super(registry, version);
    }

    @Override
    public void blankLine(ParseContext context) {
        super.blankLine(context);
        this.closeCommentBlockIfNeeded();
    }

    private void closeCommentBlockIfNeeded() {
        if (this.commentBlockBuilder != null) {
            this.commentBlockBuilder.closeCommentBlock();
            this.commentBlockBuilder = null;
        }
    }

    @Override
    public void endComment(ParseContext context, String comment) {
        if (this.commentBlocksBuilder == null) {
            this.commentBlocksBuilder = Comments.CommentBlocks.builder();
        }
        if (this.commentBlockBuilder == null) {
            this.commentBlockBuilder = this.commentBlocksBuilder.openCommentBlock();
        }
        ((Comments.CommentLine.Builder)this.commentBlockBuilder.openCommentLine().adapter(this.commentSpan.end(context.getLocation()).buildSpan())).text(comment).closeComment();
        this.commentSpan = null;
        super.endComment(context, comment);
    }

    @Override
    public void endDocument(ParseContext context) {
        if (this.commentBlocksBuilder != null) {
            this.closeCommentBlockIfNeeded();
            this.editorConfigBuilder.adapter(this.commentBlocksBuilder.build());
            this.commentBlocksBuilder = null;
        }
        super.endDocument(context);
    }

    @Override
    public void endGlob(ParseContext context, String glob) {
        Location loc = context.getLocation();
        this.sectionBuilder.adapter(this.globSpan.end(loc).buildGlobSpan());
        this.globSpan = null;
        this.sectionSpan.end(loc);
        super.endGlob(context, glob);
    }

    @Override
    public void endPropertyName(ParseContext context, String name) {
        this.propertyBuilder.adapter(this.propertyNameSpan.end(context.getLocation()).buildNameSpan());
        this.propertyNameSpan = null;
        super.endPropertyName(context, name);
    }

    @Override
    public void endProperty(ParseContext context) {
        this.propertyBuilder.adapter(this.propertySpan.end(context.getLocation()).buildSpan());
        this.propertySpan = null;
        super.endProperty(context);
    }

    @Override
    public void endPropertyValue(ParseContext context, String value) {
        Location loc = context.getLocation();
        this.propertyBuilder.adapter(this.propertyValueSpan.end(loc).buildValueSpan());
        this.propertyValueSpan = null;
        this.sectionSpan.end(loc);
        super.endPropertyValue(context, value);
    }

    @Override
    public void endSection(ParseContext context) {
        this.sectionBuilder.adapter(this.sectionSpan.endIfNeeded(context.getLocation()).buildSpan());
        this.sectionSpan = null;
        super.endSection(context);
    }

    @Override
    public void startComment(ParseContext context) {
        super.startComment(context);
        this.commentSpan = Span.builder().start(context.getLocation());
    }

    @Override
    public void startDocument(ParseContext context) {
        super.startDocument(context);
        this.editorConfigBuilder.parentAware(true);
    }

    @Override
    public void startGlob(ParseContext context) {
        super.startGlob(context);
        this.globSpan = Span.builder().start(context.getLocation());
    }

    @Override
    public void startProperty(ParseContext context) {
        this.closeCommentBlockIfNeeded();
        super.startProperty(context);
        this.propertySpan = Span.builder().start(context.getLocation());
    }

    @Override
    public void startPropertyName(ParseContext context) {
        super.startPropertyName(context);
        this.propertyNameSpan = Span.builder().start(context.getLocation());
    }

    @Override
    public void startPropertyValue(ParseContext context) {
        super.startPropertyValue(context);
        this.propertyValueSpan = Span.builder().start(context.getLocation());
    }

    @Override
    public void startSection(ParseContext context) {
        this.closeCommentBlockIfNeeded();
        super.startSection(context);
        this.sectionSpan = Span.builder().start(context.getLocation());
    }
}

