/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenConfiguratorsKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002JC\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152#\u0010\u0017\u001a\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "myProcessedLibraries", "Ljava/util/HashSet;", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "Lkotlin/collections/HashSet;", "afterModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "shouldRun", "", "project", "Lcom/intellij/openapi/project/Project;", "getResolvers", "", "Lcom/intellij/codeInsight/ExternalAnnotationsArtifactsResolver;", "doConfigure", "mavenProjects", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "libraryFinder", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "libraryName", "Lcom/intellij/openapi/roots/libraries/Library;", "shouldImportExternalAnnotations", "Companion", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenExternalAnnotationsConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenExternalAnnotationsConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,104:1\n682#2:105\n712#2,4:106\n1321#2:110\n1321#2,2:111\n1322#2:113\n42#3,10:114\n*S KotlinDebug\n*F\n+ 1 MavenExternalAnnotationsConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator\n*L\n32#1:105\n32#1:106,4\n51#1:110\n54#1:111,2\n51#1:113\n71#1:114,10\n*E\n"})
final class MavenExternalAnnotationsConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashSet<MavenArtifact> myProcessedLibraries = new HashSet();
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.shouldRun(context2.getProject())) {
            return;
        }
        Sequence projectsWithChanges = SequencesKt.map((Sequence)SequencesKt.filter(context2.getMavenProjectsWithModules(), MavenExternalAnnotationsConfigurator::afterModelApplied$lambda$0), MavenExternalAnnotationsConfigurator::afterModelApplied$lambda$1);
        if (SequencesKt.none((Sequence)projectsWithChanges)) {
            return;
        }
        Sequence sequence = SequencesKt.mapNotNull(context2.importedEntities(LibraryEntity.class), arg_0 -> MavenExternalAnnotationsConfigurator.afterModelApplied$lambda$2(context2, arg_0));
        boolean $i$f$associateBy = false;
        void var6_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Library library = (Library)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map libraryNameMap = destination$iv$iv;
        this.doConfigure(context2.getProject(), (Sequence<MavenProject>)projectsWithChanges, (Function1<? super String, ? extends Library>)((Function1)arg_0 -> MavenExternalAnnotationsConfigurator.afterModelApplied$lambda$4(libraryNameMap, arg_0)));
    }

    private final boolean shouldRun(Project project) {
        if (!this.shouldImportExternalAnnotations(project)) {
            return false;
        }
        List<ExternalAnnotationsArtifactsResolver> resolvers = this.getResolvers();
        return !((Collection)resolvers).isEmpty();
    }

    private final List<ExternalAnnotationsArtifactsResolver> getResolvers() {
        return ExternalAnnotationsArtifactsResolver.EP_NAME.getExtensionList();
    }

    /*
     * WARNING - void declaration
     */
    private final void doConfigure(Project project, Sequence<MavenProject> mavenProjects, Function1<? super String, ? extends Library> libraryFinder) {
        void title$iv;
        Object element$iv2;
        Map toProcess = new LinkedHashMap();
        Sequence<MavenProject> $this$forEach$iv = mavenProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            void $this$forEach$iv2;
            MavenProject eachMavenProject = (MavenProject)element$iv2;
            boolean bl = false;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)eachMavenProject.getDependencies()), arg_0 -> MavenExternalAnnotationsConfigurator.doConfigure$lambda$0$0(this, arg_0));
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                MavenArtifact it = (MavenArtifact)element$iv3;
                boolean bl2 = false;
                String string = it.getLibraryName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLibraryName(...)");
                Library library = (Library)libraryFinder.invoke((Object)string);
                if (library == null) continue;
                toProcess.put(it, library);
                this.myProcessedLibraries.add(it);
            }
        }
        if (toProcess.isEmpty()) {
            return;
        }
        int totalSize = toProcess.size();
        Ref.IntRef count = new Ref.IntRef();
        Set locationsToSkip = new LinkedHashSet();
        String string = TasksBundle.message("maven.tasks.external.annotations.resolving.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        element$iv2 = string;
        Project project$iv = project;
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, this, toProcess, project, count, totalSize, locationsToSkip){
            final /* synthetic */ MavenExternalAnnotationsConfigurator this$0;
            final /* synthetic */ Map $toProcess$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Ref.IntRef $count$inlined;
            final /* synthetic */ int $totalSize$inlined;
            final /* synthetic */ Set $locationsToSkip$inlined;
            {
                this.this$0 = mavenExternalAnnotationsConfigurator;
                this.$toProcess$inlined = map;
                this.$project$inlined = project;
                this.$count$inlined = intRef;
                this.$totalSize$inlined = n;
                this.$locationsToSkip$inlined = set;
                super($project, $title, $cancellable);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                List resolvers = MavenExternalAnnotationsConfigurator.access$getResolvers(this.this$0);
                indicator2.setIndeterminate(false);
                Map $this$forEach$iv = this.$toProcess$inlined;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    MavenArtifact mavenArtifact = (MavenArtifact)entry.getKey();
                    Library library = (Library)entry.getValue();
                    if (indicator2.isCanceled()) continue;
                    Object[] objectArray = new Object[]{mavenArtifact.getLibraryName()};
                    indicator2.setText(TasksBundle.message("maven.tasks.external.annotations.looking.for", objectArray));
                    Collection locations = AnnotationsLocationSearcher.Companion.findAnnotationsLocation(this.$project$inlined, library, mavenArtifact.getArtifactId(), mavenArtifact.getGroupId(), mavenArtifact.getVersion());
                    Iterable $this$forEach$iv2 = locations;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        void $this$fold$iv;
                        AnnotationsLocation location = (AnnotationsLocation)element$iv2;
                        boolean bl3 = false;
                        if (this.$locationsToSkip$inlined.contains(location)) continue;
                        Iterable iterable = resolvers;
                        boolean initial$iv = false;
                        boolean $i$f$fold = false;
                        boolean accumulator$iv = initial$iv;
                        for (T element$iv3 : $this$fold$iv) {
                            void res;
                            ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)element$iv3;
                            boolean acc = accumulator$iv;
                            boolean bl4 = false;
                            accumulator$iv = acc || res.resolve(this.$project$inlined, library, location);
                        }
                        if (accumulator$iv) continue;
                        this.$locationsToSkip$inlined.add(location);
                    }
                    ++this.$count$inlined.element;
                    indicator2.setFraction((double)this.$count$inlined.element / (double)this.$totalSize$inlined);
                }
            }
        });
    }

    private final boolean shouldImportExternalAnnotations(Project project) {
        MavenProjectsManager $this$shouldImportExternalAnnotations_u24lambda_u240 = MavenProjectsManager.getInstance(project);
        boolean bl = false;
        return $this$shouldImportExternalAnnotations_u24lambda_u240.getImportingSettings().isDownloadAnnotationsAutomatically() && !$this$shouldImportExternalAnnotations_u24lambda_u240.getGeneralSettings().isWorkOffline();
    }

    private static final boolean afterModelApplied$lambda$0(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MavenConfiguratorsKt.hasChanges(it);
    }

    private static final MavenProject afterModelApplied$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMavenProject();
    }

    private static final Library afterModelApplied$lambda$2(MavenWorkspaceConfigurator.AppliedModelContext $context, LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LibraryEntityUtils.findLibraryBridge((LibraryEntity)it, $context.getStorage());
    }

    private static final Library afterModelApplied$lambda$4(Map $libraryNameMap, String libraryName) {
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        return (Library)$libraryNameMap.get(libraryName);
    }

    private static final boolean doConfigure$lambda$0$0(MavenExternalAnnotationsConfigurator this$0, MavenArtifact it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.myProcessedLibraries.contains(it);
    }

    public static final /* synthetic */ List access$getResolvers(MavenExternalAnnotationsConfigurator $this) {
        return $this.getResolvers();
    }

    static {
        Logger logger = Logger.getInstance(MavenExternalAnnotationsConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenExternalAnnotationsConfigurator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

