/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinRawStringBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "<init>", "()V", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinRawStringBackspaceHandler
extends BackspaceHandlerDelegate {
    @Nullable
    private RangeMarker rangeMarker;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.rangeMarker = null;
            if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
                return;
            }
            if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
                return;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = file.findElementAt(offset);
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 == null) break block4;
            PsiElement it = psiElement3;
            boolean bl = false;
            if (it instanceof KtStringTemplateExpression && Intrinsics.areEqual((Object)((KtStringTemplateExpression)it).getText(), (Object)"\"\"\"\"\"\"") && editor.getCaretModel().getOffset() == ((KtStringTemplateExpression)it).getTextOffset() + 3) {
                this.rangeMarker = editor.getDocument().createRangeMarker(((KtStringTemplateExpression)it).getTextRange());
            }
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RangeMarker rangeMarker = this.rangeMarker;
        if (rangeMarker != null) {
            RangeMarker it = rangeMarker;
            boolean bl = false;
            editor.getDocument().deleteString(it.getStartOffset(), it.getEndOffset());
            this.rangeMarker = null;
            return true;
        }
        return false;
    }
}

