/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateXmlBlock
extends XmlBlock
implements IndentInheritingBlock {
    private final AbstractXmlTemplateFormattingModelBuilder myBuilder;
    private Indent myIndent;
    private static final List<Block> EMPTY_BLOCK_LIST = new ArrayList<Block>();

    public TemplateXmlBlock(AbstractXmlTemplateFormattingModelBuilder builder, ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy, indent, textRange);
        this.myBuilder = builder;
    }

    @Override
    @NotNull
    protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable TextRange range) {
        if (child == null) {
            TemplateXmlBlock.$$$reportNull$$$0(0);
        }
        XmlBlock xmlBlock = this.myBuilder.createXmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, (TextRange)ObjectUtils.notNull((Object)range, (Object)child.getTextRange()));
        if (xmlBlock == null) {
            TemplateXmlBlock.$$$reportNull$$$0(1);
        }
        return xmlBlock;
    }

    @Override
    protected XmlTagBlock createTagBlock(@NotNull ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        if (child == null) {
            TemplateXmlBlock.$$$reportNull$$$0(2);
        }
        return this.myBuilder.createXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent);
    }

    @Override
    protected Indent getChildDefaultIndent() {
        Indent indent = super.getChildDefaultIndent();
        if (indent == null) {
            indent = Indent.getNoneIndent();
        }
        return indent;
    }

    protected List<Block> buildChildrenNoMerge() {
        return super.buildChildren();
    }

    @Override
    protected List<Block> buildChildren() {
        try {
            List<Block> childBlocks = this.patchTopLevelChildBlocks(this.buildChildrenNoMerge());
            return this.myBuilder.mergeWithTemplateBlocks(childBlocks, this.myXmlFormattingPolicy.getSettings(), this.myXmlFormattingPolicy, this.getChildDefaultIndent());
        }
        catch (FragmentedTemplateException fte) {
            return EMPTY_BLOCK_LIST;
        }
    }

    private List<Block> patchTopLevelChildBlocks(List<Block> originalBlocks) {
        if (this.myNode.getPsi() instanceof PsiFile) {
            ArrayList<Block> patchedBlocks = new ArrayList<Block>();
            for (Block block : originalBlocks) {
                if (block == originalBlocks.get(0) && block instanceof TemplateXmlBlock) {
                    patchedBlocks.addAll(((TemplateXmlBlock)block).buildChildrenNoMerge());
                    continue;
                }
                patchedBlocks.add(block);
            }
            return patchedBlocks;
        }
        return originalBlocks;
    }

    @Override
    public void setIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent != null ? this.myIndent : super.getIndent();
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            TemplateXmlBlock.$$$reportNull$$$0(3);
        }
        if (child1 instanceof TemplateLanguageBlock && child2 instanceof TemplateLanguageBlock) {
            return ((TemplateLanguageBlock)child1).getSpacing((TemplateLanguageBlock)child2);
        }
        if (child1 instanceof TemplateLanguageBlock || child2 instanceof TemplateLanguageBlock) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    public boolean isTextContainingTemplateElements() {
        if (this.isTextElement()) {
            for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (!this.myBuilder.isOuterLanguageElement(child.getPsi())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<Block> splitComment() {
        if (this.myNode.getElementType() != XmlElementType.XML_COMMENT) {
            return EMPTY;
        }
        ArrayList<AbstractXmlBlock> result = new ArrayList<AbstractXmlBlock>(3);
        boolean hasOuterLangElements = false;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child instanceof OuterLanguageElement) {
                hasOuterLangElements = true;
            }
            if (this.myBuilder.isOuterLanguageElement(child.getPsi())) {
                result.add(this.createTemplateFragmentWrapper(child));
                continue;
            }
            result.add(new XmlBlock(child, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null, this.isPreserveSpace()));
        }
        return hasOuterLangElements ? result : EMPTY;
    }

    private AnotherLanguageBlockWrapper createTemplateFragmentWrapper(@NotNull ASTNode child) {
        if (child == null) {
            TemplateXmlBlock.$$$reportNull$$$0(4);
        }
        return new AnotherLanguageBlockWrapper(child, this.myXmlFormattingPolicy, (Block)new ReadOnlyBlock(child), null, child.getStartOffset(), child.getTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/TemplateXmlBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/TemplateXmlBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleChild";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTagBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFragmentWrapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

