/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.PasswordAuthenticationData;
import org.jetbrains.idea.svn.commandLine.BaseTerminalModule;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;

public class TerminalUserNamePasswordModule
extends BaseTerminalModule {
    private static final Pattern USER_NAME_PROMPT = Pattern.compile("Username:\\s?");
    private static final Pattern PASSWORD_PROMPT = Pattern.compile("Password for \\'(.*)\\':\\s?");
    private static final Pattern AUTHENTICATION_REALM_MESSAGE = Pattern.compile("Authentication realm: (.*)\\s?");
    private String realm;
    private String userName;
    private PasswordAuthenticationData authentication;

    public TerminalUserNamePasswordModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        if (runtime == null) {
            TerminalUserNamePasswordModule.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            TerminalUserNamePasswordModule.$$$reportNull$$$0(1);
        }
        super(runtime, executor);
    }

    @Override
    public boolean doHandlePrompt(String line, Key outputType) {
        return this.checkRealm(line) || this.checkUserName(line) || this.checkPassword(line);
    }

    private boolean checkRealm(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            TerminalUserNamePasswordModule.$$$reportNull$$$0(2);
        }
        if ((matcher = AUTHENTICATION_REALM_MESSAGE.matcher(line)).matches()) {
            this.realm = matcher.group(1);
        }
        return matcher.matches();
    }

    private boolean checkUserName(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            TerminalUserNamePasswordModule.$$$reportNull$$$0(3);
        }
        return (matcher = USER_NAME_PROMPT.matcher(line)).matches() && this.handleAuthPrompt(true);
    }

    private boolean checkPassword(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            TerminalUserNamePasswordModule.$$$reportNull$$$0(4);
        }
        if ((matcher = PASSWORD_PROMPT.matcher(line)).matches()) {
            this.userName = matcher.group(1);
        }
        return matcher.matches() && this.handleAuthPrompt(false);
    }

    private boolean handleAuthPrompt(boolean isUserName) {
        Url repositoryUrl = this.myExecutor.getCommand().requireRepositoryUrl();
        if (this.needAskAuthentication(isUserName)) {
            this.authentication = (PasswordAuthenticationData)this.myRuntime.getAuthenticationService().requestCredentials(repositoryUrl, "svn.simple");
        }
        return this.sendData(isUserName);
    }

    private boolean needAskAuthentication(boolean isUserName) {
        return this.authentication == null || isUserName && StringUtil.equals((CharSequence)this.userName, (CharSequence)this.authentication.getUserName());
    }

    private boolean sendData(boolean isUserName) {
        if (this.authentication != null) {
            this.sendData(isUserName ? this.authentication.getUserName() : this.authentication.getPassword());
        } else {
            this.cancelAuthentication();
        }
        return this.authentication != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRealm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUserName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPassword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

