/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.AdvancedSettingsPanel;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.jetbrains.annotations.NotNull;

public class AdvancedSettingsUI
implements SearchableConfigurable {
    private final Configuration.AdvancedConfiguration myConfiguration;
    private AdvancedSettingsPanel myPanel;
    private final Project myProject;

    public AdvancedSettingsUI(@NotNull Project project, Configuration configuration) {
        if (project == null) {
            AdvancedSettingsUI.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfiguration = configuration.getAdvancedConfiguration();
    }

    public JComponent createComponent() {
        this.myPanel = new AdvancedSettingsPanel(this.myProject, this.myConfiguration);
        return this.myPanel.content;
    }

    public void apply() throws ConfigurationException {
        this.myPanel.content.apply();
    }

    public boolean isModified() {
        return this.myPanel.content.isModified();
    }

    public void reset() {
        this.myPanel.content.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    public String getDisplayName() {
        return IntelliLangBundle.message((String)"configurable.AdvancedSettingsUI.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.injection.advanced";
    }

    @NotNull
    public String getId() {
        return "IntelliLang.Advanced";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/AdvancedSettingsUI", "<init>"));
    }

    static final class BrowseClassListener
    implements ActionListener {
        private final Project myProject;
        private final ReferenceEditorWithBrowseButton myField;

        BrowseClassListener(Project project, ReferenceEditorWithBrowseButton annotationField) {
            this.myProject = project;
            this.myField = annotationField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myField.getText(), scope);
            TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser(IntelliLangBundle.message((String)"dialog.title.select.annotation.class", (Object[])new Object[0]), scope, PsiClass::isAnnotationType, aClass);
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelected();
            if (psiClass != null) {
                this.myField.setText(psiClass.getQualifiedName());
            }
        }
    }
}

