/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl;

import java.util.Locale;
import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.HttpResponseFactory;
import org.jetbrains.kotlin.org.apache.http.ReasonPhraseCatalog;
import org.jetbrains.kotlin.org.apache.http.StatusLine;
import org.jetbrains.kotlin.org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.jetbrains.kotlin.org.apache.http.message.BasicHttpResponse;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

