/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.Required;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;

@ApiStatus.Internal
public final class MavenPluginDescriptor
implements PluginAware {
    public static final ExtensionPointName<MavenPluginDescriptor> EP_NAME = new ExtensionPointName("org.jetbrains.idea.maven.pluginDescriptor");
    public static volatile Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> ourDescriptorsMap;
    @Attribute(value="goal")
    public String goal;
    @Attribute(value="mavenId")
    @Required
    public String mavenId;
    @Property(surroundWithTag=false)
    @XCollection
    public Param[] params;
    @Property(surroundWithTag=false)
    @XCollection
    public ModelProperty[] properties;
    @Attribute(value="propertyGenerator")
    public String propertyGenerator;
    private PluginDescriptor pluginDescriptor;

    @Transient
    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            MavenPluginDescriptor.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    public static Pair<String, String> parsePluginId(String mavenId) {
        int idx = mavenId.indexOf(58);
        if (idx <= 0 || idx == mavenId.length() - 1 || mavenId.lastIndexOf(58) != idx) {
            throw new RuntimeException("Failed to parse mavenId: " + mavenId + " (mavenId should has format 'groupId:artifactId')");
        }
        return Pair.create((Object)mavenId.substring(0, idx), (Object)mavenId.substring(idx + 1));
    }

    public static Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> getDescriptorsMap() {
        Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> res = ourDescriptorsMap;
        if (res == null) {
            res = new HashMap<String, Map<String, Map<String, List<MavenPluginDescriptor>>>>();
            for (MavenPluginDescriptor pluginDescriptor : (MavenPluginDescriptor[])EP_NAME.getExtensions()) {
                Pair<String, String> pluginId = MavenPluginDescriptor.parsePluginId(pluginDescriptor.mavenId);
                Map<String, Map<String, List<MavenPluginDescriptor>>> groupMap = MavenPluginDescriptor.getOrCreate(res, (String)pluginId.second);
                Map<String, List<MavenPluginDescriptor>> goalsMap = MavenPluginDescriptor.getOrCreate(groupMap, (String)pluginId.first);
                SmartList descriptorList = goalsMap.get(pluginDescriptor.goal);
                if (descriptorList == null) {
                    descriptorList = new SmartList();
                    goalsMap.put(pluginDescriptor.goal, (List<MavenPluginDescriptor>)descriptorList);
                }
                descriptorList.add((MavenPluginDescriptor)pluginDescriptor);
            }
            ourDescriptorsMap = res;
        }
        return res;
    }

    @NotNull
    private static <K, V extends Map<?, ?>> V getOrCreate(Map<K, V> map, K key) {
        HashMap res = (HashMap)map.get(key);
        if (res == null) {
            res = new HashMap();
            map.put(key, res);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            MavenPluginDescriptor.$$$reportNull$$$0(1);
        }
        return (V)hashMap;
    }

    public static boolean processDescriptors(Processor<? super MavenPluginDescriptor> processor, MavenDomConfiguration cfg) {
        Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> map = MavenPluginDescriptor.getDescriptorsMap();
        DomElement parent = cfg.getParent();
        MavenDomPlugin plugin = (MavenDomPlugin)DomUtil.getParentOfType((DomElement)parent, MavenDomPlugin.class, (boolean)false);
        if (plugin == null) {
            return true;
        }
        Map<String, Map<String, List<MavenPluginDescriptor>>> groupMap = map.get(plugin.getArtifactId().getStringValue());
        if (groupMap == null) {
            return true;
        }
        Map<String, List<MavenPluginDescriptor>> goalsMap = groupMap.get(plugin.getGroupId().getStringValue());
        if (goalsMap == null) {
            return true;
        }
        List<MavenPluginDescriptor> descriptorsForAllGoals = goalsMap.get(null);
        if (descriptorsForAllGoals != null) {
            for (MavenPluginDescriptor descriptor2 : descriptorsForAllGoals) {
                if (processor.process((Object)descriptor2)) continue;
                return false;
            }
        }
        if (parent instanceof MavenDomPluginExecution) {
            for (MavenDomGoal goal : ((MavenDomPluginExecution)parent).getGoals().getGoals()) {
                List<MavenPluginDescriptor> descriptors = goalsMap.get(goal.getStringValue());
                if (descriptors == null) continue;
                for (MavenPluginDescriptor descriptor3 : descriptors) {
                    if (processor.process((Object)descriptor3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/plugins/api/MavenPluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/plugins/api/MavenPluginDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    @Tag(value="param")
    public static class Param {
        @Attribute(value="name")
        @Required
        public String name;
        @Attribute(value="refProvider")
        public String refProvider;
        @Attribute(value="values")
        public String values;
        @Attribute(value="soft")
        public Boolean soft;
        @Attribute(value="disableReferences")
        public Boolean disableReferences;
        @Attribute(value="language")
        public String language;
        @Attribute(value="languageProvider")
        public String languageProvider;
        @Attribute(value="languageInjectionPrefix")
        public String languageInjectionPrefix;
        @Attribute(value="languageInjectionSuffix")
        public String languageInjectionSuffix;
    }

    @Tag(value="property")
    public static class ModelProperty {
        @Attribute(value="name")
        @Required
        public String name;
        @Attribute
        public String value;
        @Attribute
        public boolean insideConfigurationOnly;
    }
}

