/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.Compatibility;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.java_lang_Class;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.KlassArray;

class CompatibilityHelper8
implements Compatibility {
    private static final long compressedKlassOffset;
    private static final long klassOffset;

    CompatibilityHelper8() {
    }

    @Override
    public Address getAddress(Method method) {
        return method.getAddress();
    }

    @Override
    public Address getAddress(Klass klass) {
        return klass.getAddress();
    }

    @Override
    public Klass asKlass(Oop ref) {
        return java_lang_Class.asKlass((Oop)ref);
    }

    @Override
    public List<InstanceKlass> getTransitiveInterfaces(InstanceKlass saKlass) {
        ArrayList<InstanceKlass> res = new ArrayList<InstanceKlass>();
        KlassArray interfaces = saKlass.getTransitiveInterfaces();
        int n = interfaces.length();
        for (int i = 0; i < n; ++i) {
            res.add((InstanceKlass)interfaces.getAt(i));
        }
        return res;
    }

    @Override
    public String getSourceDebugExtension(InstanceKlass saKlass) {
        return saKlass.getSourceDebugExtension();
    }

    @Override
    public InstanceKlass getMethodHandleKlass() {
        return SystemDictionary.getMethodHandleKlass();
    }

    @Override
    public Klass getMethodHolder(Method method) {
        return method.getMethodHolder();
    }

    @Override
    public Address getKlassAddress(Oop oop) {
        if (VM.getVM().isCompressedKlassPointersEnabled()) {
            return oop.getHandle().getCompKlassAddressAt(compressedKlassOffset);
        }
        return oop.getHandle().getAddressAt(klassOffset);
    }

    @Override
    public List<Klass> allClasses(SystemDictionary systemDictionary, VM vm) {
        ArrayList<Klass> saKlasses = new ArrayList<Klass>();
        systemDictionary.allClassesDo(k -> {
            if (k instanceof ArrayKlass) {
                saKlasses.add(k);
            } else {
                int status = k.getClassStatus();
                if ((status & 2) != 0) {
                    saKlasses.add(k);
                }
            }
        });
        return saKlasses;
    }

    @Override
    public List<ReferenceTypeImpl> visibleClasses(Oop ref, VirtualMachineImpl vm) {
        ArrayList<ReferenceTypeImpl> res = new ArrayList<ReferenceTypeImpl>();
        SystemDictionary sysDict = vm.saSystemDictionary();
        sysDict.classesDo((k, loader) -> {
            if (ref.equals((Object)loader)) {
                for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                    res.add(vm.referenceType(l));
                }
            }
        });
        sysDict.primArrayClassesDo((k, loader) -> {
            if (ref.equals((Object)loader)) {
                res.add(vm.referenceType(k));
            }
        });
        vm.saUniverse().basicTypeClassesDo(k -> res.add(vm.referenceType(k)));
        return res;
    }

    @Override
    public List<JavaThread> getThreads(VM vm) {
        ArrayList<JavaThread> res = new ArrayList<JavaThread>();
        for (JavaThread thread = vm.getThreads().first(); thread != null; thread = thread.next()) {
            res.add(thread);
        }
        return res;
    }

    static {
        long coff = -1L;
        long koff = -1L;
        try {
            Field field = Oop.class.getDeclaredField("klass");
            field.setAccessible(true);
            coff = ((sun.jvm.hotspot.oops.Field)field.get(null)).getOffset();
            Field field1 = Oop.class.getDeclaredField("compressedKlass");
            field1.setAccessible(true);
            koff = ((sun.jvm.hotspot.oops.Field)field1.get(null)).getOffset();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        compressedKlassOffset = coff;
        klassOffset = koff;
    }
}

