/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.consistent;

import com.dynatrace.hash4j.consistent.ConsistentBucketHasher;
import com.dynatrace.hash4j.consistent.ConsistentHashingUtil;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import java.util.Objects;

class ConsistentJumpBackBucketHasher
implements ConsistentBucketHasher {
    private final PseudoRandomGenerator pseudoRandomGenerator;

    ConsistentJumpBackBucketHasher(PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Objects.requireNonNull(pseudoRandomGeneratorProvider);
        this.pseudoRandomGenerator = pseudoRandomGeneratorProvider.create();
    }

    @Override
    public int getBucket(long hash, int numBuckets) {
        if (numBuckets <= 1) {
            ConsistentHashingUtil.checkNumberOfBuckets(numBuckets);
            return 0;
        }
        this.pseudoRandomGenerator.reset(hash);
        return ConsistentJumpBackBucketHasher.getBucket(numBuckets, this.pseudoRandomGenerator);
    }

    static final int getBucket(int numBuckets, PseudoRandomGenerator pseudoRandomGenerator) {
        long r0 = pseudoRandomGenerator.nextLong();
        int xMasked = (int)(r0 ^ r0 >>> 32) & -1 >>> Integer.numberOfLeadingZeros(numBuckets - 1);
        while (xMasked != 0) {
            long r1;
            int bucketRangeMin = 1 << ~Integer.numberOfLeadingZeros(xMasked);
            int bucketIdx = bucketRangeMin + ((int)(r0 >>> (Integer.bitCount(xMasked) << 5)) & bucketRangeMin - 1);
            if (bucketIdx < numBuckets) {
                return bucketIdx;
            }
            int bucketRangeMax = (bucketRangeMin << 1) - 1;
            while ((bucketIdx = (int)(r1 = pseudoRandomGenerator.nextLong()) & bucketRangeMax) >= bucketRangeMin) {
                if (bucketIdx < numBuckets) {
                    return bucketIdx;
                }
                bucketIdx = (int)(r1 >>> 32) & bucketRangeMax;
                if (bucketIdx < bucketRangeMin) break;
                if (bucketIdx >= numBuckets) continue;
                return bucketIdx;
            }
            xMasked ^= bucketRangeMin;
        }
        return 0;
    }
}

