/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator18;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator25;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator30;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator40;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator50;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre17;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre18;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre23;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre30;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre40;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre50;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyVersionAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.groovy.psi"})
public final class GroovyVersionAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof GroovyPsiElement)) {
            return;
        }
        GroovyConfigUtils config = GroovyConfigUtils.getInstance();
        String string = config.getSDKVersion((PsiElement)holder.getCurrentAnnotationSession().getFile());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSDKVersion(...)");
        String version = string;
        if (Intrinsics.areEqual((Object)version, (Object)"<no version>")) {
            return;
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "1.7") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre17(holder, version));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "1.8") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre18(holder, version));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator18(holder));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "2.3") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre23(holder, version));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "2.5") >= 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator25(holder));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "3.0") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre30(holder));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator30(holder));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "4.0") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre40(holder));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator40(holder));
        }
        if (GroovyConfigUtils.compareSdkVersions(version, "5.0") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre50(holder));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator50(holder));
        }
    }
}

