/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyNamedImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.NonFqnImport;
import org.jetbrains.plugins.groovy.lang.resolve.processors.StaticMembersFilteringProcessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ(\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u00020\u0004H\u0097\u0080\u0004J\u001a\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040$0#H\u0002J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\t\u0010&\u001a\u00020\u0004H\u00c6\u0003J\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J'\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0014\u0010)\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0083\u0004J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/NonFqnImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyNamedImport;", "classFqn", "", "memberName", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassFqn", "()Ljava/lang/String;", "getMemberName", "getName", "isAliased", "", "()Z", "shortName", "getShortName", "fullyQualifiedName", "getFullyQualifiedName", "processDeclarations", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "isUnnecessary", "imports", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyFileImports;", "toString", "namesMapping", "", "Lkotlin/Pair;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "Companion", "intellij.groovy.psi"})
public final class StaticImport
extends NonFqnImport
implements GroovyNamedImport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String classFqn;
    @NotNull
    private final String memberName;
    @NotNull
    private final String name;
    private final boolean isAliased;

    public StaticImport(@NotNull String classFqn, @NotNull String memberName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.classFqn = classFqn;
        this.memberName = memberName;
        this.name = name;
        this.isAliased = !Intrinsics.areEqual((Object)this.memberName, (Object)this.getName());
    }

    @Override
    @NotNull
    public String getClassFqn() {
        return this.classFqn;
    }

    @NotNull
    public final String getMemberName() {
        return this.memberName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public StaticImport(@NotNull String classFqn, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        this(classFqn, memberName, memberName);
    }

    @Override
    public boolean isAliased() {
        return this.isAliased;
    }

    @Override
    @NotNull
    public String getShortName() {
        return this.memberName;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        String string = StringUtil.getQualifiedName((String)this.getClassFqn(), (String)this.memberName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return string;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GroovyFileBase file) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ResolveUtilKt.isAnnotationResolve(processor)) {
            return true;
        }
        if (!ResolveUtilKt.shouldProcessMembers(processor)) {
            return true;
        }
        PsiClass psiClass = this.resolveImport(file);
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        List<Pair<String, String>> namesMapping = this.namesMapping();
        String hintName = ResolveUtilKt.getName(processor, state);
        for (Pair<String, String> pair : namesMapping) {
            StaticMembersFilteringProcessor delegate;
            String memberName = (String)pair.component1();
            String alias = (String)pair.component2();
            if (hintName != null && !Intrinsics.areEqual((Object)hintName, (Object)alias) || clazz.processDeclarations((PsiScopeProcessor)(delegate = new StaticMembersFilteringProcessor(processor, memberName)), state.put(GroovyImports.getImportedNameKey(), (Object)alias), null, place)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnnecessary(@NotNull GroovyFileImports imports2) {
        Intrinsics.checkNotNullParameter((Object)imports2, (String)"imports");
        if (this.isAliased()) {
            return false;
        }
        return imports2.getStaticStarImports().contains(new StaticStarImport(this.getClassFqn()));
    }

    @NonNls
    @NotNull
    public String toString() {
        return "import static " + this.getClassFqn() + "." + this.memberName + " as " + this.getName();
    }

    private final List<Pair<String, String>> namesMapping() {
        return StaticImport.Companion.namesMapping(this.memberName, this.getName());
    }

    @NotNull
    public final String component1() {
        return this.classFqn;
    }

    @NotNull
    public final String component2() {
        return this.memberName;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final StaticImport copy(@NotNull String classFqn, @NotNull String memberName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new StaticImport(classFqn, memberName, name);
    }

    public static /* synthetic */ StaticImport copy$default(StaticImport staticImport, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = staticImport.classFqn;
        }
        if ((n & 2) != 0) {
            string2 = staticImport.memberName;
        }
        if ((n & 4) != 0) {
            string3 = staticImport.name;
        }
        return staticImport.copy(string, string2, string3);
    }

    public int hashCode() {
        int result2 = this.classFqn.hashCode();
        result2 = result2 * 31 + this.memberName.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StaticImport)) {
            return false;
        }
        StaticImport staticImport = (StaticImport)other;
        if (!Intrinsics.areEqual((Object)this.classFqn, (Object)staticImport.classFqn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.memberName, (Object)staticImport.memberName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)staticImport.name);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J*\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t0\u00052\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport$Companion;", "", "<init>", "()V", "names", "", "", "name", "namesMapping", "Lkotlin/Pair;", "left", "right", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> names(String name) {
            Object[] objectArray = new String[4];
            objectArray[0] = name;
            Intrinsics.checkNotNullExpressionValue((Object)GroovyPropertyUtils.getGetterNameNonBoolean(name), (String)"getGetterNameNonBoolean(...)");
            Intrinsics.checkNotNullExpressionValue((Object)GroovyPropertyUtils.getGetterNameBoolean(name), (String)"getGetterNameBoolean(...)");
            Intrinsics.checkNotNullExpressionValue((Object)GroovyPropertyUtils.getSetterName(name), (String)"getSetterName(...)");
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final List<Pair<String, String>> namesMapping(String left, String right) {
            List<String> leftNames = this.names(left);
            List<String> rightNames = Intrinsics.areEqual((Object)left, (Object)right) ? leftNames : this.names(right);
            return CollectionsKt.zip((Iterable)leftNames, (Iterable)rightNames);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

