/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel;

import com.intellij.platform.eel.channels.EelDelicateApi;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0082\u0010\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/eel/EelLowLevelObjectsPool;", "T", "", "maxSize", "", "factory", "Lkotlin/Function0;", "returnValidator", "Lkotlin/Function1;", "", "<init>", "(ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "stack", "Lkotlin/collections/ArrayDeque;", "Ljava/lang/ref/SoftReference;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "returnBack", "", "value", "(Ljava/lang/Object;)V", "borrow", "()Ljava/lang/Object;", "borrowImpl", "Companion", "intellij.platform.eel"})
@ApiStatus.Internal
public final class EelLowLevelObjectsPool<T> {
    @NotNull
    public static final Companion Companion;
    private final int maxSize;
    @NotNull
    private final Function0<T> factory;
    @NotNull
    private final Function1<T, Boolean> returnValidator;
    @NotNull
    private final ArrayDeque<SoftReference<T>> stack;
    @NotNull
    private final ReferenceQueue<T> referenceQueue;
    @NotNull
    private static final EelLowLevelObjectsPool<ByteBuffer> directByteBuffers;
    @NotNull
    private static final EelLowLevelObjectsPool<ByteBuffer> fakeByteBufferPool;

    public EelLowLevelObjectsPool(int maxSize, @NotNull Function0<? extends T> factory, @NotNull Function1<? super T, Boolean> returnValidator) {
        Intrinsics.checkNotNullParameter(factory, "factory");
        Intrinsics.checkNotNullParameter(returnValidator, "returnValidator");
        this.maxSize = maxSize;
        this.factory = factory;
        this.returnValidator = returnValidator;
        this.stack = new ArrayDeque();
        this.referenceQueue = new ReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void returnBack(T value) {
        if (this.returnValidator.invoke(value).booleanValue()) {
            EelLowLevelObjectsPool eelLowLevelObjectsPool = this;
            synchronized (eelLowLevelObjectsPool) {
                boolean bl = false;
                if (this.stack.size() < this.maxSize) {
                    this.stack.addLast(new SoftReference<T>(value, this.referenceQueue));
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T borrow() {
        T t;
        EelLowLevelObjectsPool eelLowLevelObjectsPool = this;
        synchronized (eelLowLevelObjectsPool) {
            boolean bl = false;
            T t2 = this.borrowImpl();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            t = t2;
        }
        T t3 = t;
        if (t == null) {
            t3 = this.factory.invoke();
        }
        return t3;
    }

    private final T borrowImpl() {
        T t;
        EelLowLevelObjectsPool eelLowLevelObjectsPool = this;
        do {
            SoftReference<T> ref;
            if (eelLowLevelObjectsPool.stack.removeLastOrNull() == null) {
                return null;
            }
            t = ref.get();
        } while (t == null);
        return t;
    }

    private static final ByteBuffer directByteBuffers$lambda$0$0(int $capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect($capacity);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocateDirect(...)");
        return byteBuffer;
    }

    private static final boolean directByteBuffers$lambda$0$1(int $capacity, ByteBuffer buffer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.isDirect() && buffer.capacity() == $capacity) {
            buffer.clear();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final ByteBuffer fakeByteBufferPool$lambda$0() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
        return byteBuffer;
    }

    private static final boolean fakeByteBufferPool$lambda$1(ByteBuffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return false;
    }

    static {
        Companion $this$directByteBuffers_u24lambda_u240 = Companion = new Companion(null);
        boolean bl = false;
        int capacity = 131072;
        directByteBuffers = new EelLowLevelObjectsPool<ByteBuffer>(50, () -> EelLowLevelObjectsPool.directByteBuffers$lambda$0$0(capacity), arg_0 -> EelLowLevelObjectsPool.directByteBuffers$lambda$0$1(capacity, arg_0));
        fakeByteBufferPool = new EelLowLevelObjectsPool<ByteBuffer>(0, EelLowLevelObjectsPool::fakeByteBufferPool$lambda$0, EelLowLevelObjectsPool::fakeByteBufferPool$lambda$1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/eel/EelLowLevelObjectsPool$Companion;", "", "<init>", "()V", "directByteBuffers", "Lcom/intellij/platform/eel/EelLowLevelObjectsPool;", "Ljava/nio/ByteBuffer;", "getDirectByteBuffers$annotations", "getDirectByteBuffers", "()Lcom/intellij/platform/eel/EelLowLevelObjectsPool;", "fakeByteBufferPool", "getFakeByteBufferPool", "intellij.platform.eel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EelLowLevelObjectsPool<ByteBuffer> getDirectByteBuffers() {
            return directByteBuffers;
        }

        @EelDelicateApi
        public static /* synthetic */ void getDirectByteBuffers$annotations() {
        }

        @NotNull
        public final EelLowLevelObjectsPool<ByteBuffer> getFakeByteBufferPool() {
            return fakeByteBufferPool;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

