/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util;

import com.intellij.platform.util.Args;
import com.intellij.platform.util.ArgsReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000b\u001a\u00060\fR\u00020\u00002\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/util/ArgsParser;", "", "args", "", "", "<init>", "(Ljava/util/List;)V", "Lcom/intellij/platform/util/Args;", "arguments", "", "Lcom/intellij/platform/util/ArgsParser$TypedArg;", "arg", "Lcom/intellij/platform/util/ArgsParser$ArgInfo;", "name", "description", "tryReadAll", "", "usage", "includeHidden", "", "commandPadding", "", "ArgInfo", "TypedArg", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nargs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 args.kt\ncom/intellij/platform/util/ArgsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1915#2,2:235\n777#2:237\n873#2,2:238\n1586#2:240\n1661#2,3:241\n1586#2:244\n1661#2,3:245\n1915#2,2:248\n*S KotlinDebug\n*F\n+ 1 args.kt\ncom/intellij/platform/util/ArgsParser\n*L\n106#1:235,2\n126#1:237\n126#1:238,2\n127#1:240\n127#1:241,3\n129#1:244\n129#1:245,3\n146#1:248,2\n*E\n"})
public final class ArgsParser {
    @NotNull
    private final Args args;
    @NotNull
    private final List<TypedArg<?>> arguments;

    public ArgsParser(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, "args");
        this.args = new Args(args);
        this.arguments = new ArrayList();
        this.arg("@args-file", "Arguments file to avoid commandline overflow\nEvery line represents an unescaped argument").optional().hidden().files();
    }

    @NotNull
    public final ArgInfo arg(@NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(description, "description");
        return new ArgInfo(name, description);
    }

    public final void tryReadAll() {
        Iterable $this$forEach$iv = this.arguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypedArg it = (TypedArg)element$iv;
            boolean bl = false;
            it.parseValue$intellij_platform_util();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String usage(boolean includeHidden, int commandPadding) {
        Object it;
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object it2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$usage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String commandPad = StringsKt.repeat(" ", commandPadding);
        Object object = new Function1[]{ArgsParser::usage$lambda$0$0, ArgsParser::usage$lambda$0$1};
        object = CollectionsKt.sortedWith((Iterable)this.arguments, ComparisonsKt.compareBy(object));
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (TypedArg)element$iv$iv;
            boolean bl2 = false;
            if (!(includeHidden || !((TypedArg)it2).getInfo().getHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (TypedArg)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(TuplesKt.to(it2, commandPad + "--" + ((TypedArg)it2).getInfo().getName() + "=<value>"));
        }
        List argsToShow = (List)destination$iv$iv;
        $this$mapTo$iv$iv2 = argsToShow;
        int n = 2;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(((String)((Pair)it).getSecond()).length());
        }
        collection = (List)destination$iv$iv2;
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)collection);
        int descrPadSize = n + (n2 != null ? n2 : 0);
        String descrPad = StringsKt.repeat(" ", descrPadSize);
        for (Pair pair : argsToShow) {
            Object object2;
            String argInfo;
            TypedArg argument;
            block10: {
                block9: {
                    argument = (TypedArg)pair.component1();
                    argInfo = (String)pair.component2();
                    object2 = argument.getInfo().getDeprecated();
                    if (object2 == null) break block9;
                    String it3 = object2;
                    boolean bl5 = false;
                    String[] stringArray = new String[]{"\n"};
                    List lines = StringsKt.split$default((CharSequence)it3, stringArray, false, 0, 6, null);
                    List list = CollectionsKt.plus((Collection)CollectionsKt.listOf("DEPRECATED. " + (String)CollectionsKt.first(lines)), (Iterable)CollectionsKt.drop(lines, 1));
                    object2 = list;
                    if (list != null) break block10;
                }
                object2 = CollectionsKt.emptyList();
            }
            List deprecatedLine = object2;
            String descriptionText = (argument.getInfo().getHidden() ? "[hidden] " : (argument.getInfo().getOptional() ? "[optional] " : "")) + StringsKt.capitalize(argument.getInfo().getDescription());
            it = new String[]{"\n"};
            List descriptionLines = CollectionsKt.plus((Collection)deprecatedLine, (Iterable)StringsKt.split$default((CharSequence)descriptionText, (String[])it, false, 0, 6, null));
            it = $this$usage_u24lambda_u240;
            StringBuilder stringBuilder2 = new StringBuilder().append(StringsKt.padEnd$default(argInfo, descrPadSize, '\u0000', 2, null));
            String string = (String)CollectionsKt.firstOrNull(descriptionLines);
            if (string == null) {
                string = "";
            }
            ((StringBuilder)it).append(stringBuilder2.append(string).toString()).append('\n');
            Iterable $this$forEach$iv = CollectionsKt.drop(descriptionLines, 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder3;
                String it4 = (String)element$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue($this$usage_u24lambda_u240.append(descrPad), "append(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)it4)).toString();
                stringBuilder3.append(string2).append('\n');
            }
            $this$usage_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String usage$default(ArgsParser argsParser, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        return argsParser.usage(bl, n);
    }

    private static final Comparable usage$lambda$0$0(TypedArg it) {
        Intrinsics.checkNotNullParameter(it, "it");
        int result = 0;
        if (it.getInfo().getOptional()) {
            result += 3;
        }
        if (it.getInfo().getHidden()) {
            result += 5;
        }
        if (it.getInfo().getDeprecated() != null) {
            result += 10;
        }
        return Integer.valueOf(result);
    }

    private static final Comparable usage$lambda$0$1(TypedArg it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)((Object)it.getInfo().getName());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\n\u001a\u00060\u0000R\u00020\u0017J\n\u0010\u0010\u001a\u00060\u0000R\u00020\u0017J\u0012\u0010\u0013\u001a\u00060\u0000R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u001aJ\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u001aJ\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001aJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cJ\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001aJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020%0\u001cJ\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u001aJ\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u001cJ\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001aJ\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001e0\u001aJ\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001e0\u001aJ-\u00100\u001a\b\u0012\u0004\u0012\u0002H10\u001a\"\u0004\b\u0000\u001012\u0017\u00102\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002H10-\u00a2\u0006\u0002\b4H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\u0016R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020%0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020(0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/platform/util/ArgsParser$ArgInfo;", "", "name", "", "description", "<init>", "(Lcom/intellij/platform/util/ArgsParser;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getDescription", "hidden", "", "getHidden", "()Z", "setHidden", "(Z)V", "optional", "getOptional", "setOptional", "deprecated", "getDeprecated", "setDeprecated", "(Ljava/lang/String;)V", "Lcom/intellij/platform/util/ArgsParser;", "message", "string", "Lcom/intellij/platform/util/ArgsParser$TypedArg;", "default", "Lkotlin/Function0;", "strings", "", "notEmptyStrings", "stringOrNull", "boolean", "booleanOrNull", "flag", "int", "", "toIntOrNull", "file", "Ljava/nio/file/Path;", "fileOrNull", "files", "notEmptyFiles", "toBoolean", "Lkotlin/Function1;", "toInt", "toFile", "parse", "T", "compute", "Lcom/intellij/platform/util/ArgsReader;", "Lkotlin/ExtensionFunctionType;", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nargs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 args.kt\ncom/intellij/platform/util/ArgsParser$ArgInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 args.kt\ncom/intellij/platform/util/ArgsReader\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1#2:235\n1#2:265\n1#2:351\n1#2:382\n1#2:412\n1#2:448\n1#2:483\n1#2:513\n1#2:544\n1#2:574\n58#3:236\n45#3,2:237\n47#3:242\n48#3:247\n49#3,6:251\n55#3,7:258\n62#3,5:266\n45#3,2:271\n47#3:276\n48#3:281\n49#3,6:285\n55#3:292\n37#3,10:293\n47#3:306\n48#3:311\n49#3,6:315\n55#3:322\n38#3,4:323\n78#3:327\n45#3,2:328\n47#3:333\n48#3:338\n49#3,6:342\n55#3:349\n79#3:350\n80#3:352\n58#3:353\n45#3,2:354\n47#3:359\n48#3:364\n49#3,6:368\n55#3,7:375\n62#3,5:383\n78#3:388\n45#3,2:389\n47#3:394\n48#3:399\n49#3,6:403\n55#3:410\n79#3:411\n80#3:413\n70#3,5:414\n58#3:419\n45#3,2:420\n47#3:425\n48#3:430\n49#3,6:434\n55#3,7:441\n62#3,5:449\n58#3:454\n45#3,2:455\n47#3:460\n48#3:465\n49#3,6:469\n55#3,7:476\n62#3,5:484\n78#3:489\n45#3,2:490\n47#3:495\n48#3:500\n49#3,6:504\n55#3:511\n79#3:512\n80#3:514\n58#3:515\n45#3,2:516\n47#3:521\n48#3:526\n49#3,6:530\n55#3,7:537\n62#3,5:545\n78#3:550\n45#3,2:551\n47#3:556\n48#3:561\n49#3,6:565\n55#3:572\n79#3:573\n80#3:575\n45#3,2:576\n47#3:581\n48#3:586\n49#3,6:590\n55#3:597\n37#3,10:598\n47#3:611\n48#3:616\n49#3,6:620\n55#3:627\n38#3,4:628\n777#4:239\n873#4,2:240\n1586#4:243\n1661#4,3:244\n1586#4:248\n1661#4,2:249\n1663#4:257\n777#4:273\n873#4,2:274\n1586#4:277\n1661#4,3:278\n1586#4:282\n1661#4,2:283\n1663#4:291\n777#4:303\n873#4,2:304\n1586#4:307\n1661#4,3:308\n1586#4:312\n1661#4,2:313\n1663#4:321\n777#4:330\n873#4,2:331\n1586#4:334\n1661#4,3:335\n1586#4:339\n1661#4,2:340\n1663#4:348\n777#4:356\n873#4,2:357\n1586#4:360\n1661#4,3:361\n1586#4:365\n1661#4,2:366\n1663#4:374\n777#4:391\n873#4,2:392\n1586#4:395\n1661#4,3:396\n1586#4:400\n1661#4,2:401\n1663#4:409\n777#4:422\n873#4,2:423\n1586#4:426\n1661#4,3:427\n1586#4:431\n1661#4,2:432\n1663#4:440\n777#4:457\n873#4,2:458\n1586#4:461\n1661#4,3:462\n1586#4:466\n1661#4,2:467\n1663#4:475\n777#4:492\n873#4,2:493\n1586#4:496\n1661#4,3:497\n1586#4:501\n1661#4,2:502\n1663#4:510\n777#4:518\n873#4,2:519\n1586#4:522\n1661#4,3:523\n1586#4:527\n1661#4,2:528\n1663#4:536\n777#4:553\n873#4,2:554\n1586#4:557\n1661#4,3:558\n1586#4:562\n1661#4,2:563\n1663#4:571\n777#4:578\n873#4,2:579\n1586#4:582\n1661#4,3:583\n1586#4:587\n1661#4,2:588\n1663#4:596\n777#4:608\n873#4,2:609\n1586#4:612\n1661#4,3:613\n1586#4:617\n1661#4,2:618\n1663#4:626\n*S KotlinDebug\n*F\n+ 1 args.kt\ncom/intellij/platform/util/ArgsParser$ArgInfo\n*L\n160#1:265\n163#1:351\n165#1:382\n166#1:412\n175#1:448\n177#1:483\n178#1:513\n180#1:544\n181#1:574\n160#1:236\n160#1:237,2\n160#1:242\n160#1:247\n160#1:251,6\n160#1:258,7\n160#1:266,5\n161#1:271,2\n161#1:276\n161#1:281\n161#1:285,6\n161#1:292\n162#1:293,10\n162#1:306\n162#1:311\n162#1:315,6\n162#1:322\n162#1:323,4\n163#1:327\n163#1:328,2\n163#1:333\n163#1:338\n163#1:342,6\n163#1:349\n163#1:350\n163#1:352\n165#1:353\n165#1:354,2\n165#1:359\n165#1:364\n165#1:368,6\n165#1:375,7\n165#1:383,5\n166#1:388\n166#1:389,2\n166#1:394\n166#1:399\n166#1:403,6\n166#1:410\n166#1:411\n166#1:413\n175#1:414,5\n175#1:419\n175#1:420,2\n175#1:425\n175#1:430\n175#1:434,6\n175#1:441,7\n175#1:449,5\n177#1:454\n177#1:455,2\n177#1:460\n177#1:465\n177#1:469,6\n177#1:476,7\n177#1:484,5\n178#1:489\n178#1:490,2\n178#1:495\n178#1:500\n178#1:504,6\n178#1:511\n178#1:512\n178#1:514\n180#1:515\n180#1:516,2\n180#1:521\n180#1:526\n180#1:530,6\n180#1:537,7\n180#1:545,5\n181#1:550\n181#1:551,2\n181#1:556\n181#1:561\n181#1:565,6\n181#1:572\n181#1:573\n181#1:575\n183#1:576,2\n183#1:581\n183#1:586\n183#1:590,6\n183#1:597\n185#1:598,10\n185#1:611\n185#1:616\n185#1:620,6\n185#1:627\n185#1:628,4\n160#1:239\n160#1:240,2\n160#1:243\n160#1:244,3\n160#1:248\n160#1:249,2\n160#1:257\n161#1:273\n161#1:274,2\n161#1:277\n161#1:278,3\n161#1:282\n161#1:283,2\n161#1:291\n162#1:303\n162#1:304,2\n162#1:307\n162#1:308,3\n162#1:312\n162#1:313,2\n162#1:321\n163#1:330\n163#1:331,2\n163#1:334\n163#1:335,3\n163#1:339\n163#1:340,2\n163#1:348\n165#1:356\n165#1:357,2\n165#1:360\n165#1:361,3\n165#1:365\n165#1:366,2\n165#1:374\n166#1:391\n166#1:392,2\n166#1:395\n166#1:396,3\n166#1:400\n166#1:401,2\n166#1:409\n175#1:422\n175#1:423,2\n175#1:426\n175#1:427,3\n175#1:431\n175#1:432,2\n175#1:440\n177#1:457\n177#1:458,2\n177#1:461\n177#1:462,3\n177#1:466\n177#1:467,2\n177#1:475\n178#1:492\n178#1:493,2\n178#1:496\n178#1:497,3\n178#1:501\n178#1:502,2\n178#1:510\n180#1:518\n180#1:519,2\n180#1:522\n180#1:523,3\n180#1:527\n180#1:528,2\n180#1:536\n181#1:553\n181#1:554,2\n181#1:557\n181#1:558,3\n181#1:562\n181#1:563,2\n181#1:571\n183#1:578\n183#1:579,2\n183#1:582\n183#1:583,3\n183#1:587\n183#1:588,2\n183#1:596\n185#1:608\n185#1:609,2\n185#1:612\n185#1:613,3\n185#1:617\n185#1:618,2\n185#1:626\n*E\n"})
    public final class ArgInfo {
        @NotNull
        private final String name;
        @NotNull
        private final String description;
        private boolean hidden;
        private boolean optional;
        @Nullable
        private String deprecated;
        @NotNull
        private final Function1<String, Boolean> toBoolean;
        @NotNull
        private final Function1<String, Integer> toInt;
        @NotNull
        private final Function1<String, Path> toFile;

        public ArgInfo(@NotNull String name, String description) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(description, "description");
            this.name = name;
            this.description = description;
            this.toBoolean = ArgInfo::toBoolean$lambda$0;
            this.toInt = ArgInfo::toInt$lambda$0;
            this.toFile = ArgInfo::toFile$lambda$0;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final boolean getHidden() {
            return this.hidden;
        }

        public final void setHidden(boolean bl) {
            this.hidden = bl;
        }

        public final boolean getOptional() {
            return this.optional;
        }

        public final void setOptional(boolean bl) {
            this.optional = bl;
        }

        @Nullable
        public final String getDeprecated() {
            return this.deprecated;
        }

        public final void setDeprecated(@Nullable String string) {
            this.deprecated = string;
        }

        @NotNull
        public final ArgInfo hidden() {
            ArgInfo argInfo;
            ArgInfo $this$hidden_u24lambda_u240 = argInfo = this.optional();
            boolean bl = false;
            $this$hidden_u24lambda_u240.hidden = true;
            return argInfo;
        }

        @NotNull
        public final ArgInfo optional() {
            ArgInfo argInfo;
            ArgInfo $this$optional_u24lambda_u240 = argInfo = this;
            boolean bl = false;
            $this$optional_u24lambda_u240.optional = true;
            return argInfo;
        }

        @NotNull
        public final ArgInfo deprecated(@NotNull String message) {
            ArgInfo argInfo;
            Intrinsics.checkNotNullParameter(message, "message");
            ArgInfo $this$deprecated_u24lambda_u240 = argInfo = this;
            boolean bl = false;
            $this$deprecated_u24lambda_u240.deprecated = message;
            return argInfo;
        }

        @NotNull
        public final TypedArg<String> string(@Nullable Function0<String> function0) {
            return this.parse(arg_0 -> ArgInfo.string$lambda$0(function0, arg_0));
        }

        public static /* synthetic */ TypedArg string$default(ArgInfo argInfo, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                function0 = null;
            }
            return argInfo.string(function0);
        }

        @NotNull
        public final TypedArg<List<String>> strings() {
            return this.parse(ArgInfo::strings$lambda$0);
        }

        @NotNull
        public final TypedArg<List<String>> notEmptyStrings() {
            return this.parse(ArgInfo::notEmptyStrings$lambda$0);
        }

        @NotNull
        public final TypedArg<String> stringOrNull() {
            return this.optional().parse(ArgInfo::stringOrNull$lambda$0);
        }

        @NotNull
        public final TypedArg<Boolean> boolean(@NotNull Function0<Boolean> function0) {
            Intrinsics.checkNotNullParameter(function0, "default");
            return this.parse(arg_0 -> ArgInfo.boolean$lambda$1(this, function0, arg_0));
        }

        public static /* synthetic */ TypedArg boolean$default(ArgInfo argInfo, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                function0 = ArgInfo::boolean$lambda$0;
            }
            return argInfo.boolean(function0);
        }

        @NotNull
        public final TypedArg<Boolean> booleanOrNull() {
            return this.optional().parse(arg_0 -> ArgInfo.booleanOrNull$lambda$0(this, arg_0));
        }

        @NotNull
        public final TypedArg<Boolean> flag() {
            return this.optional().parse(arg_0 -> ArgInfo.flag$lambda$0(this, arg_0));
        }

        @NotNull
        public final TypedArg<Integer> int(@NotNull Function0<Integer> function0) {
            Intrinsics.checkNotNullParameter(function0, "default");
            return this.parse(arg_0 -> ArgInfo.int$lambda$0(this, function0, arg_0));
        }

        @NotNull
        public final TypedArg<Integer> toIntOrNull() {
            return this.optional().parse(arg_0 -> ArgInfo.toIntOrNull$lambda$0(this, arg_0));
        }

        @NotNull
        public final TypedArg<Path> file(@Nullable Function0<? extends Path> function0) {
            return this.parse(arg_0 -> ArgInfo.file$lambda$0(this, function0, arg_0));
        }

        public static /* synthetic */ TypedArg file$default(ArgInfo argInfo, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                function0 = null;
            }
            return argInfo.file(function0);
        }

        @NotNull
        public final TypedArg<Path> fileOrNull() {
            return this.optional().parse(arg_0 -> ArgInfo.fileOrNull$lambda$0(this, arg_0));
        }

        @NotNull
        public final TypedArg<List<Path>> files() {
            return this.parse(arg_0 -> ArgInfo.files$lambda$0(this, arg_0));
        }

        @NotNull
        public final TypedArg<List<Path>> notEmptyFiles() {
            return this.parse(arg_0 -> ArgInfo.notEmptyFiles$lambda$0(this, arg_0));
        }

        private final <T> TypedArg<T> parse(Function1<? super ArgsReader, ? extends T> compute) {
            String deprecated = this.deprecated;
            TypedArg<Object> arg = new TypedArg<Object>(this, () -> ArgInfo.parse$lambda$0(ArgsParser.this, this, deprecated, compute));
            ((Collection)ArgsParser.this.arguments).add(arg);
            return arg;
        }

        /*
         * WARNING - void declaration
         */
        private static final String string$lambda$0(Function0 $default, ArgsReader $this$parse) {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function0 defaultF$iv = $default;
            boolean $i$f$arg = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var9_12 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                void var17_20;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void it = value$iv$iv;
                    boolean bl2 = false;
                    var17_20 = it;
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(var17_20);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (values$iv.isEmpty()) {
                if (defaultF$iv == null) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is not specified";
                    throw new IllegalArgumentException(string.toString());
                }
                object = defaultF$iv.invoke();
            } else {
                if (!(values$iv.size() == 1)) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                    throw new IllegalArgumentException(string.toString());
                }
                object = CollectionsKt.first(values$iv);
            }
            return (String)object;
        }

        /*
         * WARNING - void declaration
         */
        private static final List strings$lambda$0(ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv;
            String it$iv;
            Iterable $this$filterTo$iv$iv$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader this_$iv = $this$parse;
            boolean $i$f$args = false;
            Iterable $this$filter$iv$iv = (Iterable)ArgsReader.access$getArgs$p(this_$iv).getValue();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                it$iv = (String)element$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv, ArgsReader.access$getKey$p(this_$iv), false, 2, null)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            Iterable $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                it$iv = (String)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv, (CharSequence)ArgsReader.access$getKey$p(this_$iv)));
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void var15_15;
                void value$iv;
                it$iv = (String)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl = false;
                try {
                    void it = value$iv;
                    boolean bl2 = false;
                    var15_15 = it;
                }
                catch (Exception e$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p(this_$iv) + " has incorrect value specified: " + (String)value$iv + ": " + e$iv.getMessage());
                }
                collection.add(var15_15);
            }
            return (List)destination$iv$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List notEmptyStrings$lambda$0(ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader this_$iv = $this$parse;
            boolean $i$f$nonEmptyArgs = false;
            ArgsReader this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p(this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p(this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p(this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                void var15_15;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void it = value$iv$iv;
                    boolean bl2 = false;
                    var15_15 = it;
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p(this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(var15_15);
            }
            List result$iv = (List)destination$iv$iv$iv$iv;
            if (result$iv.isEmpty()) {
                throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p(this_$iv) + " should be specified at least once");
            }
            return result$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final String stringOrNull$lambda$0(ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader this_$iv = $this$parse;
            boolean $i$f$argOrNull = false;
            ArgsReader this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p(this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p(this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p(this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                void var15_16;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void it = value$iv$iv;
                    boolean bl2 = false;
                    var15_16 = it;
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p(this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(var15_16);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (!(values$iv.size() <= 1)) {
                boolean bl = false;
                String string = "argument " + ArgsReader.access$getKey$p(this_$iv) + " is specified multiple times: " + values$iv;
                throw new IllegalArgumentException(string.toString());
            }
            return (String)CollectionsKt.firstOrNull(values$iv);
        }

        private static final boolean boolean$lambda$0() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean boolean$lambda$1(ArgInfo this$0, Function0 $default, ArgsReader $this$parse) {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Boolean> function1 = this$0.toBoolean;
            Function0 defaultF$iv = $default;
            boolean $i$f$arg = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var11_14 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Object r;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void map$iv;
                    r = map$iv.invoke(value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(r);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (values$iv.isEmpty()) {
                if (defaultF$iv == null) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is not specified";
                    throw new IllegalArgumentException(string.toString());
                }
                object = defaultF$iv.invoke();
            } else {
                if (!(values$iv.size() == 1)) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                    throw new IllegalArgumentException(string.toString());
                }
                object = CollectionsKt.first(values$iv);
            }
            return (Boolean)object;
        }

        /*
         * WARNING - void declaration
         */
        private static final Boolean booleanOrNull$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Boolean> map$iv = this$0.toBoolean;
            boolean $i$f$argOrNull = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Boolean bl;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl2 = false;
                try {
                    bl = map$iv.invoke((String)value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(bl);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (!(values$iv.size() <= 1)) {
                boolean bl = false;
                String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                throw new IllegalArgumentException(string.toString());
            }
            return (Boolean)CollectionsKt.firstOrNull(values$iv);
        }

        private static final boolean flag$lambda$0$0() {
            return true;
        }

        private static final boolean flag$lambda$0$1() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean flag$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Object object;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Boolean> function1 = this$0.toBoolean;
            Function0<Boolean> function0 = ArgInfo::flag$lambda$0$0;
            Function0<Boolean> whenNotProvided$iv = ArgInfo::flag$lambda$0$1;
            boolean $i$f$argWithoutValue = false;
            boolean withoutParam$iv = ((List)ArgsReader.access$getArgs$p((ArgsReader)this_$iv).getValue()).contains(ArgsReader.access$getKeyWithoutParameter$p((ArgsReader)this_$iv));
            if (withoutParam$iv) {
                void whenWithoutParameter$iv;
                object = whenWithoutParameter$iv.invoke();
            } else {
                Collection collection;
                Iterable $this$mapTo$iv$iv$iv$iv$iv;
                Iterable $this$map$iv$iv$iv$iv;
                String it$iv$iv$iv;
                void $this$filterTo$iv$iv$iv$iv$iv;
                Iterable $this$filter$iv$iv$iv$iv;
                void this_$iv$iv;
                void var8_8 = this_$iv;
                Function0<Boolean> defaultF$iv$iv = whenNotProvided$iv;
                boolean $i$f$arg = false;
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$args = false;
                Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv$iv).getValue();
                boolean $i$f$filter = false;
                void var15_18 = $this$filter$iv$iv$iv$iv;
                Collection destination$iv$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv$iv) {
                    it$iv$iv$iv = (String)element$iv$iv$iv$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(it$iv$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv$iv), false, 2, null)) continue;
                    destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
                }
                $this$filter$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv$iv$iv$iv = $this$map$iv$iv$iv$iv;
                destination$iv$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv$iv) {
                    it$iv$iv$iv = (String)item$iv$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv$iv;
                    boolean bl = false;
                    collection.add(StringsKt.removePrefix(it$iv$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv$iv)));
                }
                $this$map$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv$iv$iv = $this$map$iv$iv$iv$iv;
                destination$iv$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv$iv) {
                    Object r;
                    void value$iv$iv$iv;
                    it$iv$iv$iv = (String)item$iv$iv$iv$iv$iv;
                    collection = destination$iv$iv$iv$iv$iv;
                    boolean bl = false;
                    try {
                        void map$iv;
                        r = map$iv.invoke(value$iv$iv$iv);
                    }
                    catch (Exception e$iv$iv$iv) {
                        throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv$iv + ": " + e$iv$iv$iv.getMessage());
                    }
                    collection.add(r);
                }
                List values$iv$iv = (List)destination$iv$iv$iv$iv$iv;
                if (values$iv$iv.isEmpty()) {
                    if (defaultF$iv$iv == null) {
                        boolean bl = false;
                        String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " is not specified";
                        throw new IllegalArgumentException(string.toString());
                    }
                    object = defaultF$iv$iv.invoke();
                } else {
                    if (!(values$iv$iv.size() == 1)) {
                        boolean bl = false;
                        String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " is specified multiple times: " + values$iv$iv;
                        throw new IllegalArgumentException(string.toString());
                    }
                    object = CollectionsKt.first(values$iv$iv);
                }
            }
            return (Boolean)object;
        }

        /*
         * WARNING - void declaration
         */
        private static final int int$lambda$0(ArgInfo this$0, Function0 $default, ArgsReader $this$parse) {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Integer> function1 = this$0.toInt;
            Function0 defaultF$iv = $default;
            boolean $i$f$arg = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var11_14 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Object r;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void map$iv;
                    r = map$iv.invoke(value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(r);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (values$iv.isEmpty()) {
                if (defaultF$iv == null) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is not specified";
                    throw new IllegalArgumentException(string.toString());
                }
                object = defaultF$iv.invoke();
            } else {
                if (!(values$iv.size() == 1)) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                    throw new IllegalArgumentException(string.toString());
                }
                object = CollectionsKt.first(values$iv);
            }
            return ((Number)object).intValue();
        }

        /*
         * WARNING - void declaration
         */
        private static final Integer toIntOrNull$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Integer> map$iv = this$0.toInt;
            boolean $i$f$argOrNull = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Integer n;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    n = map$iv.invoke((String)value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(n);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (!(values$iv.size() <= 1)) {
                boolean bl = false;
                String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                throw new IllegalArgumentException(string.toString());
            }
            return (Integer)CollectionsKt.firstOrNull(values$iv);
        }

        /*
         * WARNING - void declaration
         */
        private static final Path file$lambda$0(ArgInfo this$0, Function0 $default, ArgsReader $this$parse) {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Path> function1 = this$0.toFile;
            Function0 defaultF$iv = $default;
            boolean $i$f$arg = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var11_14 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Object r;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    void map$iv;
                    r = map$iv.invoke(value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(r);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (values$iv.isEmpty()) {
                if (defaultF$iv == null) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is not specified";
                    throw new IllegalArgumentException(string.toString());
                }
                object = defaultF$iv.invoke();
            } else {
                if (!(values$iv.size() == 1)) {
                    boolean bl = false;
                    String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                    throw new IllegalArgumentException(string.toString());
                }
                object = CollectionsKt.first(values$iv);
            }
            return (Path)object;
        }

        /*
         * WARNING - void declaration
         */
        private static final Path fileOrNull$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Path> map$iv = this$0.toFile;
            boolean $i$f$argOrNull = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Path path;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    path = map$iv.invoke((String)value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(path);
            }
            List values$iv = (List)destination$iv$iv$iv$iv;
            if (!(values$iv.size() <= 1)) {
                boolean bl = false;
                String string = "argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " is specified multiple times: " + values$iv;
                throw new IllegalArgumentException(string.toString());
            }
            return (Path)CollectionsKt.firstOrNull(values$iv);
        }

        /*
         * WARNING - void declaration
         */
        private static final List files$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv;
            String it$iv;
            void $this$filterTo$iv$iv$iv;
            Iterable $this$filter$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Path> map$iv = this$0.toFile;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv).getValue();
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                it$iv = (String)element$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv), false, 2, null)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filter$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                it$iv = (String)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv)));
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                Path path;
                void value$iv;
                it$iv = (String)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl = false;
                try {
                    path = map$iv.invoke((String)value$iv);
                }
                catch (Exception e$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " has incorrect value specified: " + (String)value$iv + ": " + e$iv.getMessage());
                }
                collection.add(path);
            }
            return (List)destination$iv$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List notEmptyFiles$lambda$0(ArgInfo this$0, ArgsReader $this$parse) {
            Collection collection;
            Iterable $this$mapTo$iv$iv$iv$iv;
            Iterable $this$map$iv$iv$iv;
            String it$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            Iterable $this$filter$iv$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter($this$parse, "$this$parse");
            ArgsReader argsReader = $this$parse;
            Function1<String, Path> map$iv = this$0.toFile;
            boolean $i$f$nonEmptyArgs = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$args = false;
            Iterable iterable = (Iterable)ArgsReader.access$getArgs$p((ArgsReader)this_$iv$iv).getValue();
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                it$iv$iv = (String)element$iv$iv$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it$iv$iv, ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv), false, 2, null)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $this$filter$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.removePrefix(it$iv$iv, (CharSequence)ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv)));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                Path path;
                void value$iv$iv;
                it$iv$iv = (String)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl = false;
                try {
                    path = map$iv.invoke((String)value$iv$iv);
                }
                catch (Exception e$iv$iv) {
                    throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv$iv) + " has incorrect value specified: " + (String)value$iv$iv + ": " + e$iv$iv.getMessage());
                }
                collection.add(path);
            }
            List result$iv = (List)destination$iv$iv$iv$iv;
            if (result$iv.isEmpty()) {
                throw new IllegalArgumentException("argument " + ArgsReader.access$getKey$p((ArgsReader)this_$iv) + " should be specified at least once");
            }
            return result$iv;
        }

        private static final boolean toBoolean$lambda$0(String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            if (!(Intrinsics.areEqual(string, "true") || Intrinsics.areEqual(string, "false"))) {
                boolean bl = false;
                String string2 = "wrong boolean value: " + string;
                throw new IllegalArgumentException(string2.toString());
            }
            return Intrinsics.areEqual(string, "true");
        }

        private static final int toInt$lambda$0(String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            return Integer.parseInt(string);
        }

        private static final Path toFile$lambda$0(String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Path path = Paths.get(it, new String[0]).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(path, "toAbsolutePath(...)");
            return path;
        }

        private static final Object parse$lambda$0(ArgsParser this$0, ArgInfo this$1, String $deprecated, Function1 $compute) {
            ArgsReader reader = this$0.args.forName(this$1.name);
            if ($deprecated != null) {
                reader.reportDeprecatedUsage($deprecated);
            }
            return $compute.invoke(reader);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0000\"\u0004\b\u0001\u0010\u00152\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00150\u0011J\r\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J\u000b\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J&\u0010\u0018\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0086\u0002\u00a2\u0006\u0002\u0010\u001dR\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/util/ArgsParser$TypedArg;", "T", "", "info", "Lcom/intellij/platform/util/ArgsParser$ArgInfo;", "Lcom/intellij/platform/util/ArgsParser;", "computeValue", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/platform/util/ArgsParser$ArgInfo;Lkotlin/jvm/functions/Function0;)V", "getInfo", "()Lcom/intellij/platform/util/ArgsParser$ArgInfo;", "delegate", "paramValue", "Lkotlin/Lazy;", "andApply", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "andMap", "Y", "parseValue", "parseValue$intellij_platform_util", "getValue", "()Ljava/lang/Object;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nargs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 args.kt\ncom/intellij/platform/util/ArgsParser$TypedArg\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
    public static final class TypedArg<T> {
        @NotNull
        private final ArgInfo info;
        @NotNull
        private final Function0<T> computeValue;
        @Nullable
        private TypedArg<?> delegate;
        @NotNull
        private final Lazy<T> paramValue;

        public TypedArg(@NotNull ArgInfo info, @NotNull Function0<? extends T> computeValue) {
            Intrinsics.checkNotNullParameter(info, "info");
            Intrinsics.checkNotNullParameter(computeValue, "computeValue");
            this.info = info;
            this.computeValue = computeValue;
            this.paramValue = LazyKt.lazy(() -> TypedArg.paramValue$lambda$0(this));
        }

        @NotNull
        public final ArgInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final TypedArg<T> andApply(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            return this.andMap(arg_0 -> TypedArg.andApply$lambda$0(action, arg_0));
        }

        @NotNull
        public final <Y> TypedArg<Y> andMap(@NotNull Function1<? super T, ? extends Y> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            if (!(!this.paramValue.isInitialized() && this.delegate == null)) {
                boolean bl = false;
                String string = "cannot apply transformations to the computed value: " + this;
                throw new IllegalArgumentException(string.toString());
            }
            TypedArg<Object> newArgs = new TypedArg<Object>(this.info, () -> TypedArg.andMap$lambda$1(action, this));
            this.delegate = newArgs;
            return newArgs;
        }

        public final void parseValue$intellij_platform_util() {
            TypedArg typedArg = this.delegate;
            if (typedArg == null) {
                typedArg = this;
            }
            typedArg.getValue();
        }

        public final T getValue() {
            return this.paramValue.getValue();
        }

        public final T getValue(@Nullable Object thisRef, @Nullable KProperty<?> property) {
            return this.getValue();
        }

        private static final Object paramValue$lambda$0(TypedArg this$0) {
            return this$0.computeValue.invoke();
        }

        private static final Object andApply$lambda$0(Function1 $action, Object it) {
            Object object = it;
            $action.invoke(object);
            return object;
        }

        private static final Object andMap$lambda$1(Function1 $action, TypedArg this$0) {
            return $action.invoke(this$0.getValue());
        }
    }
}

