/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternUtil {
    private static final Logger LOG = Logger.getInstance(PatternUtil.class);
    public static final Pattern NOTHING = Pattern.compile("(a\\A)");
    private static final Map<String, String> ourEscapeRules = new LinkedHashMap<String, String>();
    private static final String REGEX_META_CHARS = ".$|()[{^?*+\\";

    @NotNull
    public static String convertToRegex(@NotNull String mask) {
        if (mask == null) {
            PatternUtil.$$$reportNull$$$0(0);
        }
        List<String> strings = StringUtil.split(mask, "\\");
        StringBuilder pattern = new StringBuilder();
        String separator = "";
        for (String string : strings) {
            string = StringUtil.replace(string, ".", "\\.");
            for (Map.Entry<String, String> e : ourEscapeRules.entrySet()) {
                string = StringUtil.replace(string, e.getKey(), e.getValue());
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string);
        }
        String string = pattern.toString();
        if (string == null) {
            PatternUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Pattern fromMask(@NotNull String mask) {
        if (mask == null) {
            PatternUtil.$$$reportNull$$$0(2);
        }
        return PatternUtil.fromMask(mask, 0);
    }

    @NotNull
    public static Pattern fromMask(@NotNull String mask, int flags) {
        Pattern pattern;
        if (mask == null) {
            PatternUtil.$$$reportNull$$$0(3);
        }
        try {
            pattern = Pattern.compile(PatternUtil.convertToRegex(mask), flags);
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            Pattern pattern2 = NOTHING;
            if (pattern2 == null) {
                PatternUtil.$$$reportNull$$$0(5);
            }
            return pattern2;
        }
        if (pattern == null) {
            PatternUtil.$$$reportNull$$$0(4);
        }
        return pattern;
    }

    @Contract(value="_, !null->!null")
    public static Pattern compileSafe(String pattern, Pattern def) {
        try {
            return Pattern.compile(pattern);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Nullable
    public static String getFirstMatch(List<String> lines, Pattern regex) {
        if (lines == null) {
            return null;
        }
        for (String s : lines) {
            Matcher m = regex.matcher(s);
            if (!m.matches() || m.groupCount() <= 0) continue;
            return m.group(1);
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsMetaChar(@NotNull String text) {
        if (text == null) {
            PatternUtil.$$$reportNull$$$0(6);
        }
        return StringUtil.containsAnyChar(text, REGEX_META_CHARS);
    }

    static {
        ourEscapeRules.put("*", ".*");
        ourEscapeRules.put("?", ".");
        for (char c : "+()[]/^${}|".toCharArray()) {
            ourEscapeRules.put(String.valueOf(c), "\\" + c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PatternUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PatternUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRegex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToRegex";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromMask";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsMetaChar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

