/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.Minimatch;
import com.intellij.util.text.minimatch.MinimatchOptions;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u001a\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u001a\"\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0014\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "GLOBSTAR", "Lcom/intellij/util/text/minimatch/GlobStar;", "hasBraces", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "slashSplit", "QMARK", "", "STAR", "reSpecials", "minimatch", "", "p", "pattern", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "replaceEscapedBackSlash", "s", "unescape", "globUnescape", "minimatchAll", "path", "", "", "patterns", "Lcom/intellij/util/text/minimatch/Minimatch;", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nMinimatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/MinimatchKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,782:1\n13#2:783\n*S KotlinDebug\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/MinimatchKt\n*L\n33#1:783\n*E\n"})
public final class MinimatchKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final GlobStar GLOBSTAR;
    private static final Pattern hasBraces;
    private static final Pattern slashSplit;
    @NotNull
    private static final String QMARK = "[^/]";
    @NotNull
    private static final String STAR = "[^/]*?";
    @NotNull
    private static final String reSpecials = "().*{}+?[]^$\\!";
    private static final Pattern unescape;

    @JvmOverloads
    public static final boolean minimatch(@NotNull String p, @NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(options, "options");
        if (StringsKt.isBlank(pattern)) {
            return ((CharSequence)p).length() == 0;
        }
        if (!options.getNocomment() && StringsKt.startsWith$default((CharSequence)pattern, '#', false, 2, null)) {
            return false;
        }
        return Minimatch.match$default(new Minimatch(pattern, options), p, false, 2, null);
    }

    public static /* synthetic */ boolean minimatch$default(String string, String string2, MinimatchOptions minimatchOptions, int n, Object object) {
        if ((n & 4) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        return MinimatchKt.minimatch(string, string2, minimatchOptions);
    }

    @NotNull
    public static final String replaceEscapedBackSlash(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        return StringsKt.replace$default(s, "\\\\", "/", false, 4, null);
    }

    @NotNull
    public static final String globUnescape(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        String string = unescape.matcher(s).replaceAll("$1");
        Intrinsics.checkNotNullExpressionValue(string, "replaceAll(...)");
        return string;
    }

    public static final boolean minimatchAll(@NotNull List<? extends CharSequence> path, @NotNull List<Minimatch> patterns) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        boolean match = false;
        for (Minimatch pattern : patterns) {
            if (match != pattern.getNegate()) continue;
            match = Minimatch.match$default(pattern, path, false, 2, null);
        }
        return match;
    }

    @JvmOverloads
    public static final boolean minimatch(@NotNull String p, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return MinimatchKt.minimatch$default(p, pattern, null, 4, null);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pattern access$getSlashSplit$p() {
        return slashSplit;
    }

    public static final /* synthetic */ GlobStar access$getGLOBSTAR$p() {
        return GLOBSTAR;
    }

    public static final /* synthetic */ Pattern access$getHasBraces$p() {
        return hasBraces;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Minimatch.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        GLOBSTAR = new GlobStar();
        hasBraces = Pattern.compile("\\{.*}");
        slashSplit = Pattern.compile("/+");
        unescape = Pattern.compile("\\\\(.)");
    }
}

