/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.patterns;

import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolModifier;
import com.intellij.polySymbols.PolySymbolQualifiedName;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.polySymbols.impl.PolySymbolsImplUtilsKt;
import com.intellij.polySymbols.patterns.PolySymbolPatternSymbolsResolver;
import com.intellij.polySymbols.query.PolySymbolMatch;
import com.intellij.polySymbols.query.PolySymbolNameConversionRules;
import com.intellij.polySymbols.query.PolySymbolQueryExecutor;
import com.intellij.polySymbols.query.PolySymbolQueryStack;
import com.intellij.polySymbols.webTypes.filters.PolySymbolFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\r\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver;", "Lcom/intellij/polySymbols/patterns/PolySymbolPatternSymbolsResolver;", "items", "", "Lcom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver$Reference;", "<init>", "([Lcom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver$Reference;)V", "[Lcom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver$Reference;", "getSymbolKinds", "", "Lcom/intellij/polySymbols/PolySymbolKind;", "context", "Lcom/intellij/polySymbols/PolySymbol;", "delegate", "getDelegate", "()Lcom/intellij/polySymbols/PolySymbol;", "codeCompletion", "", "Lcom/intellij/polySymbols/completion/PolySymbolCodeCompletionItem;", "name", "", "position", "", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "queryExecutor", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutor;", "matchName", "listSymbols", "expandPatterns", "", "Reference", "intellij.platform.polySymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPolySymbolPatternReferenceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolySymbolPatternReferenceResolver.kt\ncom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n10574#2:105\n11007#2,5:106\n10574#2:111\n11007#2,5:112\n*S KotlinDebug\n*F\n+ 1 PolySymbolPatternReferenceResolver.kt\ncom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver\n*L\n31#1:105\n31#1:106,5\n50#1:111\n50#1:112,5\n*E\n"})
public final class PolySymbolPatternReferenceResolver
implements PolySymbolPatternSymbolsResolver {
    @NotNull
    private final Reference[] items;

    public PolySymbolPatternReferenceResolver(Reference ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        this.items = items;
    }

    @Override
    @NotNull
    public Set<PolySymbolKind> getSymbolKinds(@Nullable PolySymbol context) {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])this.items), PolySymbolPatternReferenceResolver::getSymbolKinds$lambda$0));
    }

    @Override
    @Nullable
    public PolySymbol getDelegate() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PolySymbolCodeCompletionItem> codeCompletion(@NotNull String name, int position, @NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Reference[] $this$flatMap$iv = this.items;
        boolean $i$f$flatMap = false;
        Reference[] referenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = it.codeCompletion(name, stack, queryExecutor, position);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<PolySymbol> matchName(@NotNull String name, @NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)ArraysKt.asSequence((Object[])this.items), arg_0 -> PolySymbolPatternReferenceResolver.matchName$lambda$0(name, stack, queryExecutor, arg_0)), PolySymbolPatternReferenceResolver::matchName$lambda$1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PolySymbol> listSymbols(@NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor, boolean expandPatterns) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Reference[] $this$flatMap$iv = this.items;
        boolean $i$f$flatMap = false;
        Reference[] referenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = it.listSymbols(stack, queryExecutor, expandPatterns);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PolySymbolKind getSymbolKinds$lambda$0(Reference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKind();
    }

    private static final Iterable matchName$lambda$0(String $name, PolySymbolQueryStack $stack, PolySymbolQueryExecutor $queryExecutor, Reference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolve($name, $stack, $queryExecutor);
    }

    private static final Iterable matchName$lambda$1(PolySymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PolySymbolMatch && ((PolySymbolMatch)it).getNameSegments().size() == 1 && PolySymbolsImplUtilsKt.canUnwrapSymbols(((PolySymbolMatch)it).getNameSegments().get(0)) ? ((PolySymbolMatch)it).getNameSegments().get(0).getSymbols() : CollectionsKt.listOf((Object)it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J,\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0003JO\u0010+\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u00c6\u0001J\u0014\u0010,\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010.\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010/\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u00060"}, d2={"Lcom/intellij/polySymbols/patterns/PolySymbolPatternReferenceResolver$Reference;", "", "location", "", "Lcom/intellij/polySymbols/PolySymbolQualifiedName;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "filter", "Lcom/intellij/polySymbols/webTypes/filters/PolySymbolFilter;", "excludeModifiers", "Lcom/intellij/polySymbols/PolySymbolModifier;", "nameConversionRules", "Lcom/intellij/polySymbols/query/PolySymbolNameConversionRules;", "<init>", "(Ljava/util/List;Lcom/intellij/polySymbols/PolySymbolKind;Lcom/intellij/polySymbols/webTypes/filters/PolySymbolFilter;Ljava/util/List;Ljava/util/List;)V", "getLocation", "()Ljava/util/List;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "getFilter", "()Lcom/intellij/polySymbols/webTypes/filters/PolySymbolFilter;", "getExcludeModifiers", "getNameConversionRules", "resolve", "Lcom/intellij/polySymbols/PolySymbol;", "name", "", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "queryExecutor", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutor;", "listSymbols", "expandPatterns", "", "codeCompletion", "Lcom/intellij/polySymbols/completion/PolySymbolCodeCompletionItem;", "position", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "intellij.platform.polySymbols"})
    public static final class Reference {
        @NotNull
        private final List<PolySymbolQualifiedName> location;
        @NotNull
        private final PolySymbolKind kind;
        @Nullable
        private final PolySymbolFilter filter;
        @NotNull
        private final List<PolySymbolModifier> excludeModifiers;
        @NotNull
        private final List<PolySymbolNameConversionRules> nameConversionRules;

        public Reference(@NotNull List<? extends PolySymbolQualifiedName> location, @NotNull PolySymbolKind kind, @Nullable PolySymbolFilter filter, @NotNull List<? extends PolySymbolModifier> excludeModifiers, @NotNull List<? extends PolySymbolNameConversionRules> nameConversionRules) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(excludeModifiers, (String)"excludeModifiers");
            Intrinsics.checkNotNullParameter(nameConversionRules, (String)"nameConversionRules");
            this.location = location;
            this.kind = kind;
            this.filter = filter;
            this.excludeModifiers = excludeModifiers;
            this.nameConversionRules = nameConversionRules;
        }

        public /* synthetic */ Reference(List list2, PolySymbolKind polySymbolKind, PolySymbolFilter polySymbolFilter, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                polySymbolFilter = null;
            }
            if ((n & 8) != 0) {
                list3 = CollectionsKt.listOf((Object)PolySymbolModifier.ABSTRACT);
            }
            if ((n & 0x10) != 0) {
                list4 = CollectionsKt.emptyList();
            }
            this(list2, polySymbolKind, polySymbolFilter, list3, list4);
        }

        @NotNull
        public final List<PolySymbolQualifiedName> getLocation() {
            return this.location;
        }

        @NotNull
        public final PolySymbolKind getKind() {
            return this.kind;
        }

        @Nullable
        public final PolySymbolFilter getFilter() {
            return this.filter;
        }

        @NotNull
        public final List<PolySymbolModifier> getExcludeModifiers() {
            return this.excludeModifiers;
        }

        @NotNull
        public final List<PolySymbolNameConversionRules> getNameConversionRules() {
            return this.nameConversionRules;
        }

        @NotNull
        public final List<PolySymbol> resolve(@NotNull String name, @NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<PolySymbol> matches = queryExecutor.withNameConversionRules(this.nameConversionRules).nameMatchQuery(CollectionsKt.plus((Collection)this.location, (Object)this.kind.withName(name)), (Function1<? super PolySymbolQueryExecutor.NameMatchQueryBuilder, Unit>)((Function1)arg_0 -> Reference.resolve$lambda$0(this, stack, arg_0)));
            if (this.filter == null) {
                return matches;
            }
            return this.filter.filterNameMatches(matches, queryExecutor, stack, MapsKt.emptyMap());
        }

        @NotNull
        public final List<PolySymbol> listSymbols(@NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor, boolean expandPatterns) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<PolySymbol> symbols = queryExecutor.withNameConversionRules(this.nameConversionRules).listSymbolsQuery(this.location, this.kind, expandPatterns, (Function1<? super PolySymbolQueryExecutor.ListSymbolsQueryBuilder, Unit>)((Function1)arg_0 -> Reference.listSymbols$lambda$0(this, stack, arg_0)));
            if (this.filter == null) {
                return symbols;
            }
            return this.filter.filterNameMatches(symbols, queryExecutor, stack, MapsKt.emptyMap());
        }

        @NotNull
        public final List<PolySymbolCodeCompletionItem> codeCompletion(@NotNull String name, @NotNull PolySymbolQueryStack stack, @NotNull PolySymbolQueryExecutor queryExecutor, int position) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<PolySymbolCodeCompletionItem> codeCompletions = queryExecutor.withNameConversionRules(this.nameConversionRules).codeCompletionQuery(CollectionsKt.plus((Collection)this.location, (Object)this.kind.withName(name)), position, (Function1<? super PolySymbolQueryExecutor.CodeCompletionQueryBuilder, Unit>)((Function1)arg_0 -> Reference.codeCompletion$lambda$0(this, stack, arg_0)));
            if (this.filter == null) {
                return codeCompletions;
            }
            return this.filter.filterCodeCompletions(codeCompletions, queryExecutor, stack, MapsKt.emptyMap());
        }

        @NotNull
        public final List<PolySymbolQualifiedName> component1() {
            return this.location;
        }

        @NotNull
        public final PolySymbolKind component2() {
            return this.kind;
        }

        @Nullable
        public final PolySymbolFilter component3() {
            return this.filter;
        }

        @NotNull
        public final List<PolySymbolModifier> component4() {
            return this.excludeModifiers;
        }

        @NotNull
        public final List<PolySymbolNameConversionRules> component5() {
            return this.nameConversionRules;
        }

        @NotNull
        public final Reference copy(@NotNull List<? extends PolySymbolQualifiedName> location, @NotNull PolySymbolKind kind, @Nullable PolySymbolFilter filter, @NotNull List<? extends PolySymbolModifier> excludeModifiers, @NotNull List<? extends PolySymbolNameConversionRules> nameConversionRules) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(excludeModifiers, (String)"excludeModifiers");
            Intrinsics.checkNotNullParameter(nameConversionRules, (String)"nameConversionRules");
            return new Reference(location, kind, filter, excludeModifiers, nameConversionRules);
        }

        public static /* synthetic */ Reference copy$default(Reference reference, List list2, PolySymbolKind polySymbolKind, PolySymbolFilter polySymbolFilter, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = reference.location;
            }
            if ((n & 2) != 0) {
                polySymbolKind = reference.kind;
            }
            if ((n & 4) != 0) {
                polySymbolFilter = reference.filter;
            }
            if ((n & 8) != 0) {
                list3 = reference.excludeModifiers;
            }
            if ((n & 0x10) != 0) {
                list4 = reference.nameConversionRules;
            }
            return reference.copy(list2, polySymbolKind, polySymbolFilter, list3, list4);
        }

        @NotNull
        public String toString() {
            return "Reference(location=" + this.location + ", kind=" + this.kind + ", filter=" + this.filter + ", excludeModifiers=" + this.excludeModifiers + ", nameConversionRules=" + this.nameConversionRules + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.location).hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + (this.filter == null ? 0 : this.filter.hashCode());
            result2 = result2 * 31 + ((Object)this.excludeModifiers).hashCode();
            result2 = result2 * 31 + ((Object)this.nameConversionRules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)other;
            if (!Intrinsics.areEqual(this.location, reference.location)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)reference.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filter, (Object)reference.filter)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.excludeModifiers, reference.excludeModifiers)) {
                return false;
            }
            return Intrinsics.areEqual(this.nameConversionRules, reference.nameConversionRules);
        }

        private static final Unit resolve$lambda$0(Reference this$0, PolySymbolQueryStack $stack, PolySymbolQueryExecutor.NameMatchQueryBuilder $this$nameMatchQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$nameMatchQuery, (String)"$this$nameMatchQuery");
            $this$nameMatchQuery.exclude((Collection<PolySymbolModifier>)this$0.excludeModifiers);
            $this$nameMatchQuery.additionalScope($stack);
            return Unit.INSTANCE;
        }

        private static final Unit listSymbols$lambda$0(Reference this$0, PolySymbolQueryStack $stack, PolySymbolQueryExecutor.ListSymbolsQueryBuilder $this$listSymbolsQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$listSymbolsQuery, (String)"$this$listSymbolsQuery");
            $this$listSymbolsQuery.exclude((Collection<PolySymbolModifier>)this$0.excludeModifiers);
            $this$listSymbolsQuery.additionalScope($stack);
            return Unit.INSTANCE;
        }

        private static final Unit codeCompletion$lambda$0(Reference this$0, PolySymbolQueryStack $stack, PolySymbolQueryExecutor.CodeCompletionQueryBuilder $this$codeCompletionQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$codeCompletionQuery, (String)"$this$codeCompletionQuery");
            $this$codeCompletionQuery.exclude((Collection<PolySymbolModifier>)this$0.excludeModifiers);
            $this$codeCompletionQuery.additionalScope($stack);
            return Unit.INSTANCE;
        }
    }
}

