/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.AbstractHProfNavigatorReadBuffer;
import com.intellij.util.lang.ByteBufferCleaner;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0019H\u0016J\b\u0010\u0015\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diagnostic/hprof/util/HProfReadBufferSlidingWindow;", "Lcom/intellij/diagnostic/hprof/util/AbstractHProfNavigatorReadBuffer;", "channel", "Ljava/nio/channels/FileChannel;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "<init>", "(Ljava/nio/channels/FileChannel;Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;)V", "bufferSize", "", "size", "buffer", "Ljava/nio/ByteBuffer;", "bufferOffset", "close", "", "position", "newPosition", "remapBuffer", "isEof", "", "get", "bytes", "", "getByteBuffer", "", "", "getShort", "", "getInt", "getLong", "intellij.platform.ide.impl"})
public final class HProfReadBufferSlidingWindow
extends AbstractHProfNavigatorReadBuffer {
    @NotNull
    private final FileChannel channel;
    private final long bufferSize;
    private final long size;
    @NotNull
    private ByteBuffer buffer;
    private long bufferOffset;

    public HProfReadBufferSlidingWindow(@NotNull FileChannel channel, @NotNull HProfEventBasedParser parser) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
        this.channel = channel;
        this.bufferSize = 10000000L;
        this.size = this.channel.size();
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferOffset, Math.min(this.bufferSize, this.size));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
        this.buffer = mappedByteBuffer;
    }

    @Override
    public void close() {
        ByteBufferCleaner.unmapBuffer((ByteBuffer)this.buffer);
    }

    @Override
    public void position(long newPosition) {
        if (newPosition >= this.bufferOffset && newPosition <= this.bufferOffset + this.bufferSize) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
        } else {
            this.remapBuffer(newPosition);
        }
    }

    private final void remapBuffer(long newPosition) {
        ByteBuffer oldBuffer = this.buffer;
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, newPosition, Math.min(this.bufferSize, this.size - newPosition));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
        this.buffer = mappedByteBuffer;
        this.bufferOffset = newPosition;
        ByteBufferCleaner.unmapBuffer((ByteBuffer)oldBuffer);
    }

    @Override
    public boolean isEof() {
        return this.position() == this.size;
    }

    @Override
    public long position() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public void get(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length <= this.buffer.remaining()) {
            this.buffer.get(bytes);
        } else {
            int remaining = bytes.length;
            int offset = 0;
            while (remaining > 0) {
                this.remapBuffer(this.position());
                int bytesToFetch = Math.min(remaining, (int)this.bufferSize);
                this.buffer.get(bytes, offset, bytesToFetch);
                remaining -= bytesToFetch;
                offset += bytesToFetch;
            }
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(int size2) {
        boolean useSlice = false;
        if (size2 < this.buffer.remaining()) {
            useSlice = true;
        } else if ((long)size2 < this.bufferSize) {
            this.remapBuffer(this.position());
            useSlice = true;
        }
        if (useSlice) {
            ByteBuffer slicedBuffer = this.buffer.slice();
            slicedBuffer.limit(size2);
            this.skip(size2);
            ByteBuffer byteBuffer = slicedBuffer.asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
            return byteBuffer;
        }
        byte[] bytes = new byte[size2];
        this.get(bytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    @Override
    public byte get() {
        if (this.buffer.remaining() < 1) {
            this.remapBuffer(this.position());
        }
        return this.buffer.get();
    }

    @Override
    public short getShort() {
        if (this.buffer.remaining() < 2) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getShort();
    }

    @Override
    public int getInt() {
        if (this.buffer.remaining() < 4) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        if (this.buffer.remaining() < 8) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getLong();
    }
}

