/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.comments.CommentLineData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class CommentLineDataBuilder
extends FormatterTagHandler {
    private static final String DOC_WHITESPACE = "\t ";

    public CommentLineDataBuilder(CodeStyleSettings settings) {
        super(settings);
    }

    @Nullable
    public abstract List<CommentLineData> getLines();

    @NotNull
    public abstract CommentLineData parseLine(@NotNull String var1);

    protected static int nextNonWhitespace(String str, int from) {
        int result2 = CharArrayUtil.shiftForward((CharSequence)str, (int)from, (String)DOC_WHITESPACE);
        return result2 == str.length() ? -1 : result2;
    }

    protected static int nextWhitespace(String str, int from) {
        return StringUtil.indexOfAny((String)str, (String)DOC_WHITESPACE, (int)from, (int)str.length());
    }

    protected static int skipNextWord(String str, int from) {
        int next = CommentLineDataBuilder.nextNonWhitespace(str, from);
        if (next >= 0) {
            next = CommentLineDataBuilder.nextWhitespace(str, next);
        }
        return next;
    }
}

