/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class CloseAllUnpinnedEditorsAction
extends CloseEditorsActionBase {
    CloseAllUnpinnedEditorsAction() {
    }

    @Override
    protected boolean isFileToClose(@NotNull EditorComposite editor2, @NotNull EditorWindow window, @NotNull FileEditorManagerEx fileEditorManager) {
        if (editor2 == null) {
            CloseAllUnpinnedEditorsAction.$$$reportNull$$$0(0);
        }
        if (window == null) {
            CloseAllUnpinnedEditorsAction.$$$reportNull$$$0(1);
        }
        if (fileEditorManager == null) {
            CloseAllUnpinnedEditorsAction.$$$reportNull$$$0(2);
        }
        return !window.isFilePinned(editor2.getFile());
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        if (inSplitter) {
            return IdeBundle.message((String)"action.close.all.unpinned.editors.in.tab.group", (Object[])new Object[0]);
        }
        return IdeBundle.message((String)"action.close.all.unpinned.editors", (Object[])new Object[0]);
    }

    @Override
    protected boolean isActionEnabled(Project project2, AnActionEvent event) {
        List<Pair<EditorComposite, EditorWindow>> filesToClose = this.getFilesToClose(event);
        if (filesToClose.isEmpty()) {
            return false;
        }
        HashSet<EditorWindow> checked = new HashSet<EditorWindow>();
        boolean hasPinned = false;
        boolean hasUnpinned = false;
        for (Pair<EditorComposite, EditorWindow> pair : filesToClose) {
            EditorWindow window = (EditorWindow)pair.second;
            if (!checked.add(window)) continue;
            for (EditorComposite composite2 : window.getAllComposites()) {
                if (composite2.isPinned()) {
                    hasPinned = true;
                    continue;
                }
                hasUnpinned = true;
            }
            if (!hasPinned && event.isFromContextMenu() || !hasUnpinned) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "window";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "fileEditorManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/CloseAllUnpinnedEditorsAction";
        objectArray[2] = "isFileToClose";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

