/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.ActionUrl;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/ui/customization/ActionUrlComparator;", "Ljava/util/Comparator;", "Lcom/intellij/ide/ui/customization/ActionUrl;", "<init>", "()V", "DELETED", "", "getEquivalenceClass", "url", "compare", "u1", "u2", "intellij.platform.ide.impl"})
final class ActionUrlComparator
implements Comparator<ActionUrl> {
    @NotNull
    public static final ActionUrlComparator INSTANCE = new ActionUrlComparator();
    public static final int DELETED = 1;

    private ActionUrlComparator() {
    }

    private final int getEquivalenceClass(ActionUrl url) {
        return switch (url.getActionType()) {
            case -1 -> 1;
            case 1 -> 2;
            default -> 3;
        };
    }

    @Override
    public int compare(@NotNull ActionUrl u1, @NotNull ActionUrl u2) {
        Intrinsics.checkNotNullParameter((Object)u1, (String)"u1");
        Intrinsics.checkNotNullParameter((Object)u2, (String)"u2");
        int w1 = this.getEquivalenceClass(u1);
        int w2 = this.getEquivalenceClass(u2);
        if (w1 != w2) {
            return w1 - w2;
        }
        if (w1 == 1) {
            return u2.getAbsolutePosition() - u1.getAbsolutePosition();
        }
        return u1.getAbsolutePosition() - u2.getAbsolutePosition();
    }
}

