/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text;

import com.intellij.ide.ui.text.ShortcutsRenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u0005*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/ui/text/StyledTextPaneUtils;", "", "<init>", "()V", "drawRectangleAroundText", "", "Ljavax/swing/text/JTextComponent;", "startOffset", "", "endOffset", "g", "Ljava/awt/Graphics;", "needColor", "Ljava/awt/Color;", "textFont", "Ljava/awt/Font;", "delimiterFont", "fill", "", "verticalIndent", "", "insertIconWithFixedHeight", "Ljavax/swing/JTextPane;", "icon", "Ljavax/swing/Icon;", "fixedHeight", "intellij.platform.ide.impl"})
public final class StyledTextPaneUtils {
    @NotNull
    public static final StyledTextPaneUtils INSTANCE = new StyledTextPaneUtils();

    private StyledTextPaneUtils() {
    }

    public final void drawRectangleAroundText(@NotNull JTextComponent $this$drawRectangleAroundText, int startOffset, int endOffset, @NotNull Graphics g, @NotNull Color needColor, @NotNull Font textFont, @NotNull Font delimiterFont, boolean fill, float verticalIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRectangleAroundText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)needColor, (String)"needColor");
        Intrinsics.checkNotNullParameter((Object)textFont, (String)"textFont");
        Intrinsics.checkNotNullParameter((Object)delimiterFont, (String)"delimiterFont");
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D startRect = $this$drawRectangleAroundText.modelToView2D(startOffset);
        Rectangle2D endRect = $this$drawRectangleAroundText.modelToView2D(endOffset);
        FontMetrics textFontMetrics = g2d.getFontMetrics(textFont);
        FontMetrics delimiterFontMetrics = g2d.getFontMetrics(delimiterFont);
        Color color = g2d.getColor();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double scaledVerticalIndent = JBUIScale.scale((float)verticalIndent);
        double horizontalIndent = (double)(delimiterFontMetrics.stringWidth(ShortcutsRenderingUtil.INSTANCE.getSHORTCUT_PART_SEPARATOR()) * 4) / 11.0;
        double arc = JBUIScale.scale((float)8.0f);
        RoundRectangle2D.Double r2d = new RoundRectangle2D.Double(startRect.getX() - horizontalIndent, startRect.getY() - scaledVerticalIndent, endRect.getX() - startRect.getX() + (double)2 * horizontalIndent, (double)textFontMetrics.getHeight() + (double)2 * scaledVerticalIndent, arc, arc);
        if (fill) {
            g2d.fill(r2d);
        } else {
            g2d.draw(r2d);
        }
        g2d.setColor(color);
    }

    public final void insertIconWithFixedHeight(@NotNull JTextPane $this$insertIconWithFixedHeight, @NotNull Icon icon2, int fixedHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$insertIconWithFixedHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        $this$insertIconWithFixedHeight.insertIcon(new Icon(icon2, fixedHeight){
            final /* synthetic */ Icon $icon;
            final /* synthetic */ int $fixedHeight;
            {
                this.$icon = $icon;
                this.$fixedHeight = $fixedHeight;
            }

            public int getIconWidth() {
                return this.$icon.getIconWidth();
            }

            public int getIconHeight() {
                return this.$fixedHeight;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                this.$icon.paintIcon(c, g, x, y);
            }
        });
    }
}

