/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";
    private static final String MESSAGE_KEY = "NotificationTestAction_Message";

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            NotificationTestAction.$$$reportNull$$$0(0);
        }
        new NotificationDialog(event.getProject()).show();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            NotificationTestAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/actions/NotificationTestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class NotificationDialog
    extends DialogWrapper {
        private final JTextArea myMessage = new JTextArea(10, 50);
        private final MessageBus myMessageBus;

        private NotificationDialog(@Nullable Project project2) {
            super(project2, true, DialogWrapper.IdeModalityType.MODELESS);
            this.myMessageBus = project2 != null ? project2.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
            this.init();
            this.setOKButtonText("Notify");
            this.setTitle(NotificationTestAction.TEST_GROUP_ID);
            this.myMessage.setText(PropertiesComponent.getInstance().getValue(NotificationTestAction.MESSAGE_KEY));
        }

        protected String getDimensionServiceKey() {
            return "NotificationTestAction";
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout(10, 10));
            panel2.add("Center", new JScrollPane(this.myMessage));
            return panel2;
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                NotificationDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        protected Action @NotNull [] createLeftSideActions() {
            AbstractAction balloon = new AbstractAction("Balloon Examples"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setExamples("// Example 1\nIcon:/toolwindows/toolWindowChanges.png\nTitle:Deleted Branch\nContent:Unmerged commits discarded\nActions:Restore,View Commits,Delete Tracked Branch\n\n// Example 2\nType:warn\nTitle:Title\nSubtitle:Subtitle\nContent:Foo<br>Bar\nSticky\n--\n// Description\nType:info/error/warn\nIcon:\nTitle:\nSubtitle:\nContent:\nContent:\nActions:\nSticky\n--\n");
                }
            };
            AbstractAction toolwindow = new AbstractAction("Toolwindow Examples"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setExamples("// Example\nToolwindow\nContent:Build completed successfully in 7 s 851 ms\n--\n// Description: Notifications shows for toolwindow TODO\nToolwindow\nType:info/error/warn\nIcon:\nTitle:\nContent:\nContent:\n--\n");
                }
            };
            Action[] actionArray = new Action[]{balloon, toolwindow};
            if (actionArray == null) {
                NotificationDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        public void doCancelAction() {
            PropertiesComponent.getInstance().setValue(NotificationTestAction.MESSAGE_KEY, StringUtil.nullize((String)this.myMessage.getText(), (boolean)true));
            super.doCancelAction();
        }

        protected void doOKAction() {
            this.newNotification(this.myMessage.getText());
        }

        private void setExamples(@NotNull String text2) {
            if (text2 == null) {
                NotificationDialog.$$$reportNull$$$0(2);
            }
            try {
                this.myMessage.getDocument().insertString(0, text2, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void newNotification(@NotNull String text2) {
            if (text2 == null) {
                NotificationDialog.$$$reportNull$$$0(3);
            }
            ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
            NotificationInfo notification2 = null;
            for (String line : StringUtil.splitByLines((String)text2, (boolean)false)) {
                String value;
                if (line.isEmpty() && notification2 != null) {
                    notification2 = null;
                    continue;
                }
                if (line.startsWith("//")) continue;
                if (line.startsWith("--")) break;
                if (notification2 == null) {
                    notification2 = new NotificationInfo();
                    notifications.add(notification2);
                }
                if (line.startsWith("Icon:")) {
                    notification2.setIcon(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Title:")) {
                    notification2.setTitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Content:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification2.addContent(value);
                    continue;
                }
                if (line.startsWith("Subtitle:")) {
                    notification2.setSubtitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Help:")) {
                    notification2.setHelp(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Actions:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification2.setActions(StringUtil.split((String)value, (String)","));
                    continue;
                }
                if (line.startsWith("Type:")) {
                    notification2.setType(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("LaterId:")) {
                    notification2.setRemindLaterHandlerId(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.equals("Suggestion")) {
                    notification2.setSuggestionType(true);
                    continue;
                }
                if (line.equals("ImportantSuggestion")) {
                    notification2.setImportantSuggestion(true);
                    continue;
                }
                if (line.equals("AddExtraAction")) {
                    notification2.setAddExtraAction(true);
                    continue;
                }
                if (line.equals("Sticky")) {
                    notification2.setSticky(true);
                    continue;
                }
                if (line.equals("Listener")) {
                    notification2.setAddListener(true);
                    continue;
                }
                if (line.equals("Toolwindow")) {
                    notification2.setToolwindow(true);
                    continue;
                }
                if (!line.equals("RightCollapseActions")) continue;
                notification2.myLeftActionsDirection = false;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (NotificationInfo info : notifications) {
                    ((Notifications)this.myMessageBus.syncPublisher(Notifications.TOPIC)).notify(info.getNotification());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLeftSideActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setExamples";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "newNotification";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class NotificationInfo
    implements NotificationListener {
        private String myIcon;
        private String myTitle;
        private String mySubtitle;
        private String myHelp;
        private List<String> myContent;
        private List<String> myActions;
        private NotificationType myType = NotificationType.INFORMATION;
        private boolean mySticky;
        private boolean myAddListener;
        private boolean myToolwindow;
        private boolean myLeftActionsDirection = true;
        private boolean mySuggestionType;
        private boolean myAddExtraAction;
        private boolean myImportantSuggestion;
        private Notification myNotification;
        private String myRemindLaterHandlerId;

        private NotificationInfo() {
        }

        public Notification getNotification() {
            if (this.myNotification == null) {
                String displayId;
                Icon icon2 = StringUtil.isEmpty((String)this.myIcon) ? null : IconLoader.findIcon((String)this.myIcon, (ClassLoader)NotificationInfo.class.getClassLoader());
                String string = displayId = this.mySticky ? Holder.TEST_STICKY_GROUP.getDisplayId() : NotificationTestAction.TEST_GROUP_ID;
                if (this.myToolwindow) {
                    displayId = Holder.TEST_TOOLWINDOW_GROUP.getDisplayId();
                }
                String content2 = this.myContent == null ? "" : String.join((CharSequence)"\n", this.myContent);
                this.myNotification = new Notification(displayId, content2, this.myType).setIcon(icon2).setTitle(this.myTitle, this.mySubtitle);
                NotificationListener listener2 = this.getListener();
                if (listener2 != null) {
                    this.myNotification.setListener(listener2);
                }
                if (this.myRemindLaterHandlerId != null) {
                    this.myNotification.setRemindLaterHandlerId(this.myRemindLaterHandlerId);
                }
                this.myNotification.setSuggestionType(this.mySuggestionType);
                this.myNotification.setAddExtraAction(this.myAddExtraAction);
                this.myNotification.setImportantSuggestion(this.myImportantSuggestion);
                if (this.myActions != null && !this.myToolwindow) {
                    for (String action2 : this.myActions) {
                        this.myNotification.addAction((AnAction)new MyAnAction(action2));
                    }
                }
                if (this.myHelp != null) {
                    this.myNotification.setContextHelpAction(new AnAction(this, "", this.myHelp, null){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo$1", "actionPerformed"));
                        }
                    });
                }
            }
            this.myNotification.setCollapseDirection(this.myLeftActionsDirection ? Notification.CollapseActionsDirection.KEEP_LEFTMOST : Notification.CollapseActionsDirection.KEEP_RIGHTMOST);
            return this.myNotification;
        }

        @Nullable
        private NotificationListener getListener() {
            return this.myAddListener ? this : null;
        }

        public void setIcon(@Nullable String icon2) {
            this.myIcon = icon2;
        }

        public void setTitle(@Nullable String title2) {
            this.myTitle = title2;
        }

        public void setSubtitle(@Nullable String subtitle) {
            this.mySubtitle = subtitle;
        }

        private void setHelp(String help) {
            this.myHelp = help;
        }

        public void setAddListener(boolean addListener) {
            this.myAddListener = addListener;
        }

        public void addContent(@NotNull String content2) {
            if (content2 == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            if (this.myContent == null) {
                this.myContent = new ArrayList<String>();
            }
            this.myContent.add(content2);
        }

        public void setActions(@NotNull List<String> actions) {
            if (actions == null) {
                NotificationInfo.$$$reportNull$$$0(1);
            }
            this.myActions = actions;
        }

        public void setSticky(boolean sticky) {
            this.mySticky = sticky;
        }

        public void setRemindLaterHandlerId(String remindLaterHandlerId) {
            this.myRemindLaterHandlerId = remindLaterHandlerId;
        }

        private void setSuggestionType(boolean suggestionType) {
            this.mySuggestionType = suggestionType;
        }

        private void setImportantSuggestion(boolean importantSuggestion) {
            this.myImportantSuggestion = importantSuggestion;
        }

        private void setAddExtraAction(boolean addExtraAction) {
            this.myAddExtraAction = addExtraAction;
        }

        public void setToolwindow(boolean toolwindow) {
            this.myToolwindow = toolwindow;
        }

        public void setType(@Nullable String type) {
            if ("info".equals(type)) {
                this.myType = NotificationType.INFORMATION;
            } else if ("error".equals(type)) {
                this.myType = NotificationType.ERROR;
            } else if ("warn".equals(type)) {
                this.myType = NotificationType.WARNING;
            }
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            if (notification2 == null) {
                NotificationInfo.$$$reportNull$$$0(2);
            }
            if (event == null) {
                NotificationInfo.$$$reportNull$$$0(3);
            }
            if (this.myNotification != null && MessageDialogBuilder.yesNo((String)"Notification Listener", (String)(event.getDescription() + "      Expire?")).guessWindowAndAsk()) {
                this.myNotification.expire();
                this.myNotification = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MyAnAction
        extends AnAction {
            private MyAnAction(String text2) {
                if (text2 != null) {
                    Icon icon2;
                    if (text2.endsWith(".png") && (icon2 = IconLoader.findIcon((String)text2, (ClassLoader)MyAnAction.class.getClassLoader())) != null) {
                        this.getTemplatePresentation().setIcon(icon2);
                        return;
                    }
                    this.getTemplatePresentation().setText(text2);
                }
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAnAction.$$$reportNull$$$0(0);
                }
                if (NotificationInfo.this.myNotification == null) {
                    return;
                }
                Notification.get((AnActionEvent)e);
                if (MessageDialogBuilder.yesNo((String)"AnAction", (String)(this.getTemplatePresentation().getText() + "      Expire?")).guessWindowAndAsk()) {
                    NotificationInfo.this.myNotification.expire();
                    NotificationInfo.this.myNotification = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo$MyAnAction", "actionPerformed"));
            }
        }
    }

    private static final class Holder {
        private static final NotificationGroup TEST_STICKY_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Test Sticky Notification");
        private static final NotificationGroup TEST_TOOLWINDOW_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Test ToolWindow Notification");

        private Holder() {
        }
    }
}

