/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.zoomIndicator;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorView;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.AnActionLink;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0002\u0013\u0016\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "value", "", "isHovered", "()Z", "", "lastHoverMs", "getLastHoverMs", "()J", "fontSizeLabel", "Ljavax/swing/JLabel;", "settingsAction", "com/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$settingsAction$1", "Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$settingsAction$1;", "settingsBtn", "com/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$settingsBtn$1", "Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$settingsBtn$1;", "resetLink", "Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$PatchedActionLink;", "updateFontSize", "", "PatchedActionLink", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ZoomIndicatorView
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    private boolean isHovered;
    private long lastHoverMs;
    @NotNull
    private final JLabel fontSizeLabel;
    @NotNull
    private final settingsAction.1 settingsAction;
    @NotNull
    private final settingsBtn.1 settingsBtn;
    @NotNull
    private final PatchedActionLink resetLink;

    /*
     * WARNING - void declaration
     */
    public ZoomIndicatorView(@NotNull EditorImpl editor2) {
        void $this$resetLink_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super((LayoutManager)new MigLayout("novisualpadding, ins 0"));
        this.editor = editor2;
        Object object = new Object[]{"000"};
        this.fontSizeLabel = new JLabel(IdeBundle.message((String)"action.reset.font.size.info", (Object[])object));
        object = IdeBundle.message((String)"action.open.editor.settings.text", (Object[])new Object[0]);
        Icon icon2 = AllIcons.General.Settings;
        this.settingsAction = new DumbAwareAction((String)object, icon2){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project2 = e.getProject();
                if (project2 == null) {
                    return;
                }
                Project prj = project2;
                String string = ApplicationBundle.message((String)"checkbox.enable.ctrl.mousewheel.changes.font.size.hint", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String searchName = string;
                ShowSettingsUtilImpl.Companion.showSettingsDialog(prj, "preferences.editor", searchName);
            }
        };
        object = this.settingsAction;
        icon2 = this.settingsAction.getTemplatePresentation().clone();
        JBDimension jBDimension = JBUI.size((int)22, (int)22);
        this.settingsBtn = new ActionButton((Object)object, (Presentation)icon2, jBDimension){

            protected void performAction(MouseEvent e) {
                AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)this.getDataContext(), (Presentation)this.myPresentation, (String)this.myPlace, (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), (InputEvent)e);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                AnActionEvent event = anActionEvent;
                ActionManager actionManager = event.getActionManager();
                Intrinsics.checkNotNull((Object)actionManager, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ex.ActionManagerEx");
                ActionManagerEx actionManager2 = (ActionManagerEx)actionManager;
                AnAction anAction = this.myAction;
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"myAction");
                actionManager2.performWithActionCallbacks(anAction, event, () -> settingsBtn.1.performAction$lambda$0(this, event));
            }

            public boolean isShowing() {
                return true;
            }

            private static final void performAction$lambda$0(settingsBtn.1 this$0, AnActionEvent $event) {
                this$0.actionPerformed($event);
            }
        };
        icon2 = ActionManager.getInstance().getAction("EditorResetFontSize");
        ZoomIndicatorView zoomIndicatorView = this;
        boolean bl = false;
        DataContext dataContext2 = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.EDITOR, (Object)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getSimpleContext(...)");
        DataContext dataContext3 = dataContext2;
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext3, null, (String)"popup", (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        $this$resetLink_u24lambda_u240.update(event);
        this.fontSizeLabel.addPropertyChangeListener(arg_0 -> ZoomIndicatorView.resetLink$lambda$0$0((AnAction)$this$resetLink_u24lambda_u240, event, arg_0));
        Intrinsics.checkNotNull((Object)$this$resetLink_u24lambda_u240);
        zoomIndicatorView.resetLink = new PatchedActionLink((AnAction)$this$resetLink_u24lambda_u240, event);
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ ZoomIndicatorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                ZoomIndicatorView.access$setHovered$p(this.this$0, true);
                ZoomIndicatorView.access$setLastHoverMs$p(this.this$0, System.currentTimeMillis());
            }

            public void mouseExited(MouseEvent e) {
                ZoomIndicatorView.access$setHovered$p(this.this$0, false);
            }
        };
        this.addMouseListener(mouseListener2);
        this.resetLink.addMouseListener(mouseListener2);
        this.settingsBtn.addMouseListener(mouseListener2);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        EditorUtil.disposeWithEditor(this.editor, disposable2);
        this.updateFontSize();
        this.add((Component)this.fontSizeLabel, "wmin 100, gapbottom 1, gapleft 3");
        this.add((Component)((Object)this.resetLink), "gapbottom 1");
        this.add(this.settingsBtn);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final boolean isHovered() {
        return this.isHovered;
    }

    public final long getLastHoverMs() {
        return this.lastHoverMs;
    }

    public final void updateFontSize() {
        Object[] objectArray = new Object[]{this.editor.getFontSize()};
        this.fontSizeLabel.setText(IdeBundle.message((String)"action.reset.font.size.info", (Object[])objectArray));
    }

    private static final void resetLink$lambda$0$0(AnAction $this_run, AnActionEvent $event, PropertyChangeEvent it) {
        if (Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"text")) {
            $this_run.update($event);
        }
    }

    public static final /* synthetic */ void access$setHovered$p(ZoomIndicatorView $this, boolean bl) {
        $this.isHovered = bl;
    }

    public static final /* synthetic */ void access$setLastHoverMs$p(ZoomIndicatorView $this, long l) {
        $this.lastHoverMs = l;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView$PatchedActionLink;", "Lcom/intellij/ui/components/AnActionLink;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/AnActionEvent;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "isShowing", "", "intellij.platform.ide.impl"})
    private final class PatchedActionLink
    extends AnActionLink {
        public PatchedActionLink(@NotNull AnAction action2, AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super(action2, "popup");
            this.setText(event.getPresentation().getText());
            this.setAutoHideOnDisable(false);
            this.setEnabled(event.getPresentation().isEnabled());
            event.getPresentation().addPropertyChangeListener(arg_0 -> PatchedActionLink._init_$lambda$0(this, arg_0));
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            super.uiDataSnapshot(sink);
            DataKey dataKey = CommonDataKeys.EDITOR;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
            sink.set(dataKey, (Object)ZoomIndicatorView.this.getEditor());
        }

        public boolean isShowing() {
            return true;
        }

        private static final void _init_$lambda$0(PatchedActionLink this$0, PropertyChangeEvent it) {
            if (Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"enabled")) {
                Object object = it.getNewValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                this$0.setEnabled((Boolean)object);
            }
        }
    }
}

