/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.DetectedByContentFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.ReparseUtilKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.CoroutineDispatcherBackedExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FileTypeDetectionService {
    private static final Logger LOG = Logger.getInstance(FileTypeDetectionService.class);
    private static final boolean LOG_ACCESSED_FILES = SystemProperties.getBooleanProperty((String)"com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl.LOG_ACCESSED_FILES", (boolean)false);
    private static final Key<String> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private static final String FILE_TYPE_DETECTORS_PROPERTY = "fileTypeDetectors";
    private static final String FILE_TYPE_CHANGED_COUNTER_PROPERTY = "fileTypeChangedCounter";
    private static final FileAttribute AUTO_DETECTED_CACHE_INITIAL_ATTRIBUTE = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", PropertiesComponent.getInstance().getInt("fileTypeChangedCounter", 0), true);
    private static final int CHUNK_SIZE = 10;
    private static final int OUR_MAX_FILE_SIZE_TO_LOG = 512;
    private final AtomicInteger counterAutoDetect;
    private final AtomicLong elapsedAutoDetect;
    private boolean RE_DETECT_ASYNC;
    private final CoroutineDispatcherBackedExecutor reDetectExecutor;
    private final HashSetQueue<VirtualFile> filesToRedetect;
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final ConcurrentPackedBitsArray packedFlags;
    private int cachedDetectFileBufferSize;
    private volatile boolean myCanUseCachedDetectedFileType;
    private final FileTypeManagerImpl myFileTypeManager;
    private final CoroutineScope scope;
    private final DiskQueryRelay<VirtualFileWithLength, ByteArraySequence> myReadFirstBytesFromFileRelay;

    FileTypeDetectionService(@NotNull FileTypeManagerImpl fileTypeManager, @NotNull CoroutineScope coroutineScope) {
        if (fileTypeManager == null) {
            FileTypeDetectionService.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            FileTypeDetectionService.$$$reportNull$$$0(1);
        }
        this.counterAutoDetect = new AtomicInteger();
        this.elapsedAutoDetect = new AtomicLong();
        this.RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
        this.filesToRedetect = new HashSetQueue();
        this.packedFlags = ConcurrentPackedBitsArray.create((int)4);
        this.cachedDetectFileBufferSize = -1;
        this.myCanUseCachedDetectedFileType = true;
        this.myReadFirstBytesFromFileRelay = new DiskQueryRelay<VirtualFileWithLength, ByteArraySequence>(pair -> {
            try {
                return this.readFirstBytesFromFile(pair.virtualFile(), pair.length());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.myFileTypeManager = fileTypeManager;
        this.scope = coroutineScope;
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(throwable -> {
            LOG.info(String.format("%s auto-detected files. Detection took %s ms", this.counterAutoDetect, this.elapsedAutoDetect));
            return null;
        });
        this.fileTypeChangedCount = new AtomicInteger(AUTO_DETECTED_CACHE_INITIAL_ATTRIBUTE.getVersion());
        this.autoDetectedAttribute = AUTO_DETECTED_CACHE_INITIAL_ATTRIBUTE;
        FileTypeRegistry.FileTypeDetector.EP_NAME.addChangeListener(coroutineScope, () -> {
            this.cachedDetectFileBufferSize = -1;
            this.onDetectorListChange();
        });
        List prevDetectors = PropertiesComponent.getInstance().getList(FILE_TYPE_DETECTORS_PROPERTY);
        if (!Objects.equals(prevDetectors, FileTypeDetectionService.getDetectorListString())) {
            this.onDetectorListChange();
        }
        this.reDetectExecutor = AppJavaExecutorUtil.createBoundedTaskExecutor((String)"FileTypeManager Redetect", (CoroutineScope)coroutineScope);
    }

    @Nullable
    AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            FileTypeDetectionService.$$$reportNull$$$0(2);
        }
        final Set files2 = ContainerUtil.map2SetNotNull(events, event -> {
            VirtualFile filtered;
            if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent changeEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = changeEvent.getFile();
                if (changeEvent.getOldLength() == 0L) {
                    file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                }
            }
            ProgressManager.checkCanceled();
            VirtualFile file3 = event instanceof VFileCreateEvent || FileTypeDetectionService.isReparseEvent(event) || event instanceof VFileDeleteEvent ? null : event.getFile();
            VirtualFile virtualFile2 = filtered = file3 != null && this.wasAutoDetectedBefore(file3) && FileTypeDetectionService.isDetectable(file3) ? file3 : null;
            if (this.toLog()) {
                this.log("F: after() VFS event " + String.valueOf(event) + "; filtered file: " + String.valueOf(filtered) + " (file: " + String.valueOf(file3) + ") ; wasAutoDetectedBefore(file): " + (file3 == null ? null : Boolean.valueOf(this.wasAutoDetectedBefore(file3))) + "; isDetectable(file): " + (file3 == null ? null : Boolean.valueOf(FileTypeDetectionService.isDetectable(file3))) + "; file.getLength(): " + String.valueOf(file3 == null ? null : (file3.isDirectory() ? "-" : Long.valueOf(file3.getLength()))) + "; file.isValid(): " + (file3 == null ? null : Boolean.valueOf(file3.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file3 == null ? null : Boolean.valueOf(file3.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file3 instanceof VirtualFileWithId ? FileTypeDetectionService.readableFlags(this.packedFlags.get(((VirtualFileWithId)file3).getId())) : null) + "; file.getFileSystem():" + String.valueOf(file3 == null ? null : file3.getFileSystem()) + ")");
            }
            return filtered;
        });
        if (this.toLog()) {
            this.log("F: after() VFS events: " + String.valueOf(events) + "; files: " + String.valueOf(files2));
        }
        ProgressManager.checkCanceled();
        if (!files2.isEmpty() && this.RE_DETECT_ASYNC) {
            if (this.toLog()) {
                this.log("F: after() queued to redetect: " + String.valueOf(files2));
            }
            for (VirtualFile file2 : files2) {
                this.finishRedetectionIfEnqueued(file2);
            }
            return new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    FileTypeDetectionService.this.myCanUseCachedDetectedFileType = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterVfsChange() {
                    try {
                        HashSetQueue<VirtualFile> hashSetQueue = FileTypeDetectionService.this.filesToRedetect;
                        synchronized (hashSetQueue) {
                            if (FileTypeDetectionService.this.filesToRedetect.addAll(files2)) {
                                FileTypeDetectionService.this.awakeReDetectExecutor();
                            }
                        }
                    }
                    finally {
                        FileTypeDetectionService.this.myCanUseCachedDetectedFileType = true;
                    }
                }
            };
        }
        return null;
    }

    private static boolean isReparseEvent(@NotNull VFileEvent event) {
        if (event == null) {
            FileTypeDetectionService.$$$reportNull$$$0(3);
        }
        return event instanceof VFilePropertyChangeEvent && "FileContentUtilCore.saveOrReload".equals(event.getRequestor());
    }

    private boolean toLog() {
        return this.myFileTypeManager.toLog();
    }

    private void log(String s) {
        this.myFileTypeManager.log(s);
    }

    @NotNull
    FileType getOrDetectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2, @Nullable FileType fileTypeByName) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(4);
        }
        if (!FileTypeDetectionService.isDetectable(file2)) {
            if (fileTypeByName == DetectedByContentFileType.INSTANCE) {
                DetectedByContentFileType detectedByContentFileType = DetectedByContentFileType.INSTANCE;
                if (detectedByContentFileType == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(5);
                }
                return detectedByContentFileType;
            }
            if (ScratchUtil.isScratch((VirtualFile)file2)) {
                PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
                if (plainTextFileType == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(6);
                }
                return plainTextFileType;
            }
            FileType fileType2 = UnknownFileType.INSTANCE;
            if (fileType2 == null) {
                FileTypeDetectionService.$$$reportNull$$$0(7);
            }
            return fileType2;
        }
        if (!this.myCanUseCachedDetectedFileType) {
            try {
                return this.detectFromContent(file2, this.getFirstBytes(file2, content2), fileTypeByName);
            }
            catch (IOException e) {
                FileType fileType3 = UnknownFileType.INSTANCE;
                if (fileType3 == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(8);
                }
                return fileType3;
            }
        }
        this.finishRedetectionIfEnqueued(file2);
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id2 = ((VirtualFileWithId)file2).getId();
            long flags = this.packedFlags.get(id2);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id2, flags);
                if (this.toLog()) {
                    this.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeDetectionService.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeDetectionService.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    this.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType4 = FileTypeDetectionService.preferDetectedByContent(type, fileTypeByName);
                    if (fileType4 == null) {
                        FileTypeDetectionService.$$$reportNull$$$0(9);
                    }
                    return fileType4;
                }
            }
        }
        FileType fileType5 = this.getFileTypeDetectedFromContent(file2);
        if (this.toLog()) {
            this.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType5 == null ? null : fileType5.getName()));
        }
        if (fileType5 == null || fileType5 == DetectedByContentFileType.INSTANCE) {
            try {
                fileType5 = this.detectFromContentAndCache(file2, content2, fileTypeByName);
            }
            catch (IOException e) {
                fileType5 = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            this.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType5.getName());
        }
        FileType fileType6 = fileType5;
        if (fileType6 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(10);
        }
        return fileType6;
    }

    private static FileType preferDetectedByContent(@NotNull FileType fromContent, @Nullable FileType fileTypeByName) {
        if (fromContent == null) {
            FileTypeDetectionService.$$$reportNull$$$0(11);
        }
        return fromContent == PlainTextFileType.INSTANCE && fileTypeByName == DetectedByContentFileType.INSTANCE ? DetectedByContentFileType.INSTANCE : fromContent;
    }

    void loadState(@NotNull Element state2) {
        if (state2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(12);
        }
        String fileTypeChangedCounterStr = null;
        for (Element element : state2.getChildren()) {
            if (!element.getName().equals("setting") || !FILE_TYPE_CHANGED_COUNTER_PROPERTY.equals(element.getAttributeValue("name"))) continue;
            fileTypeChangedCounterStr = element.getAttributeValue("value");
            break;
        }
        if (fileTypeChangedCounterStr != null) {
            int storedCounter = StringUtilRt.parseInt(fileTypeChangedCounterStr, (int)0);
            this.updateFileTypeChangedCount(storedCounter - this.fileTypeChangedCount.get());
        }
    }

    private void updateFileTypeChangedCount(int countDelta) {
        int newValue = this.fileTypeChangedCount.addAndGet(countDelta);
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(newValue);
        PropertiesComponent.getInstance().setValue(FILE_TYPE_CHANGED_COUNTER_PROPERTY, Integer.toString(newValue));
    }

    void clearCaches() {
        this.packedFlags.clear();
        this.clearPersistentAttributes();
        if (this.toLog()) {
            this.log("F: clearCaches()");
        }
    }

    private void onDetectorListChange() {
        this.clearCaches();
        PropertiesComponent.getInstance().setList(FILE_TYPE_DETECTORS_PROPERTY, FileTypeDetectionService.getDetectorListString());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static List<String> getDetectorListString() {
        @NotNull ExtensionPointImpl ep = (ExtensionPointImpl)FileTypeRegistry.FileTypeDetector.EP_NAME.getPoint();
        int size2 = ep.size();
        if (size2 == 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeDetectionService.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(size2);
        for (ExtensionComponentAdapter adapter : ep.getSortedAdapters()) {
            result2.add(adapter.getAssignableToClassName());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            FileTypeDetectionService.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(15);
        }
        return !file2.isDirectory() && file2.isValid() && !file2.is(VFileProperty.SPECIAL) && (file2.getFileSystem() instanceof FileSystemInterface || file2 instanceof LightVirtualFile);
    }

    private byte readFlagsFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(16);
        }
        boolean wasAutoDetectRun = false;
        byte status2 = 0;
        try (AttributeInputStream stream = this.autoDetectedAttribute.readFileAttribute(file2);){
            status2 = stream == null ? (byte)0 : stream.readByte();
            wasAutoDetectRun = stream != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status2 = BitUtil.set((byte)status2, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status2 & 7);
    }

    private void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(17);
        }
        try (AttributeOutputStream stream = this.autoDetectedAttribute.writeFileAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void clearPersistentAttributes() {
        this.updateFileTypeChangedCount(1);
        if (this.toLog()) {
            this.log("F: clearPersistentAttributes()");
        }
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @Nullable(value="null means clear the cache") @Nullable(value="null means clear the cache") FileType fileType2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(18);
        }
        boolean wasAutodetectedAsText = fileType2 == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType2 == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            long oldFlags = this.packedFlags.get(id2);
            if (oldFlags != (long)flags) {
                this.packedFlags.set(id2, (long)flags);
                this.writeFlagsToCache(file2, flags);
            }
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    this.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + String.valueOf(fileType2) + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)(fileType2 == null ? null : fileType2.getName()));
        if (this.toLog()) {
            this.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + String.valueOf(fileType2) + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    @ApiStatus.Internal
    public void clearDetectedFromContentData(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(19);
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.execute(() -> {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i2 = 0; i2 < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i2) {
                    files2.add(file2);
                }
            }
            if (files2.size() == 10) {
                this.awakeReDetectExecutor();
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.reDetect(files2));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRedetectionIfEnqueued(@NotNull VirtualFile file2) {
        boolean submitted;
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(20);
        }
        ProgressManager.checkCanceled();
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        synchronized (hashSetQueue) {
            submitted = this.filesToRedetect.remove((Object)file2);
        }
        if (submitted) {
            try {
                this.reDetect(Collections.singleton(file2));
            }
            catch (ProcessCanceledException e) {
                HashSetQueue<VirtualFile> hashSetQueue2 = this.filesToRedetect;
                synchronized (hashSetQueue2) {
                    this.filesToRedetect.offer((Object)file2);
                }
                throw e;
            }
        }
    }

    @Nullable
    private FileType getFileTypeDetectedFromContent(@NotNull VirtualFile file2) {
        String fileTypeName;
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(21);
        }
        return (fileTypeName = (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY)) == null ? null : this.myFileTypeManager.findFileTypeByName(fileTypeName);
    }

    private void reDetect(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(22);
        }
        if (files2.isEmpty()) {
            return;
        }
        ArrayList<VirtualFile> changed = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile2 : files2) {
            FileType after;
            FileType before;
            block11: {
                if (this.toLog()) {
                    this.log("F: reDetect(" + virtualFile2.getName() + ") " + virtualFile2.getName());
                }
                int id2 = ((VirtualFileWithId)virtualFile2).getId();
                long flags = this.packedFlags.get(id2);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeDetectionService.textOrBinaryFromCachedFlags(flags), (Object)((FileType)ObjectUtils.notNull((Object)this.getFileTypeDetectedFromContent(virtualFile2), (Object)PlainTextFileType.INSTANCE)));
                after = this.myFileTypeManager.getByFile(virtualFile2);
                if (this.toLog()) {
                    this.log("F: reDetect(" + virtualFile2.getName() + ") prepare to redetect. flags: " + FileTypeDetectionService.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after == null ? null : after.getName()));
                }
                if (after == null || after == DetectedByContentFileType.INSTANCE) {
                    try {
                        after = this.detectFromContentAndCache(virtualFile2, null, after);
                        break block11;
                    }
                    catch (IOException e) {
                        crashed.add(virtualFile2);
                        if (!this.toLog()) continue;
                        this.log("F: reDetect(" + virtualFile2.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + virtualFile2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                virtualFile2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id2, flags);
            }
            if (this.toLog()) {
                this.log("F: reDetect(" + virtualFile2.getName() + ") before: " + before.getName() + "; after: " + after.getName() + "; now getFileType()=" + virtualFile2.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after) continue;
            changed.add(virtualFile2);
        }
        if (!changed.isEmpty()) {
            this.reparseLater(changed);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    public boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(23);
        }
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            return (this.packedFlags.get(id2) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2, byte @Nullable [] content2, @Nullable FileType fileTypeByName) throws IOException {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(24);
        }
        long start2 = System.currentTimeMillis();
        ByteArraySequence bytes = this.getFirstBytes(file2, content2);
        FileType fileType2 = this.detectFromContent(file2, bytes, fileTypeByName);
        this.cacheAutoDetectedFileType(file2, fileType2);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        FileType fileType3 = fileType2;
        if (fileType3 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(25);
        }
        return fileType3;
    }

    private int readSafely(@NotNull InputStream stream, byte @NotNull [] buffer2, int length) throws IOException {
        int n;
        if (stream == null) {
            FileTypeDetectionService.$$$reportNull$$$0(26);
        }
        if (buffer2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(27);
        }
        if ((n = stream.read(buffer2, 0, length)) <= 0) {
            if (this.toLog()) {
                this.log("F: readSafely(): inputStream.read(" + length + ") returned " + n + "; retrying with read action. stream=" + String.valueOf(FileTypeDetectionService.streamInfo(stream)));
            }
            n = stream.read(buffer2, 0, length);
            if (this.toLog()) {
                this.log("F: readSafely(): under read action inputStream.read(" + length + ") returned " + n + "; stream=" + String.valueOf(FileTypeDetectionService.streamInfo(stream)));
            }
        }
        return n;
    }

    @NotNull
    private FileType detectFromContent(@NotNull VirtualFile file2, @NotNull ByteArraySequence bytes, @Nullable FileType fileTypeByName) throws IOException {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(28);
        }
        if (bytes == null) {
            FileTypeDetectionService.$$$reportNull$$$0(29);
        }
        List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
        FileType fileType2 = LoadTextUtil.processTextFromBinaryPresentationOrNull((ByteSequence)bytes, (VirtualFile)file2, (boolean)true, (boolean)true, (FileType)PlainTextFileType.INSTANCE, text2 -> {
            if (this.toLog()) {
                this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): bytes length=" + bytes.length() + "; isText=" + (text2 != null) + "; text='" + String.valueOf(text2 == null ? null : StringUtil.first((CharSequence)text2, (int)100, (boolean)true)) + "', detectors=" + String.valueOf(detectors));
            }
            PlainTextFileType detected = null;
            for (FileTypeRegistry.FileTypeDetector detector : detectors) {
                try {
                    detected = detector.detect(file2, (ByteSequence)bytes, text2);
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Detector " + String.valueOf(detector) + " (" + String.valueOf(detector.getClass()) + ") threw PCE. Bad detector, bad!", (Throwable)new RuntimeException(e));
                }
                catch (Exception e) {
                    LOG.error("Detector " + String.valueOf(detector) + " (" + String.valueOf(detector.getClass()) + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!this.toLog()) break;
                this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + String.valueOf(detector) + " type as " + detected.getName());
                break;
            }
            if (detected == null && !StringUtil.isEmpty((CharSequence)text2)) {
                FileTypeManagerImpl.FileTypeWithDescriptor ftd = (FileTypeManagerImpl.FileTypeWithDescriptor)this.myFileTypeManager.patternsTable.findAssociatedFileTypeByHashBang(text2);
                FileType fileType2 = detected = ftd == null ? null : ftd.fileType();
            }
            if (detected == null) {
                Object object = StringUtil.isEmpty((CharSequence)text2) ? (bytes.getLength() == 0 ? DetectedByContentFileType.INSTANCE : UnknownFileType.INSTANCE) : (detected = PlainTextFileType.INSTANCE);
                if (this.toLog()) {
                    this.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            return detected;
        });
        if (this.toLog()) {
            try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                byte[] buffer2 = new byte[50];
                int n2 = newStream.read(buffer2, 0, buffer2.length);
                this.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + fileType2.getName() + "; newStream: " + String.valueOf(FileTypeDetectionService.streamInfo(newStream)) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer2));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.valueOf(file2) + "; type=" + fileType2.getDescription() + "; " + String.valueOf(this.counterAutoDetect));
        }
        FileType fileType3 = FileTypeDetectionService.preferDetectedByContent(fileType2, fileTypeByName);
        if (fileType3 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(30);
        }
        return fileType3;
    }

    @NotNull
    private ByteArraySequence readFirstBytesFromFile(@NotNull VirtualFile file2, int bufferLength) throws IOException {
        int fileLength;
        byte[] content2;
        int n;
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(31);
        }
        InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);
        if (LOG_ACCESSED_FILES || this.toLog()) {
            this.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + String.valueOf(FileTypeDetectionService.streamInfo(inputStream)));
        }
        ByteArraySequence byteArraySequence = (n = this.readSafely(inputStream, content2 = ArrayUtil.newByteArray((int)(fileLength = (int)Math.min(file2.getLength(), (long)bufferLength))), content2.length)) > 0 ? new ByteArraySequence(content2, 0, n) : ByteArraySequence.EMPTY;
        ByteArraySequence byteArraySequence2 = byteArraySequence;
        if (byteArraySequence2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(32);
        }
        return byteArraySequence2;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @NotNull
    private ByteArraySequence getFirstBytes(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(33);
        }
        int bufferLength = this.getDetectFileBufferSize(file2);
        if (content2 == null) {
            ByteArraySequence byteArraySequence;
            if (bufferLength == 0) {
                ByteArraySequence byteArraySequence2 = ByteArraySequence.EMPTY;
                if (byteArraySequence2 == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(34);
                }
                return byteArraySequence2;
            }
            try {
                byteArraySequence = ProgressManager.getInstance().isInNonCancelableSection() || ApplicationManager.getApplication().isWriteIntentLockAcquired() ? this.readFirstBytesFromFile(file2, bufferLength) : this.myReadFirstBytesFromFileRelay.accessDiskWithCheckCanceled(new VirtualFileWithLength(file2, bufferLength));
            }
            catch (Exception e) {
                ByteArraySequence byteArraySequence3 = ByteArraySequence.EMPTY;
                if (byteArraySequence3 == null) {
                    FileTypeDetectionService.$$$reportNull$$$0(36);
                }
                return byteArraySequence3;
            }
            if (byteArraySequence == null) {
                FileTypeDetectionService.$$$reportNull$$$0(35);
            }
            return byteArraySequence;
        }
        ByteArraySequence byteArraySequence = content2.length != 0 ? new ByteArraySequence(content2, 0, Math.min(content2.length, bufferLength)) : ByteArraySequence.EMPTY;
        if (byteArraySequence == null) {
            FileTypeDetectionService.$$$reportNull$$$0(37);
        }
        return byteArraySequence;
    }

    private int getDetectFileBufferSize(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(38);
        }
        if (!file2.isCharsetSet()) {
            return FileUtilRt.getUserContentLoadLimit();
        }
        int bufferLength = this.cachedDetectFileBufferSize;
        if (bufferLength == -1) {
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            for (int i2 = 0; i2 < detectors.size(); ++i2) {
                FileTypeRegistry.FileTypeDetector detector = (FileTypeRegistry.FileTypeDetector)detectors.get(i2);
                bufferLength = Math.max(bufferLength, detector.getDesiredContentPrefixLength());
            }
            if (bufferLength < 0) {
                bufferLength = FileUtilRt.getUserContentLoadLimit();
            }
            this.cachedDetectFileBufferSize = bufferLength;
        }
        return bufferLength;
    }

    @NotNull
    private static String readableFlags(long flags) {
        Object result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = (String)result2 + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = (String)result2 + (((String)result2).isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        Object object = result2;
        if (object == null) {
            FileTypeDetectionService.$$$reportNull$$$0(39);
        }
        return object;
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    private void reparseLater(@NotNull List<? extends VirtualFile> changed) {
        if (changed == null) {
            FileTypeDetectionService.$$$reportNull$$$0(40);
        }
        if (Registry.is((String)"filetype.reparse.with.coroutines")) {
            ReparseUtilKt.reparseLaterWithCoroutines(this.scope, changed);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)changed), ApplicationManager.getApplication().getDisposed());
        }
    }

    private static Object streamInfo(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileTypeDetectionService.$$$reportNull$$$0(41);
        }
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            String buffer2 = buf == null ? null : Arrays.toString(Arrays.copyOf(buf, Math.min(count, 512)));
            return "BufferedInputStream(buf=" + buffer2 + ", count=" + count + ", pos=" + pos + ", in=" + String.valueOf(FileTypeDetectionService.streamInfo(in)) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            Long channelSize = channel == null ? null : Long.valueOf(channel.size());
            String fileContent = FileTypeDetectionService.loadFile(file2, 512);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + String.valueOf(channel) + ", channel.size=" + channelSize + ", file.exists=" + file2.exists() + ", file.content='" + fileContent + "')";
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String loadFile(@NotNull File file2, int maxLength) throws IOException {
        if (file2 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(42);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file2), Charset.defaultCharset());
        int length = (int)Math.min(file2.length(), (long)maxLength);
        char[] result2 = FileUtil.loadText((Reader)reader, (int)length);
        if (file2.length() > (long)maxLength) {
            String string = new String(result2) + "\n\n+" + (file2.length() - (long)maxLength) + " bytes more";
            String string2 = string;
            if (string2 == null) {
                FileTypeDetectionService.$$$reportNull$$$0(43);
            }
            return string2;
        }
        String string = new String(result2);
        String string3 = string;
        if (string3 == null) {
            FileTypeDetectionService.$$$reportNull$$$0(44);
        }
        return string3;
        finally {
            ((Reader)reader).close();
        }
    }

    @TestOnly
    public void drainReDetectQueue() {
        this.reDetectExecutor.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        // MONITORENTER : hashSetQueue
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        // MONITOREXIT : hashSetQueue
        if (arrayList != null) return arrayList;
        FileTypeDetectionService.$$$reportNull$$$0(45);
        return arrayList;
    }

    @TestOnly
    void reDetectAsync(boolean enable2) {
        this.RE_DETECT_ASYNC = enable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 13, 14, 25, 30, 32, 34, 35, 36, 37, 39, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromContent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetectFromContent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorListString";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContentAndCache";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBytesFromFile";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstBytes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "readableFlags";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReparseEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrDetectFromContent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preferDetectedByContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDetectable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readFlagsFromCache";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeFlagsToCache";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cacheAutoDetectedFileType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearDetectedFromContentData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "finishRedetectionIfEnqueued";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeDetectedFromContent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reDetect";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wasAutoDetectedBefore";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContentAndCache";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readSafely";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readFirstBytesFromFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBytes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDetectFileBufferSize";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reparseLater";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "streamInfo";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 13, 14, 25, 30, 32, 34, 35, 36, 37, 39, 43, 44, 45 -> new IllegalStateException(string);
        };
    }

    private record VirtualFileWithLength(@NotNull VirtualFile virtualFile, int length) {
        @NotNull
        private final VirtualFile virtualFile;

        private VirtualFileWithLength(@NotNull VirtualFile virtualFile2, int length) {
            if (virtualFile2 == null) {
                VirtualFileWithLength.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public VirtualFile virtualFile() {
            VirtualFile virtualFile2 = this.virtualFile;
            if (virtualFile2 == null) {
                VirtualFileWithLength.$$$reportNull$$$0(1);
            }
            return virtualFile2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService$VirtualFileWithLength";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeDetectionService$VirtualFileWithLength";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "virtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

