/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install;

import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.DownloadResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.InstallationResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationService;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationServiceKt;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstaller;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.io.HttpRequests;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010%J\u0012\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H&J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u001eH&J\n\u0010)\u001a\u0004\u0018\u00010\u000fH&J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u000fH\u0004J\u0015\u0010,\u001a\u00020\"2\u000b\u0010-\u001a\u00070\u000b\u00a2\u0006\u0002\b.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006/"}, d2={"Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "postfix", "", "getPostfix", "()Ljava/lang/String;", "updateTempDirectory", "Ljava/nio/file/Path;", "getUpdateTempDirectory", "()Ljava/nio/file/Path;", "trialParameter", "getTrialParameter", "download", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/DownloadResult;", "link", "buildInfo", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "suggestedIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "install", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/InstallationResult;", "downloadResult", "generateDownloadLink", "notifyAndOfferStart", "", "installationResult", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "installUltimate", "startUltimate", "", "getUltimateInstallationDirectory", "deleteInBackground", "directory", "showHint", "text", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUltimateInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UltimateInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n1#2:156\n13#3:157\n*S KotlinDebug\n*F\n+ 1 UltimateInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller\n*L\n113#1:157\n*E\n"})
public abstract class UltimateInstaller {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Project project;
    @NotNull
    private final Path updateTempDirectory;
    @NotNull
    private final String trialParameter;

    public UltimateInstaller(@NotNull CoroutineScope scope, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.scope = scope;
        this.project = project2;
        String[] stringArray = new String[]{"ultimate-upgrade"};
        Path path = Path.of(PathManager.getTempPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        this.updateTempDirectory = path;
        this.trialParameter = "-Drequest.trial=true";
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract String getPostfix();

    @NotNull
    protected final Path getUpdateTempDirectory() {
        return this.updateTempDirectory;
    }

    @NotNull
    protected final String getTrialParameter() {
        return this.trialParameter;
    }

    @NotNull
    public final DownloadResult download(@NotNull String link, @NotNull BuildInfo buildInfo, @NotNull ProgressIndicator indicator2, @NotNull SuggestedIde suggestedIde) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)suggestedIde, (String)"suggestedIde");
        Object[] objectArray = new Object[]{suggestedIde.getName()};
        String string = IdeBundle.message((String)"plugins.advertiser.try.ultimate.download.started.balloon", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showHint(string);
        String string2 = buildInfo.getNumber().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String buildNumber = string2;
        Path downloadPath = this.updateTempDirectory.resolve(buildNumber + this.getPostfix());
        try {
            HttpRequests.request((String)link).saveToFile(downloadPath.toFile(), indicator2);
        }
        catch (Exception e) {
            Intrinsics.checkNotNull((Object)downloadPath);
            this.deleteInBackground(downloadPath);
            throw e;
        }
        Intrinsics.checkNotNull((Object)downloadPath);
        return new DownloadResult(downloadPath, buildInfo.getVersion(), suggestedIde);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final InstallationResult install(@NotNull DownloadResult downloadResult2) {
        InstallationResult installationResult2;
        Intrinsics.checkNotNullParameter((Object)downloadResult2, (String)"downloadResult");
        try {
            installationResult2 = this.installUltimate(downloadResult2);
        }
        finally {
            this.deleteInBackground(downloadResult2.getDownloadPath());
        }
        return installationResult2;
    }

    @NotNull
    public final String generateDownloadLink(@NotNull BuildInfo buildInfo, @NotNull SuggestedIde suggestedIde) {
        Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkNotNullParameter((Object)suggestedIde, (String)"suggestedIde");
        String string = Registry.Companion.is("ide.try.ultimate.use.eap") ? buildInfo.getNumber().asStringWithoutProductCodeAndSnapshot() : buildInfo.getVersion();
        Intrinsics.checkNotNull((Object)string);
        String version = string;
        return suggestedIde.getBaseDownloadUrl() + "-" + version + this.getPostfix();
    }

    public final void notifyAndOfferStart(@NotNull InstallationResult installationResult2, @NotNull SuggestedIde suggestedIde, @Nullable PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)installationResult2, (String)"installationResult");
        Intrinsics.checkNotNullParameter((Object)suggestedIde, (String)"suggestedIde");
        String currentIde = ApplicationInfo.getInstance().getFullApplicationName();
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Ultimate Installed");
        Object[] objectArray = new Object[]{suggestedIde.getName()};
        String string = IdeBundle.message((String)"notification.group.advertiser.try.ultimate.installed.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray = new Object[]{currentIde};
        String string2 = IdeBundle.message((String)"notification.group.advertiser.try.ultimate.installed.content", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Supplier supplier = IdeBundle.messagePointer((String)"action.Anonymous.text.start.trial", (Object[])new Object[0]);
        Notification notification2 = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)new NotificationAction(this, pluginId, installationResult2, supplier){
            final /* synthetic */ UltimateInstaller this$0;
            final /* synthetic */ PluginId $pluginId;
            final /* synthetic */ InstallationResult $installationResult;
            {
                this.this$0 = $receiver;
                this.$pluginId = $pluginId;
                this.$installationResult = $installationResult;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                BuildersKt.launch$default((CoroutineScope)UltimateInstaller.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$pluginId, this.$installationResult, null){
                    int label;
                    final /* synthetic */ UltimateInstaller this$0;
                    final /* synthetic */ PluginId $pluginId;
                    final /* synthetic */ InstallationResult $installationResult;
                    {
                        this.this$0 = $receiver;
                        this.$pluginId = $pluginId;
                        this.$installationResult = $installationResult;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                StructuredIdeActivity openActivity = FUSEventSource.EDITOR.logTryUltimateIdeOpened(this.this$0.getProject(), this.$pluginId);
                                boolean started = this.this$0.startUltimate(this.$installationResult);
                                if (started) {
                                    StructuredIdeActivity.finished$default((StructuredIdeActivity)openActivity, null, (int)1, null);
                                    Application application = ApplicationManager.getApplication();
                                    application.invokeLater(() -> notifyAndOfferStart.notification.actionPerformed.1.invokeSuspend$lambda$0(application));
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final void invokeSuspend$lambda$0(Application $application) {
                        $application.exit(true, true, false);
                    }
                }), (int)3, null);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        Notification notification3 = notification2;
        notification3.setIcon(UltimateInstallationServiceKt.getIcon(suggestedIde));
        notification3.notify(this.project);
    }

    @Nullable
    public abstract InstallationResult installUltimate(@NotNull DownloadResult var1);

    public abstract boolean startUltimate(@NotNull InstallationResult var1);

    @Nullable
    public abstract Path getUltimateInstallationDirectory();

    protected final void deleteInBackground(@NotNull Path directory) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        CoroutineScope coroutineScope = this.scope;
        try {
            CoroutineScope $this$deleteInBackground_u24lambda_u240 = coroutineScope;
            boolean bl = false;
            PathsKt.deleteRecursively((Path)directory);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result2 = object;
        if (Result.isFailure-impl((Object)result2)) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(UltimateInstallationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Throwable throwable = Result.exceptionOrNull-impl((Object)result2);
            logger2.warn("Could not clear directories: " + (throwable != null ? ExceptionsKt.getSuppressedExceptions((Throwable)throwable) : null));
        }
    }

    private final void showHint(String text2) {
        JComponent jComponent = WindowManager.getInstance().getStatusBar(this.project).getComponent();
        if (jComponent == null) {
            return;
        }
        JComponent statusBarComponent = jComponent;
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text2, MessageType.INFO, null).setFadeoutTime(5000L).createBalloon().show(RelativePoint.getNorthEastOf((JComponent)statusBarComponent), Balloon.Position.atRight);
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(UltimateInstaller $this) {
        return $this.scope;
    }
}

