/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryManagerImpl;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.registry.ValueWithSource;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Registry", storages={@Storage(value="ide.general.xml", usePathMacroManager=false)}, useLoadedStateAsExisting=false, category=SettingsCategory.SYSTEM)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003*\u0001\t\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u001c\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!J\u000e\u0010\"\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010#R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/util/registry/RegistryManagerImpl;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/util/registry/RegistryManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "defaultValueChangeListener", "com/intellij/openapi/util/registry/RegistryManagerImpl$defaultValueChangeListener$1", "Lcom/intellij/openapi/util/registry/RegistryManagerImpl$defaultValueChangeListener$1;", "is", "", "key", "", "intValue", "", "stringValue", "Lcom/intellij/openapi/util/NlsSafe;", "defaultValue", "get", "Lcom/intellij/openapi/util/registry/RegistryValue;", "resetValueChangeListener", "", "getState", "noStateLoaded", "loadState", "state", "log", "userProperties", "", "Lcom/intellij/openapi/util/registry/ValueWithSource;", "getAll", "", "awaitRegistryLoad", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRegistryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryManagerImpl.kt\ncom/intellij/openapi/util/registry/RegistryManagerImpl\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n9#2,4:108\n13#3:112\n*S KotlinDebug\n*F\n+ 1 RegistryManagerImpl.kt\ncom/intellij/openapi/util/registry/RegistryManagerImpl\n*L\n36#1:108,4\n99#1:112\n*E\n"})
public final class RegistryManagerImpl
implements PersistentStateComponent<Element>,
RegistryManager {
    @NotNull
    private final defaultValueChangeListener.1 defaultValueChangeListener;

    public RegistryManagerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.defaultValueChangeListener = new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ((RegistryValueListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RegistryManager.TOPIC)).afterValueChanged(value);
            }
        };
        String name$iv = "registry keys adding";
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)name$iv) : null;
        boolean bl = false;
        RegistryKeyBean.Companion.addKeysFromPlugins();
        Unit result$iv = Unit.INSTANCE;
        Activity activity = activity$iv;
        if (activity != null) {
            activity.end();
        }
        Registry.Companion.setValueChangeListener((RegistryValueListener)this.defaultValueChangeListener);
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                Object object;
                2 var2_2 = this;
                try {
                    2 $this$appWillBeClosed_u24lambda_u240 = var2_2;
                    boolean bl = false;
                    EarlyAccessRegistryManager.INSTANCE.syncAndFlush();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(RegistryManagerImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                LoggerKt.getOrLogException((Object)object, (Logger)logger2);
            }
        });
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(RegistryManagerImpl::_init_$lambda$1);
    }

    public boolean is(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.Companion._getWithoutStateCheck(key).asBoolean();
    }

    public int intValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.Companion._getWithoutStateCheck(key).asInteger();
    }

    @NotNull
    public String stringValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.Companion._getWithoutStateCheck(key).asString();
    }

    public int intValue(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            return Registry.Companion._getWithoutStateCheck(key).asInteger();
        }
        catch (MissingResourceException missingResourceException) {
            return defaultValue;
        }
    }

    @NotNull
    public RegistryValue get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.Companion._getWithoutStateCheck(key);
    }

    public void resetValueChangeListener() {
        Registry.Companion.setValueChangeListener((RegistryValueListener)this.defaultValueChangeListener);
    }

    @NotNull
    public Element getState() {
        return Registry.Companion.getInstance().getState();
    }

    public void noStateLoaded() {
        Registry.Companion.loadState(null, EarlyAccessRegistryManager.INSTANCE.getOrLoadMap());
    }

    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.log(Registry.Companion.loadState(state2, EarlyAccessRegistryManager.INSTANCE.getOrLoadMap()));
    }

    private final void log(Map<String, ValueWithSource> userProperties) {
        if (userProperties.size() <= (userProperties.containsKey("ide.firstStartup") ? 1 : 0)) {
            return;
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)userProperties.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        String[] keys = stringArray;
        ArraysKt.sort((Object[])((Comparable[])keys));
        StringBuilder builder = new StringBuilder("Registry values changed by user: ");
        for (String key : keys) {
            if (Intrinsics.areEqual((Object)"ide.firstStartup", (Object)key)) continue;
            ValueWithSource valueWithSource = userProperties.get(key);
            builder.append(key).append(" = ").append(valueWithSource != null ? valueWithSource.getValue() : null).append(", ");
        }
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(RegistryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.info(builder.substring(0, builder.length() - 2));
    }

    @NotNull
    public final List<RegistryValue> getAll() {
        return Registry.Companion.getAll();
    }

    @Nullable
    public Object awaitRegistryLoad(@NotNull Continuation<? super Unit> $completion) {
        Object object = Registry.Companion.awaitLoad($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Throwable it) {
        Registry.Companion.setValueChangeListener(null);
        return Unit.INSTANCE;
    }
}

