/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.PresentableFileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.ReadonlyStatusHandlerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.project.ProjectKt;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
@ApiStatus.Internal
public final class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandlerBase
implements PersistentStateComponent<State> {
    private final Project myProject;
    private boolean myClearReadOnlyInTests;
    private State myState;

    public ReadonlyStatusHandlerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myState = new State();
        this.myProject = project2;
    }

    @NotNull
    public State getState() {
        State state2 = this.myState;
        if (state2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(1);
        }
        return state2;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(2);
        }
        this.myState = state2;
    }

    @NotNull
    protected ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles, Collection<? extends VirtualFile> files2) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(3);
        }
        IProjectStore stateStore = this.myProject instanceof ProjectStoreOwner ? ProjectKt.getStateStore((Project)this.myProject) : null;
        Map<Boolean, List<FileInfo>> projectFilesAndOthersInfos = files2.stream().filter(vf -> vf != null && !vf.isWritable() && vf.isInLocalFileSystem()).map(vf -> new FileInfo((VirtualFile)vf, this.myProject)).collect(Collectors.partitioningBy(info -> stateStore != null && stateStore.isProjectFile(info.getFile())));
        List<FileInfo> projectFiles = projectFilesAndOthersInfos.get(true);
        List<FileInfo> fileInfos = projectFilesAndOthersInfos.get(false);
        if (fileInfos.isEmpty() && projectFiles.isEmpty()) {
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(4);
            }
            return operationStatus;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ArrayList<FileInfo> allInfos = new ArrayList<FileInfo>(fileInfos.size() + projectFiles.size());
                allInfos.addAll(fileInfos);
                allInfos.addAll(projectFiles);
                ReadonlyStatusHandlerImpl.processFiles(allInfos, null, false);
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(5);
            }
            return operationStatus;
        }
        if (!projectFiles.isEmpty()) {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(projectFiles), null, false);
            if (fileInfos.isEmpty()) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
                if (operationStatus == null) {
                    ReadonlyStatusHandlerImpl.$$$reportNull$$$0(6);
                }
                return operationStatus;
            }
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            List presentableFileInfos = (List)ActionUtil.underModalProgress((Project)this.myProject, (String)FileTypesBundle.message("progress.title.resolving.filetype", new Object[0]), () -> this.createPresentableFileInfos(fileInfos));
            new ReadOnlyStatusDialog(this.myProject, presentableFileInfos).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(fileInfos), null, false);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
        if (operationStatus == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(7);
        }
        return operationStatus;
    }

    private @Unmodifiable List<PresentableFileInfo> createPresentableFileInfos(List<? extends FileInfo> fileInfos) {
        return ContainerUtil.map(fileInfos, fileInfo -> {
            TargetPresentationBuilder builder = TargetPresentation.builder((String)fileInfo.getFile().getPresentableName()).icon(VirtualFilePresentation.getIcon((VirtualFile)fileInfo.getFile())).presentableText(fileInfo.getFile().getPresentableName());
            VirtualFile vfParent = fileInfo.getFile().getParent();
            if (vfParent != null) {
                builder = builder.locationText(vfParent.getPresentableUrl());
            }
            return new PresentableFileInfo(fileInfo.getFile(), builder.presentation(), this.myProject);
        });
    }

    static void processFiles(@NotNull List<? extends FileInfo> fileInfos, @Nullable String changelist, boolean setChangeListActive) {
        if (fileInfos == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(8);
        }
        FileInfo[] copy2 = fileInfos.toArray(new FileInfo[0]);
        MultiMap handleTypeToFile = new MultiMap();
        for (FileInfo fileInfo : copy2) {
            handleTypeToFile.putValue((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist, setChangeListActive);
        }
        for (FileInfo fileInfo : copy2) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    @TestOnly
    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class State {
        public boolean SHOW_DIALOG = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state2 = (State)o;
            return this.SHOW_DIALOG == state2.SHOW_DIALOG;
        }

        public int hashCode() {
            return this.SHOW_DIALOG ? 1 : 0;
        }
    }
}

