/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.DisplayChangeDetector;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEditServiceListener;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.idea.AppMode;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImplKt;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.DefaultFrameHeader;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionGroupPanelWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionsWithPanelProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrameKt;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeSeparateBalloonLayoutImpl;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DisposableWindow;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u000289B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010(\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010*H\u0004J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0004J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u000201H\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u000207H\u0016R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006:"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame;", "Ljavax/swing/JFrame;", "Lcom/intellij/openapi/wm/IdeFrame;", "Lcom/intellij/util/ui/accessibility/AccessibleContextAccessor;", "Lcom/intellij/ui/DisposableWindow;", "suggestedScreen", "Lcom/intellij/openapi/wm/impl/welcomeScreen/AbstractWelcomeScreen;", "<init>", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/AbstractWelcomeScreen;)V", "screen", "getScreen", "()Lcom/intellij/openapi/wm/impl/welcomeScreen/AbstractWelcomeScreen;", "content", "Lcom/intellij/ui/components/panels/Wrapper;", "balloonLayout", "Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeBalloonLayoutImpl;", "isDisposed", "", "header", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/DefaultFrameHeader;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "displayChangeListener", "Lcom/intellij/ide/DisplayChangeDetector$Listener;", "createBalloonLayout", "removeNotify", "", "setupCloseAction", "updateComponentsAndResize", "addNotify", "dispose", "isWindowDisposed", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "getCurrentAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "welcomeFrameTitle", "", "getWelcomeFrameTitle", "()Ljava/lang/String;", "extendActionsGroup", "panel", "Ljavax/swing/JPanel;", "onFirstActionShown", "action", "Ljava/awt/Component;", "getBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "getProject", "Lcom/intellij/openapi/project/Project;", "setFrameTitle", "title", "getComponent", "Ljavax/swing/JComponent;", "Companion", "FlatWelcomeScreen", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFlatWelcomeFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatWelcomeFrame.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,543:1\n42#2,3:544\n*S KotlinDebug\n*F\n+ 1 FlatWelcomeFrame.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame\n*L\n85#1:544,3\n*E\n"})
public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
AccessibleContextAccessor,
DisposableWindow {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AbstractWelcomeScreen screen;
    @NotNull
    private final Wrapper content;
    @Nullable
    private WelcomeBalloonLayoutImpl balloonLayout;
    private boolean isDisposed;
    @Nullable
    private DefaultFrameHeader header;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final DisplayChangeDetector.Listener displayChangeListener;
    @JvmField
    public static boolean USE_TABBED_WELCOME_SCREEN;
    @NotNull
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    @NotNull
    public static final String CUSTOM_HEADER = "CUSTOM_HEADER";
    @JvmField
    public static final int DEFAULT_HEIGHT;
    @JvmField
    public static final int MAX_DEFAULT_WIDTH;

    @JvmOverloads
    public FlatWelcomeFrame(@Nullable AbstractWelcomeScreen suggestedScreen) {
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, (boolean)false, (int)3, null);
        this.displayChangeListener = () -> FlatWelcomeFrame.displayChangeListener$lambda$0(this);
        JRootPane rootPane = this.getRootPane();
        this.balloonLayout = this.createBalloonLayout();
        AbstractWelcomeScreen abstractWelcomeScreen = suggestedScreen;
        if (abstractWelcomeScreen == null) {
            abstractWelcomeScreen = new FlatWelcomeScreen(this);
        }
        this.screen = abstractWelcomeScreen;
        IdeGlassPaneImplKt.executeOnCancelInEdt(this.coroutineScope, (Function0<Unit>)((Function0)() -> FlatWelcomeFrame._init_$lambda$0(this)));
        this.content = new Wrapper();
        this.setContentPane((Container)this.content);
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            this.header = new DefaultFrameHeader(this, false);
            Window window = this;
            JComponent jComponent = this.screen.getWelcomePanel();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getWelcomePanel(...)");
            DefaultFrameHeader defaultFrameHeader = this.header;
            Intrinsics.checkNotNull((Object)defaultFrameHeader);
            this.content.setContent(CustomFrameDialogContent.Companion.getCustomContentHolder(window, jComponent, defaultFrameHeader));
            this.getLayeredPane().putClientProperty(CUSTOM_HEADER, this.header);
        } else {
            FlatWelcomeFrameKt.access$createWelcomeMenuBar(this, this.coroutineScope);
            this.content.setContent(this.screen.getWelcomePanel());
        }
        Intrinsics.checkNotNull((Object)rootPane);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane, false, 2, null);
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.updateComponentsAndResize();
        UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)this, this::pack, null, (int)4, null);
        Application app = ApplicationManager.getApplication();
        SimpleMessageBusConnection connection = app.getMessageBus().connect(this.coroutineScope);
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.dispose();
            }
        });
        connection.subscribe(LightEditServiceListener.Companion.getTOPIC(), (Object)new LightEditServiceListener(){

            public void lightEditWindowOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.dispose();
            }
        });
        Topic topic2 = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new AppLifecycleListener(){

            public void appClosing() {
                Rectangle rectangle = this.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                Companion.saveSizeAndLocation(rectangle);
            }
        });
        Topic topic3 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        connection.subscribe(topic3, arg_0 -> FlatWelcomeFrame._init_$lambda$1(this, arg_0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Intrinsics.checkNotNullParameter((Object)componentEvent, (String)"componentEvent");
                if (WindowStateService.getInstance().getSize("WELCOME_SCREEN") != null) {
                    Rectangle rectangle = this.getBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                    Companion.saveSizeAndLocation(rectangle);
                }
            }
        });
        if (AppMode.isRemoteDevHost()) {
            DisplayChangeDetector.getInstance().addListener(this.displayChangeListener);
        }
        this.setupCloseAction();
        MnemonicHelper.init((Component)this);
        ComponentUtil.decorateWindowHeader((JRootPane)this.getRootPane());
        ToolbarService toolbarService = ToolbarService.Companion.getInstance();
        Window window = this;
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        toolbarService.setTransparentTitleBar(window, jRootPane, arg_0 -> FlatWelcomeFrame._init_$lambda$2(this, arg_0));
        app.invokeLater(FlatWelcomeFrame::_init_$lambda$3, ModalityState.nonModal());
    }

    public /* synthetic */ FlatWelcomeFrame(AbstractWelcomeScreen abstractWelcomeScreen, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            abstractWelcomeScreen = USE_TABBED_WELCOME_SCREEN ? (AbstractWelcomeScreen)new TabbedWelcomeScreen() : null;
        }
        this(abstractWelcomeScreen);
    }

    @NotNull
    public final AbstractWelcomeScreen getScreen() {
        return this.screen;
    }

    private final WelcomeBalloonLayoutImpl createBalloonLayout() {
        JBInsets jBInsets = JBUI.insets((int)8);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        JBInsets insets = jBInsets;
        if (ExperimentalUI.Companion.isNewUI()) {
            JRootPane jRootPane = this.rootPane;
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
            return new WelcomeSeparateBalloonLayoutImpl(jRootPane, (Insets)insets);
        }
        return new WelcomeBalloonLayoutImpl(this.rootPane, (Insets)insets);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        }
    }

    protected void setupCloseAction() {
        WelcomeFrame.Companion.setupCloseAction(this);
    }

    private final void updateComponentsAndResize() {
        int defaultHeight = DEFAULT_HEIGHT;
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            Color backgroundColor = UIManager.getColor("WelcomeScreen.background");
            if (backgroundColor != null) {
                DefaultFrameHeader defaultFrameHeader = this.header;
                Intrinsics.checkNotNull((Object)defaultFrameHeader);
                defaultFrameHeader.setBackground(backgroundColor);
            }
        } else {
            FlatWelcomeFrameKt.access$createWelcomeMenuBar(this, this.coroutineScope);
            this.content.setContent(this.screen.getWelcomePanel());
        }
        if (USE_TABBED_WELCOME_SCREEN) {
            JBDimension jBDimension = JBUI.size((int)MAX_DEFAULT_WIDTH, (int)defaultHeight);
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
            JBDimension defaultSize = jBDimension;
            Dimension dimension = WindowStateService.getInstance().getSize("WELCOME_SCREEN");
            if (dimension == null) {
                dimension = (Dimension)defaultSize;
            }
            this.setPreferredSize(dimension);
            this.setMinimumSize((Dimension)defaultSize);
        } else {
            int width = RecentProjectListActionProvider.getActionsWithoutGroups$default(RecentProjectListActionProvider.Companion.getInstance(), false, null, 3, null).isEmpty() ? 666 : MAX_DEFAULT_WIDTH;
            this.setPreferredSize((Dimension)JBUI.size((int)width, (int)defaultHeight));
        }
        this.setResizable(USE_TABBED_WELCOME_SCREEN);
        Dimension size2 = this.getPreferredSize();
        Point location = WindowStateService.getInstance().getLocation("WELCOME_SCREEN");
        Point point = location;
        if (point == null) {
            point = new Point(0, 0);
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)point);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle screenBounds = rectangle;
        this.setBounds(screenBounds.x + (screenBounds.width - size2.width) / 2, screenBounds.y + (screenBounds.height - size2.height) / 3, size2.width, size2.height);
        ComponentUtil.decorateWindowHeader((JRootPane)this.getRootPane());
        this.setTitle("");
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtilKt.updateAppWindowIcon(this);
    }

    @Override
    public void addNotify() {
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            CustomHeader.Companion.enableCustomHeader(this);
        }
        super.addNotify();
    }

    @Override
    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        super.dispose();
        WelcomeBalloonLayoutImpl welcomeBalloonLayoutImpl = this.balloonLayout;
        if (welcomeBalloonLayoutImpl != null) {
            WelcomeBalloonLayoutImpl it = welcomeBalloonLayoutImpl;
            boolean bl = false;
            this.balloonLayout = null;
            it.dispose();
        }
        Disposer.dispose((Disposable)((Disposable)this.screen));
        WelcomeFrame.Companion.resetInstance();
        if (AppMode.isRemoteDevHost()) {
            DisplayChangeDetector.getInstance().removeListener(this.displayChangeListener);
        }
    }

    public boolean isWindowDisposed() {
        return this.isDisposed;
    }

    @Nullable
    public StatusBar getStatusBar() {
        return null;
    }

    @Nullable
    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    private final String getWelcomeFrameTitle() {
        String string = WelcomeScreenComponentFactory.getApplicationTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationTitle(...)");
        return string;
    }

    protected final void extendActionsGroup(@Nullable JPanel panel2) {
    }

    protected final void onFirstActionShown(@NotNull Component action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.balloonLayout;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        return rectangle;
    }

    @Nullable
    public Project getProject() {
        return ApplicationManager.getApplication().isDisposed() ? null : ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(@NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.setTitle(title2);
    }

    @NotNull
    public JComponent getComponent() {
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return jRootPane;
    }

    @JvmOverloads
    public FlatWelcomeFrame() {
        this(null, 1, null);
    }

    private static final void displayChangeListener$lambda$0(FlatWelcomeFrame this$0) {
        this$0.updateComponentsAndResize();
    }

    private static final Unit lambda$2$0(Runnable $runnable, Throwable it) {
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(FlatWelcomeFrame this$0) {
        Disposer.dispose((Disposable)((Disposable)this$0.screen));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(FlatWelcomeFrame this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WelcomeBalloonLayoutImpl welcomeBalloonLayoutImpl = this$0.balloonLayout;
        if (welcomeBalloonLayoutImpl != null) {
            welcomeBalloonLayoutImpl.dispose();
        }
        this$0.balloonLayout = this$0.createBalloonLayout();
        this$0.updateComponentsAndResize();
        this$0.repaint();
    }

    private static final Unit _init_$lambda$2(FlatWelcomeFrame this$0, Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        JobKt.getJob((CoroutineContext)this$0.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> FlatWelcomeFrame.lambda$2$0(runnable2, arg_0));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3() {
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        Intrinsics.checkNotNull((Object)notificationsManager, (String)"null cannot be cast to non-null type com.intellij.notification.impl.NotificationsManagerImpl");
        ((NotificationsManagerImpl)notificationsManager).dispatchEarlyNotifications();
    }

    @JvmStatic
    @NotNull
    public static final JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
        return Companion.getPreferredFocusedComponent(pair);
    }

    static {
        int n;
        Companion = new Companion(null);
        USE_TABBED_WELCOME_SCREEN = Boolean.parseBoolean(System.getProperty("use.tabbed.welcome.screen", "true"));
        if (USE_TABBED_WELCOME_SCREEN) {
            String string = System.getProperty("welcome.screen.defaultHeight", "650");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            n = Integer.parseInt(string);
        } else {
            n = 460;
        }
        DEFAULT_HEIGHT = n;
        String string = System.getProperty("welcome.screen.defaultWidth", "800");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        MAX_DEFAULT_WIDTH = Integer.parseInt(string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00112\u001c\u0010\u0012\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00150\u0013H\u0007R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$Companion;", "", "<init>", "()V", "USE_TABBED_WELCOME_SCREEN", "", "BOTTOM_PANEL", "", "CUSTOM_HEADER", "DEFAULT_HEIGHT", "", "MAX_DEFAULT_WIDTH", "saveSizeAndLocation", "", "location", "Ljava/awt/Rectangle;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "pair", "Lcom/intellij/openapi/util/Pair;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void saveSizeAndLocation(Rectangle location) {
            Point middle = new Point(location.x + location.width / 2, location.y + location.height / 2);
            WindowStateService windowStateService = WindowStateService.getInstance();
            windowStateService.putLocation("WELCOME_SCREEN", middle);
            windowStateService.putSize("WELCOME_SCREEN", location.getSize());
        }

        @JvmStatic
        @NotNull
        public final JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
            JBTextField textField2;
            Intrinsics.checkNotNullParameter(pair, (String)"pair");
            if (((JBList)pair.second).getModel().getSize() == 1 && (textField2 = (JBTextField)UIUtil.uiTraverser((Component)((Component)pair.first)).filter(JBTextField.class).first()) != null) {
                return (JComponent)textField2;
            }
            Object object = pair.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            return (JComponent)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/AbstractWelcomeScreen;", "frame", "Lcom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame;", "<init>", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame;)V", "touchbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "inDnd", "", "paint", "", "g", "Ljava/awt/Graphics;", "createBody", "Ljavax/swing/JComponent;", "createSettingsAndDocsPanel", "createQuickStartActionPanel", "Lcom/intellij/openapi/wm/impl/welcomeScreen/ActionPanel;", "intellij.platform.ide.impl"})
    private static final class FlatWelcomeScreen
    extends AbstractWelcomeScreen {
        @NotNull
        private final FlatWelcomeFrame frame;
        @NotNull
        private final DefaultActionGroup touchbarActions;
        private boolean inDnd;

        public FlatWelcomeScreen(@NotNull FlatWelcomeFrame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this.frame = frame;
            this.touchbarActions = new DefaultActionGroup();
            this.setBackground(WelcomeScreenUIManager.getMainBackground());
            if (!((Collection)RecentProjectListActionProvider.getActions$default(RecentProjectListActionProvider.Companion.getInstance(), false, true, false, 4, null)).isEmpty()) {
                final JComponent recentProjects = WelcomeScreenComponentFactory.createRecentProjects((Disposable)this);
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.removeIfNeeded();
                        }

                        private final void removeIfNeeded() {
                            if (RecentProjectListActionProvider.getActions$default(RecentProjectListActionProvider.Companion.getInstance(), false, true, false, 4, null).isEmpty()) {
                                this.remove(recentProjects);
                                this.revalidate();
                                this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
            this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetDragEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.setDnd(true);
                }

                @Override
                public void dragExit(DropTargetEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.setDnd(false);
                }

                @Override
                public void drop(DropTargetDropEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.setDnd(false);
                    e.acceptDrop(3);
                    Transferable transferable = e.getTransferable();
                    List<Path> list2 = FileCopyPasteUtil.getFiles(transferable);
                    if (list2 != null && list2.size() > 0) {
                        BuildersKt.launch$default((CoroutineScope)frame.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(list2, null){
                            int label;
                            final /* synthetic */ List<Path> $list;
                            {
                                this.$list = $list;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ProjectUtil.openOrImportFilesAsync$default(ProjectUtil.INSTANCE, this.$list, "WelcomeFrame", null, (Continuation)this, 4, null);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        e.dropComplete(true);
                        return;
                    }
                    e.dropComplete(false);
                }

                private final void setDnd(boolean dnd) {
                    inDnd = dnd;
                    this.repaint();
                }
            }));
            TouchbarActionCustomizations.setShowText((AnAction)((AnAction)this.touchbarActions), (boolean)true);
            Touchbar.setActions((JComponent)this, (ActionGroup)((ActionGroup)this.touchbarActions));
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paint(g);
            if (!this.inDnd) {
                return;
            }
            Rectangle bounds = this.getBounds();
            g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            Color backgroundBorder = JBUI.CurrentTheme.DragAndDrop.BORDER_COLOR;
            g.setColor(backgroundBorder);
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            Color foreground = JBUI.CurrentTheme.DragAndDrop.Area.FOREGROUND;
            g.setColor(foreground);
            Font labelFont = StartupUiUtil.getLabelFont();
            Font font = labelFont.deriveFont((float)labelFont.getSize() + 5.0f);
            String string = IdeBundle.message((String)"welcome.screen.drop.files.to.open.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String drop2 = string;
            g.setFont(font);
            int dropWidth = g.getFontMetrics().stringWidth(drop2);
            int dropHeight = g.getFontMetrics().getHeight();
            g.drawString(drop2, bounds.x + (bounds.width - dropWidth) / 2, (int)((double)bounds.y + (double)(bounds.height - dropHeight) * 0.45));
        }

        private final JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)WelcomeScreenComponentFactory.createLogo(), (Object)"North");
            this.touchbarActions.removeAll();
            ActionPanel actionPanel = this.createQuickStartActionPanel();
            panel2.add((Component)actionPanel, (Object)"Center");
            this.touchbarActions.addAll((Collection)actionPanel.getActions());
            panel2.add((Component)this.createSettingsAndDocsPanel(this.frame), (Object)"South");
            return (JComponent)panel2;
        }

        private final JComponent createSettingsAndDocsPanel(FlatWelcomeFrame frame) {
            JPanel panel2 = (JPanel)new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar2 = new NonOpaquePanel();
            toolbar2.setLayout((LayoutManager)new BoxLayout((Container)toolbar2, 0));
            toolbar2.add((Component)WelcomeScreenComponentFactory.createErrorsLink((Disposable)this));
            toolbar2.add((Component)WelcomeScreenComponentFactory.createEventLink(IdeBundle.message((String)"action.Events", (Object[])new Object[0]), ApplicationManager.getApplication().getMessageBus().connect(frame.coroutineScope)));
            toolbar2.add((Component)WelcomeScreenComponentFactory.createActionLink(frame, IdeBundle.message((String)"action.Anonymous.text.configure", (Object[])new Object[0]), "WelcomeScreen.Configure", AllIcons.General.GearPlain, UIUtil.findComponentOfType((JComponent)frame.rootPane, JList.class)));
            toolbar2.add((Component)WelcomeScreenComponentFactory.createActionLink(frame, IdeBundle.message((String)"action.GetHelp", (Object[])new Object[0]), "WelcomeScreen.Documentation", null, null));
            panel2.add((Component)toolbar2, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel2;
        }

        private final ActionPanel createQuickStartActionPanel() {
            PresentationFactory presentationFactory = new PresentationFactory();
            AnAction anAction = ActionManager.getInstance().getAction("WelcomeScreen.QuickStart");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup quickStartGroup = (ActionGroup)anAction;
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            DataContext dataContext3 = dataContext2;
            List<AnAction> visibleActions = Utils.expandActionGroup(quickStartGroup, presentationFactory, dataContext3, "WelcomeScreen", ActionUiKind.NONE);
            ActionPanel mainPanel = new ActionPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, gap 5, flowy", "push[pref!, center]push"));
            mainPanel.setOpaque(false);
            VerticalLayout verticalLayout = new VerticalLayout(JBUI.scale((int)5));
            JPanel panel2 = new JPanel(this, verticalLayout){
                private Component firstAction;
                final /* synthetic */ FlatWelcomeScreen this$0;
                {
                    this.this$0 = $receiver;
                    super((LayoutManager)$super_call_param$1);
                }

                public Component add(Component comp) {
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    Component cmp = super.add(comp);
                    if (this.firstAction == null) {
                        this.firstAction = cmp;
                    }
                    Intrinsics.checkNotNull((Object)cmp);
                    return cmp;
                }

                public void addNotify() {
                    super.addNotify();
                    if (this.firstAction != null) {
                        FlatWelcomeFrame flatWelcomeFrame = FlatWelcomeScreen.access$getFrame$p(this.this$0);
                        Component component2 = this.firstAction;
                        Intrinsics.checkNotNull((Object)component2);
                        flatWelcomeFrame.onFirstActionShown(component2);
                    }
                }
            };
            panel2.setOpaque(false);
            this.frame.extendActionsGroup(mainPanel);
            mainPanel.add(panel2);
            for (AnAction action2 : visibleActions) {
                Icon icon2;
                Presentation presentation2;
                Intrinsics.checkNotNullExpressionValue((Object)presentationFactory.getPresentation(action2), (String)"getPresentation(...)");
                String text2 = presentation2.getText();
                if (text2 != null && StringsKt.endsWith$default((String)text2, (String)"...", (boolean)false, (int)2, null)) {
                    String string = text2.substring(0, text2.length() - 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    text2 = string;
                }
                if ((icon2 = presentation2.getIcon()) == null || icon2.getIconHeight() != JBUIScale.scale((int)16) || icon2.getIconWidth() != JBUIScale.scale((int)16)) {
                    Icon icon3;
                    Icon icon4 = icon2;
                    if (icon4 == null) {
                        EmptyIcon emptyIcon = EmptyIcon.create((int)16);
                        Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"create(...)");
                        icon3 = (Icon)JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)emptyIcon));
                    } else {
                        icon3 = IconUtil.scale((Icon)icon4, null, (float)(16.0f / (float)icon2.getIconWidth()));
                    }
                    icon2 = icon3;
                    icon2 = IconUtil.colorize$default((Icon)icon2, (Color)((Color)new JBColor(0x6E6E6E, 11514291)), (boolean)false, (boolean)false, (int)12, null);
                }
                AnAction anAction2 = action2 instanceof ActionGroup && action2 instanceof ActionsWithPanelProvider ? ActionGroupPanelWrapper.wrapGroups((ActionGroup)action2, (Disposable)this) : action2;
                Intrinsics.checkNotNull((Object)anAction2);
                AnAction wrapper2 = anAction2;
                ActionLink link = new ActionLink(text2, icon2, wrapper2, null, "WelcomeScreen");
                link.setFocusable(false);
                link.setPaintUnderline(false);
                link.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
                WelcomeScreenComponentFactory.JActionLinkPanel button2 = new WelcomeScreenComponentFactory.JActionLinkPanel(link);
                button2.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                if (wrapper2 instanceof WelcomePopupAction) {
                    button2.add((Component)WelcomeScreenComponentFactory.createArrow(link), "East");
                    TouchbarActionCustomizations.setComponent((AnAction)wrapper2, (JComponent)((JComponent)link));
                }
                WelcomeScreenFocusManager.installFocusable(this.frame, button2, wrapper2, 40, 38, UIUtil.findComponentOfType((JComponent)this.frame.getComponent(), JList.class));
                panel2.add(button2);
                mainPanel.addAction(wrapper2);
            }
            return mainPanel;
        }
    }
}

