/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u0019\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u000b\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00028\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\"\u001a\u00020#H\u0096\u0080\u0004J\n\u0010$\u001a\u00020\bH\u0096\u0080\u0004J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010%H\u0016J\u000b\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0006\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/intellij/serialization/stateProperties/CollectionStoredProperty;", "E", "", "C", "", "Lcom/intellij/openapi/components/StoredPropertyBase;", "value", "defaultValue", "", "<init>", "(Ljava/util/Collection;Ljava/lang/String;)V", "getValue", "()Ljava/util/Collection;", "Ljava/util/Collection;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "isEqualToDefault", "", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "(Lcom/intellij/openapi/components/BaseState;)Ljava/util/Collection;", "setValue", "", "newValue", "(Lcom/intellij/openapi/components/BaseState;Ljava/util/Collection;)V", "doSetValue", "old", "new", "", "(Ljava/util/Collection;Ljava/util/Collection;)Z", "equals", "other", "hashCode", "", "toString", "Lcom/intellij/openapi/components/StoredProperty;", "__getValue", "intellij.platform.objectSerializer"})
@ApiStatus.Internal
public class CollectionStoredProperty<E, C extends Collection<E>>
extends StoredPropertyBase<C> {
    @NotNull
    private final C value;
    @Nullable
    private final String defaultValue;

    public CollectionStoredProperty(@NotNull C value, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.value = value;
        this.defaultValue = defaultValue;
    }

    @NotNull
    protected final C getValue() {
        return this.value;
    }

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.ARRAY;
    }

    public boolean isEqualToDefault() {
        return this.defaultValue == null ? this.value.isEmpty() : this.value.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((Iterable)((Iterable)this.value)), (Object)this.defaultValue);
    }

    @NotNull
    public C getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, @NotNull C newValue) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        if (this.doSetValue(this.value, (Collection<? extends E>)newValue)) {
            thisRef.intIncrementModificationCount();
        }
    }

    private final boolean doSetValue(C old, Collection<? extends E> collection) {
        if (Intrinsics.areEqual(old, collection)) {
            return false;
        }
        old.clear();
        old.addAll(collection);
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CollectionStoredProperty && Intrinsics.areEqual(this.value, ((CollectionStoredProperty)((Object)other)).value) && Intrinsics.areEqual((Object)this.defaultValue, (Object)((CollectionStoredProperty)((Object)other)).defaultValue);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getName() + " = " + (this.isEqualToDefault() ? "" : CollectionsKt.joinToString$default((Iterable)((Iterable)this.value), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
    }

    public boolean setValue(@NotNull StoredProperty<C> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.doSetValue(this.value, (Collection<? extends E>)((CollectionStoredProperty)other).value);
    }

    @NotNull
    public final C __getValue() {
        return this.value;
    }
}

