/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.tree.ui.PlainSelectionTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JBTreeTable
extends JComponent
implements TreePathBackgroundSupplier {
    private final Tree myTree;
    private final Table myTable;
    private final OnePixelSplitter split;
    private TreeTableModel myModel;
    private JTableHeader myTreeTableHeader;
    private float myColumnProportion;

    public JBTreeTable(@NotNull TreeTableModel model2) {
        if (model2 == null) {
            JBTreeTable.$$$reportNull$$$0(0);
        }
        this(model2, null);
    }

    public JBTreeTable(@NotNull TreeTableModel model2, @Nullable Tree tree2) {
        if (model2 == null) {
            JBTreeTable.$$$reportNull$$$0(1);
        }
        this.myColumnProportion = 0.1f;
        this.setLayout(new BorderLayout());
        this.myTree = tree2 == null ? new MyTree() : tree2;
        this.myTable = new Table();
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.setBorder((Border)JBUI.Borders.empty());
        this.myTable.setShowGrid(false);
        this.myTable.setSelectionMode(0);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.split = new OnePixelSplitter(){

            protected Divider createDivider() {
                return new OnePixelDivider(this.isVertical(), (Splittable)this){

                    public void paint(Graphics g) {
                        Rectangle bounds = g.getClipBounds();
                        g.setColor(JBTreeTable.this.myTable.getShowVerticalLines() ? JBTreeTable.this.myTable.getGridColor() : JBTreeTable.this.myTable.getBackground());
                        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        JTableHeader header = JBTreeTable.this.myTreeTableHeader;
                        Rectangle rect = header.getHeaderRect(0);
                        g.setClip(rect.x, rect.y, 2, rect.height);
                        g.translate(-rect.width + 1, 0);
                        header.paint(g);
                    }
                };
            }
        };
        this.add((Component)this.split);
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)0);
        this.split.setFirstComponent((JComponent)treePane);
        final JScrollPane tablePane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)0);
        this.split.setSecondComponent((JComponent)tablePane);
        SelectionSupport selection = new SelectionSupport();
        treePane.setColumnHeaderView(this.myTreeTableHeader);
        treePane.getHorizontalScrollBar().addComponentListener(new ComponentAdapter(this){
            {
                if (tablePane.isVisible()) {
                    tablePane.setHorizontalScrollBarPolicy(32);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                tablePane.setHorizontalScrollBarPolicy(32);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                tablePane.setHorizontalScrollBarPolicy(31);
            }
        });
        int scrollMode = !SystemInfo.isMac ? 0 : 1;
        treePane.getViewport().setScrollMode(scrollMode);
        tablePane.setVerticalScrollBar(treePane.getVerticalScrollBar());
        tablePane.getViewport().setScrollMode(scrollMode);
        this.myTree.getSelectionModel().addTreeSelectionListener(selection);
        this.myTable.getSelectionModel().addListSelectionListener(selection);
        this.myTable.setRowMargin(0);
        this.myTable.addMouseListener(selection);
        this.myTree.addPropertyChangeListener("rowHeight", evt -> {
            int treeRowHeight = this.myTree.getRowHeight();
            if (treeRowHeight == this.myTable.getRowHeight()) {
                return;
            }
            this.myTable.setRowHeight(treeRowHeight);
        });
        this.myTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                TreeColumnModel cm = (TreeColumnModel)JBTreeTable.this.myTreeTableHeader.getColumnModel();
                TableCellRenderer renderer2 = JBTreeTable.this.getDefaultRenderer(TreeTableModel.class);
                return renderer2.getTableCellRendererComponent((JTable)((Object)JBTreeTable.this.myTable), value, selected, hasFocus, row2, cm.treeColumnIndex);
            }
        });
        this.myTree.putClientProperty((Object)RenderingUtil.FOCUSABLE_SIBLING, (Object)this.myTable);
        this.myTable.putClientProperty(RenderingUtil.FOCUSABLE_SIBLING, this.myTree);
        this.setModel(model2);
    }

    @NotNull
    public Tree getTree() {
        Tree tree2 = this.myTree;
        if (tree2 == null) {
            JBTreeTable.$$$reportNull$$$0(2);
        }
        return tree2;
    }

    @NotNull
    public JBTable getTable() {
        Table table2 = this.myTable;
        if (table2 == null) {
            JBTreeTable.$$$reportNull$$$0(3);
        }
        return table2;
    }

    @ApiStatus.Internal
    @NotNull
    public final OnePixelSplitter getSplitter() {
        OnePixelSplitter onePixelSplitter = this.split;
        if (onePixelSplitter == null) {
            JBTreeTable.$$$reportNull$$$0(4);
        }
        return onePixelSplitter;
    }

    public void setDefaultRenderer(@NotNull Class<?> columnClass, @NotNull TableCellRenderer renderer2) {
        if (columnClass == null) {
            JBTreeTable.$$$reportNull$$$0(5);
        }
        if (renderer2 == null) {
            JBTreeTable.$$$reportNull$$$0(6);
        }
        this.myTable.setDefaultRenderer(columnClass, renderer2);
    }

    @NotNull
    public TableCellRenderer getDefaultRenderer(@NotNull Class<?> columnClass) {
        if (columnClass == null) {
            JBTreeTable.$$$reportNull$$$0(7);
        }
        TableCellRenderer tableCellRenderer = this.myTable.getDefaultRenderer(columnClass);
        if (tableCellRenderer == null) {
            JBTreeTable.$$$reportNull$$$0(8);
        }
        return tableCellRenderer;
    }

    public void setModel(@NotNull TreeTableModel model2) {
        if (model2 == null) {
            JBTreeTable.$$$reportNull$$$0(9);
        }
        this.myModel = model2;
        this.myTree.setModel((TreeModel)model2);
        this.myTable.setModel((TableModel)new TreeTableModelAdapter(model2, (JTree)this.myTree, (JTable)((Object)this.myTable)));
        TreeColumnModel tcm = (TreeColumnModel)this.myTreeTableHeader.getColumnModel();
        if (tcm.treeColumnIndex >= 0) {
            this.myTable.removeColumn(this.myTable.getColumnModel().getColumn(tcm.treeColumnIndex));
        }
        if (this.myTree.getRowHeight() < 1) {
            this.myTable.setRowHeight(JBUIScale.scale((int)18));
        } else {
            this.myTable.setRowHeight(this.myTree.getRowHeight());
        }
        this.setColumnProportion(this.myColumnProportion);
    }

    public void setColumnProportion(float columnProportion) {
        this.myColumnProportion = columnProportion;
        this.split.setProportion(1.0f - (float)(this.myModel.getColumnCount() - 1) * columnProportion);
    }

    public float getColumnProportion() {
        return this.myColumnProportion;
    }

    public TreeTableModel getModel() {
        return this.myModel;
    }

    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        this.myTable.setRowSorter(sorter);
        JTable ref2 = this.myTreeTableHeader.getTable();
        ref2.setModel(this.myTable.getModel());
        ref2.setRowSorter(sorter);
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row2) {
        if (path == null) {
            JBTreeTable.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        return this.myTree.hasFocus() || this.myTable.hasFocus();
    }

    /*
     * WARNING - void declaration
     */
    private boolean addTreeTableRowDirtyRegion(@NotNull JComponent component2, long tm, int x, int y, int width, int n) {
        boolean isNeedToRepaintRow;
        if (component2 == null) {
            JBTreeTable.$$$reportNull$$$0(11);
        }
        boolean bl = isNeedToRepaintRow = component2.getWidth() == width;
        if (isNeedToRepaintRow) {
            void height;
            this.repaint(tm, 0, y, this.getWidth(), (int)height);
        }
        return isNeedToRepaintRow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBTreeTable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBTreeTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRenderer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackground";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTreeTableRowDirtyRegion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }

    private final class MyTree
    extends Tree
    implements PlainSelectionTree {
        private MyTree() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
            if (!JBTreeTable.this.addTreeTableRowDirtyRegion((JComponent)((Object)this), tm, x, y, width, height)) {
                super.repaint(tm, x, y, width, height);
            }
        }

        public void treeDidChange() {
            super.treeDidChange();
            if (JBTreeTable.this.myTable != null) {
                JBTreeTable.this.myTable.revalidate();
                JBTreeTable.this.myTable.repaint();
            }
        }

        @Nullable
        public Color getPathBackground(@NotNull TreePath path, int row2) {
            if (path == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            return JBTreeTable.this.getPathBackground(path, row2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/components/JBTreeTable$MyTree", "getPathBackground"));
        }
    }

    private final class Table
    extends JBTable {
        final JBTable ref = new JBTable();

        private Table() {
            JBTreeTable.this.myTreeTableHeader = new JBTable.JBTableHeader(){

                public AccessibleContext getAccessibleContext() {
                    return new MyAccessibleContext();
                }

                public int getWidth() {
                    return super.getWidth() + 1;
                }
            };
            this.ref.setTableHeader(JBTreeTable.this.myTreeTableHeader);
            JBTreeTable.this.myTreeTableHeader.setColumnModel(new TreeColumnModel());
            JBTreeTable.this.myTreeTableHeader.setReorderingAllowed(false);
            JBTreeTable.this.myTreeTableHeader.setResizingAllowed(false);
            TableHoverListener.DEFAULT.removeFrom((JComponent)((Object)this));
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (JBTreeTable.this.myTree != null && JBTreeTable.this.myTree.getRowHeight() < rowHeight) {
                JBTreeTable.this.myTree.setRowHeight(this.getRowHeight());
            }
        }

        public void updateUI() {
            super.updateUI();
            if (this.ref != null) {
                this.ref.updateUI();
            }
        }

        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            Insets insets = this.getInsets();
            return new Dimension(size2.width + insets.left + insets.right, size2.height + insets.top + insets.bottom);
        }

        @NotNull
        public Rectangle getCellRect(int row2, int column, boolean includeSpacing) {
            Rectangle rect = super.getCellRect(row2, column, includeSpacing);
            Insets insets = this.getInsets();
            return new Rectangle(rect.x + insets.left, rect.y + insets.top, rect.width, rect.height);
        }

        public int columnAtPoint(@NotNull Point point) {
            if (point == null) {
                Table.$$$reportNull$$$0(0);
            }
            Insets insets = this.getInsets();
            return super.columnAtPoint(new Point(point.x - insets.left, point.y - insets.top));
        }

        public int rowAtPoint(@NotNull Point point) {
            if (point == null) {
                Table.$$$reportNull$$$0(1);
            }
            Insets insets = this.getInsets();
            return super.rowAtPoint(new Point(point.x - insets.left, point.y - insets.top));
        }

        public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
            int increment;
            if (visibleRect == null) {
                Table.$$$reportNull$$$0(2);
            }
            if ((increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction)) == 0 && orientation == 1 && direction < 0) {
                return visibleRect.y;
            }
            return increment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleRect";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/JBTreeTable$Table";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "columnAtPoint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rowAtPoint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getScrollableUnitIncrement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MyAccessibleContext
        extends AccessibleContextDelegate {
            MyAccessibleContext() {
                super(JBTreeTable.this.myTable.getAccessibleContext());
            }

            protected Container getDelegateParent() {
                return JBTreeTable.this;
            }
        }
    }

    private final class SelectionSupport
    extends MouseAdapter
    implements TreeSelectionListener,
    ListSelectionListener {
        private SelectionSupport() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getSource() == JBTreeTable.this.myTable) {
                int row2 = JBTreeTable.this.myTable.getSelectedRow();
                if (JBTreeTable.this.myTree.isCollapsed(row2)) {
                    JBTreeTable.this.myTree.expandRow(row2);
                } else {
                    JBTreeTable.this.myTree.collapseRow(row2);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row2;
            if (e.getSource() == JBTreeTable.this.myTable.getSelectionModel() && (row2 = JBTreeTable.this.myTable.getSelectedRow()) >= 0) {
                JBTreeTable.this.myTree.setSelectionRow(row2);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() == JBTreeTable.this.myTree.getSelectionModel()) {
                int row2 = JBTreeTable.this.myTree.getRowForPath(JBTreeTable.this.myTree.getSelectionPath());
                if (row2 >= 0) {
                    JBTreeTable.this.myTable.setRowSelectionInterval(row2, row2);
                } else {
                    JBTreeTable.this.myTable.clearSelection();
                }
            }
        }
    }

    private final class TreeColumnModel
    extends DefaultTableColumnModel {
        private int treeColumnIndex = -1;

        private TreeColumnModel() {
            this.addColumn(new TableColumn(0){

                @Override
                public int getWidth() {
                    return TreeColumnModel.this.getTotalColumnWidth();
                }

                @Override
                public Object getHeaderValue() {
                    return TreeColumnModel.this.treeColumnIndex < 0 ? " " : JBTreeTable.this.myModel.getColumnName(TreeColumnModel.this.treeColumnIndex);
                }
            });
            this.addColumn(new TableColumn(1, 0));
            JBTreeTable.this.myTree.addPropertyChangeListener("model", evt -> {
                TreeTableModel model2 = JBTreeTable.this.myModel;
                this.treeColumnIndex = -1;
                for (int i2 = 0; i2 < model2.getColumnCount(); ++i2) {
                    if (!TreeTableModel.class.isAssignableFrom(model2.getColumnClass(i2))) continue;
                    if (i2 != 0) {
                        throw new IllegalArgumentException("Tree column must be first");
                    }
                    this.treeColumnIndex = i2;
                    break;
                }
            });
        }

        @Override
        public int getTotalColumnWidth() {
            return JBTreeTable.this.myTree.getVisibleRect().width + 1;
        }
    }
}

