/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.ui.popup.list.InlineActionsUtilKt;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupInlineActionsSupport;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J!\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J$\u0010\u0013\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u001a\u0010\u001e\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ui/popup/list/NonActionsPopupInlineSupport;", "Lcom/intellij/ui/popup/list/PopupInlineActionsSupport;", "myListPopup", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "<init>", "(Lcom/intellij/ui/popup/list/ListPopupImpl;)V", "calcExtraButtonsCount", "", "element", "", "calcButtonIndex", "point", "Ljava/awt/Point;", "(Ljava/lang/Object;Ljava/awt/Point;)Ljava/lang/Integer;", "getToolTipText", "", "index", "getKeepPopupOnPerform", "Lcom/intellij/openapi/actionSystem/KeepPopupOnPerform;", "performAction", "", "event", "Ljava/awt/event/InputEvent;", "createExtraButtons", "", "Ljavax/swing/JComponent;", "value", "isSelected", "", "activeButtonIndex", "isMoreButton", "hasMoreButton", "intellij.platform.ide.impl"})
public final class NonActionsPopupInlineSupport
implements PopupInlineActionsSupport {
    @NotNull
    private final ListPopupImpl myListPopup;

    public NonActionsPopupInlineSupport(@NotNull ListPopupImpl myListPopup) {
        Intrinsics.checkNotNullParameter((Object)myListPopup, (String)"myListPopup");
        this.myListPopup = myListPopup;
    }

    @Override
    public int calcExtraButtonsCount(@Nullable Object element) {
        return this.hasMoreButton(element) ? 1 : 0;
    }

    @Override
    @Nullable
    public Integer calcButtonIndex(@Nullable Object element, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (element == null || !this.hasMoreButton(element)) {
            return null;
        }
        JList jList = this.myListPopup.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList, (String)"getList(...)");
        return InlineActionsUtilKt.calcButtonIndex(jList, 1, point);
    }

    @Override
    @Nullable
    public String getToolTipText(@Nullable Object element, int index) {
        return this.isMoreButton(element, index) ? IdeBundle.message((String)"inline.actions.more.actions.text", (Object[])new Object[0]) : null;
    }

    @Override
    @NotNull
    public KeepPopupOnPerform getKeepPopupOnPerform(@Nullable Object element, int index) {
        return KeepPopupOnPerform.Always;
    }

    @Override
    public void performAction(@Nullable Object element, int index, @Nullable InputEvent event) {
        if (this.isMoreButton(element, index)) {
            this.myListPopup.showNextStepPopup(this.myListPopup.getListStep().onChosen(element, false), element);
        }
    }

    @Override
    @NotNull
    public List<JComponent> createExtraButtons(@Nullable Object value, boolean isSelected, int activeButtonIndex) {
        List list2;
        if (this.hasMoreButton(value) && isSelected) {
            Icon icon2 = AllIcons.Actions.More;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"More");
            list2 = CollectionsKt.listOf((Object)InlineActionsUtilKt.createExtraButton(icon2, activeButtonIndex == 0));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    public boolean isMoreButton(@Nullable Object element, int index) {
        return this.hasMoreButton(element) && index == 0;
    }

    private final boolean hasMoreButton(Object element) {
        return this.myListPopup.getListStep().hasSubstep(element) && !this.myListPopup.isShowSubmenuOnHover() && this.myListPopup.getListStep().isFinal(element);
    }
}

