/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.CustomLanguageASTComparator;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ASTShallowComparator
implements ShallowNodeComparator<ASTNode, ASTNode> {
    private final ProgressIndicator myIndicator;
    private final List<CustomLanguageASTComparator> myCustomLanguageASTComparators;

    public ASTShallowComparator(@NotNull ProgressIndicator indicator, @NotNull List<CustomLanguageASTComparator> customLanguageASTComparators) {
        if (indicator == null) {
            ASTShallowComparator.$$$reportNull$$$0(0);
        }
        if (customLanguageASTComparators == null) {
            ASTShallowComparator.$$$reportNull$$$0(1);
        }
        this.myIndicator = indicator;
        this.myCustomLanguageASTComparators = customLanguageASTComparators;
    }

    @NotNull
    public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            ASTShallowComparator.$$$reportNull$$$0(2);
        }
        if (newNode == null) {
            ASTShallowComparator.$$$reportNull$$$0(3);
        }
        ThreeState threeState = this.textMatches(oldNode, newNode);
        if (threeState == null) {
            ASTShallowComparator.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    private ThreeState textMatches(ASTNode oldNode, ASTNode newNode) {
        String newText;
        this.myIndicator.checkCanceled();
        boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
        boolean newIsErrorElement = newNode instanceof PsiErrorElement;
        if (oldIsErrorElement != newIsErrorElement) {
            return ThreeState.NO;
        }
        if (oldIsErrorElement) {
            if (!Objects.equals(((PsiErrorElement)oldNode).getErrorDescription(), ((PsiErrorElement)newNode).getErrorDescription())) {
                return ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ThreeState customCompare = this.customCompare(oldNode, newNode);
        if (customCompare != ThreeState.UNSURE) {
            return customCompare;
        }
        String oldText = TreeUtil.isCollapsedChameleon(oldNode) ? oldNode.getText() : null;
        String string = newText = TreeUtil.isCollapsedChameleon(newNode) ? newNode.getText() : null;
        if (oldText != null && newText != null) {
            return oldText.equals(newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldText != null) {
            return this.compareTreeToText((TreeElement)newNode, oldText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (newText != null) {
            return this.compareTreeToText((TreeElement)oldNode, newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldNode instanceof ForeignLeafPsiElement) {
            return newNode instanceof ForeignLeafPsiElement && oldNode.getText().equals(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof ForeignLeafPsiElement) {
            return ThreeState.NO;
        }
        if (oldNode instanceof LeafElement) {
            return ((LeafElement)oldNode).textMatches(newNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof LeafElement) {
            return ((LeafElement)newNode).textMatches(oldNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    private boolean compareTreeToText(@NotNull TreeElement root, final @NotNull String text) {
        if (root == null) {
            ASTShallowComparator.$$$reportNull$$$0(5);
        }
        if (text == null) {
            ASTShallowComparator.$$$reportNull$$$0(6);
        }
        final int[] curOffset = new int[]{0};
        root.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(text, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                ASTShallowComparator.this.myIndicator.checkCanceled();
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0] == text.length();
    }

    public boolean typesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            ASTShallowComparator.$$$reportNull$$$0(7);
        }
        if (n2 == null) {
            ASTShallowComparator.$$$reportNull$$$0(8);
        }
        return Comparing.equal((Object)n1.getElementType(), (Object)n2.getElementType());
    }

    public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            ASTShallowComparator.$$$reportNull$$$0(9);
        }
        if (n2 == null) {
            ASTShallowComparator.$$$reportNull$$$0(10);
        }
        if (n1 instanceof LeafElement && n2 instanceof LeafElement) {
            return this.textMatches(n1, n2) == ThreeState.YES;
        }
        if (n1 instanceof PsiErrorElement && n2 instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)n1;
            PsiErrorElement e2 = (PsiErrorElement)n2;
            if (!Objects.equals(e1.getErrorDescription(), e2.getErrorDescription())) {
                return false;
            }
        }
        return ((TreeElement)n1).hc() == ((TreeElement)n2).hc();
    }

    private ThreeState customCompare(ASTNode oldNode, ASTNode newNode) {
        for (CustomLanguageASTComparator comparator : this.myCustomLanguageASTComparators) {
            ThreeState customComparatorResult = comparator.compareAST(oldNode, newNode);
            if (customComparatorResult == ThreeState.UNSURE) continue;
            return customComparatorResult;
        }
        return ThreeState.UNSURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLanguageASTComparators";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/ASTShallowComparator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/ASTShallowComparator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deepEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deepEqual";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTreeToText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "typesEqual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hashCodesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

