/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.configurable;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.settings.SettingComponent;
import ai.grazie.rules.settings.TextStyle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.ui.configurable.FeaturedSettings;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurableKt;
import com.intellij.grazie.ide.ui.configurable.TreeSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/ide/ui/configurable/CombinedSettings;", "", "featuredSettings", "Lcom/intellij/grazie/ide/ui/configurable/FeaturedSettings;", "treeSettings", "Lcom/intellij/grazie/ide/ui/configurable/TreeSettings;", "<init>", "(Lcom/intellij/grazie/ide/ui/configurable/FeaturedSettings;Lcom/intellij/grazie/ide/ui/configurable/TreeSettings;)V", "getFeaturedSettings", "()Lcom/intellij/grazie/ide/ui/configurable/FeaturedSettings;", "getTreeSettings", "()Lcom/intellij/grazie/ide/ui/configurable/TreeSettings;", "isModified", "", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "reset", "", "textStyle", "Lai/grazie/rules/settings/TextStyle;", "language", "Lai/grazie/nlp/langs/Language;", "updateFilter", "option", "", "areModifiedFeaturedSettings", "areModifiedTreeSettings", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grazie.core"})
public final class CombinedSettings {
    @Nullable
    private final FeaturedSettings featuredSettings;
    @NotNull
    private final TreeSettings treeSettings;

    public CombinedSettings(@Nullable FeaturedSettings featuredSettings, @NotNull TreeSettings treeSettings) {
        Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
        this.featuredSettings = featuredSettings;
        this.treeSettings = treeSettings;
    }

    @Nullable
    public final FeaturedSettings getFeaturedSettings() {
        return this.featuredSettings;
    }

    @NotNull
    public final TreeSettings getTreeSettings() {
        return this.treeSettings;
    }

    public final boolean isModified(@NotNull GrazieConfig.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.areModifiedFeaturedSettings(this.featuredSettings) || this.areModifiedTreeSettings(this.treeSettings, state);
    }

    public final void reset(@NotNull GrazieConfig.State state, @NotNull TextStyle textStyle, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (this.areModifiedFeaturedSettings(this.featuredSettings)) {
            FeaturedSettings featuredSettings = this.featuredSettings;
            Intrinsics.checkNotNull((Object)featuredSettings);
            featuredSettings.getComponent().loadState(StyleConfigurableKt.access$getSettingsState(language, textStyle), textStyle);
            SettingComponent.SettingState settingState = this.featuredSettings.getComponent().getState();
            Intrinsics.checkNotNullExpressionValue((Object)settingState, (String)"getState(...)");
            this.featuredSettings.setResetState(settingState);
        }
        if (this.areModifiedTreeSettings(this.treeSettings, state)) {
            this.treeSettings.getTree().reset(state);
        }
    }

    public final void updateFilter(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        FeaturedSettings featuredSettings = this.featuredSettings;
        if (featuredSettings != null && (featuredSettings = featuredSettings.getComponent()) != null) {
            featuredSettings.filter(option);
        }
        this.treeSettings.getTree().filter(option);
    }

    private final boolean areModifiedFeaturedSettings(FeaturedSettings featuredSettings) {
        return featuredSettings != null && !Intrinsics.areEqual((Object)featuredSettings.getComponent().getState(), (Object)featuredSettings.getResetState());
    }

    private final boolean areModifiedTreeSettings(TreeSettings treeSettings, GrazieConfig.State state) {
        return treeSettings.getTree().isModified(state);
    }

    @Nullable
    public final FeaturedSettings component1() {
        return this.featuredSettings;
    }

    @NotNull
    public final TreeSettings component2() {
        return this.treeSettings;
    }

    @NotNull
    public final CombinedSettings copy(@Nullable FeaturedSettings featuredSettings, @NotNull TreeSettings treeSettings) {
        Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
        return new CombinedSettings(featuredSettings, treeSettings);
    }

    public static /* synthetic */ CombinedSettings copy$default(CombinedSettings combinedSettings, FeaturedSettings featuredSettings, TreeSettings treeSettings, int n, Object object) {
        if ((n & 1) != 0) {
            featuredSettings = combinedSettings.featuredSettings;
        }
        if ((n & 2) != 0) {
            treeSettings = combinedSettings.treeSettings;
        }
        return combinedSettings.copy(featuredSettings, treeSettings);
    }

    @NotNull
    public String toString() {
        return "CombinedSettings(featuredSettings=" + this.featuredSettings + ", treeSettings=" + this.treeSettings + ")";
    }

    public int hashCode() {
        int result = this.featuredSettings == null ? 0 : this.featuredSettings.hashCode();
        result = result * 31 + this.treeSettings.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CombinedSettings)) {
            return false;
        }
        CombinedSettings combinedSettings = (CombinedSettings)other;
        if (!Intrinsics.areEqual((Object)this.featuredSettings, (Object)combinedSettings.featuredSettings)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.treeSettings, (Object)combinedSettings.treeSettings);
    }
}

