/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.spellcheck.SpellCheckingResult;
import com.intellij.grazie.spellcheck.SpellingCheckerRunner;
import com.intellij.grazie.spellcheck.TypoProblem;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieTextLevelSpellCheckingExtension;", "", "<init>", "()V", "spellcheck", "Lcom/intellij/grazie/spellcheck/SpellCheckingResult;", "element", "Lcom/intellij/psi/PsiElement;", "strategy", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "consumer", "Ljava/util/function/Consumer;", "Lcom/intellij/grazie/spellcheck/TypoProblem;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieTextLevelSpellCheckingExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieTextLevelSpellCheckingExtension.kt\ncom/intellij/grazie/spellcheck/GrazieTextLevelSpellCheckingExtension\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,48:1\n1342#2,2:49\n*S KotlinDebug\n*F\n+ 1 GrazieTextLevelSpellCheckingExtension.kt\ncom/intellij/grazie/spellcheck/GrazieTextLevelSpellCheckingExtension\n*L\n43#1:49,2\n*E\n"})
public final class GrazieTextLevelSpellCheckingExtension {
    @NotNull
    public static final GrazieTextLevelSpellCheckingExtension INSTANCE = new GrazieTextLevelSpellCheckingExtension();

    private GrazieTextLevelSpellCheckingExtension() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpellCheckingResult spellcheck(@NotNull PsiElement element, @NotNull SpellcheckingStrategy strategy, @NotNull LocalInspectionToolSession session, @NotNull Consumer<TypoProblem> consumer) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!strategy.useTextLevelSpellchecking(element)) {
            return SpellCheckingResult.Ignored;
        }
        ProgressManager.checkCanceled();
        List<TextContent> list = TextExtractor.findUniqueTextsAt(element, TextContent.TextDomain.ALL);
        Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
        TextRange textRange = session.getPriorityRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
        List<TextContent> texts = GrazieInspection.Companion.sortByPriority(list, textRange);
        if (texts.isEmpty()) {
            return SpellCheckingResult.Ignored;
        }
        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)texts), GrazieTextLevelSpellCheckingExtension::spellcheck$lambda$0), GrazieTextLevelSpellCheckingExtension::spellcheck$lambda$1), GrazieTextLevelSpellCheckingExtension::spellcheck$lambda$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypoProblem it = (TypoProblem)element$iv;
            boolean bl = false;
            consumer.accept(it);
        }
        return SpellCheckingResult.Checked;
    }

    private static final boolean spellcheck$lambda$0(TextContent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProblemFilter.allIgnoringFilters(it).findAny().isEmpty();
    }

    private static final Iterable spellcheck$lambda$1(TextContent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SpellingCheckerRunner(it).run();
    }

    private static final boolean spellcheck$lambda$2(TypoProblem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProblemFilter.allIgnoringFilters(it).findAny().isEmpty();
    }
}

