/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.Compressor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.NetUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndexingConnectorImpl;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerManagerImpl;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0006H\u0017J&\u0010 \u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010!J \u0010\"\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010$\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0006H\u0002J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u0013H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020)H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\u0013H\u0017J\b\u0010-\u001a\u00020\u0013H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u000fH\u0016J\b\u00102\u001a\u00020\rH\u0016J\n\u00103\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00104\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerManagerImpl;", "Lorg/jetbrains/idea/maven/server/MavenServerManager;", "<init>", "()V", "myMultimoduleDirToConnectorMap", "", "", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "isShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myIndexingConnector", "Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl;", "myIndexerWrapper", "Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;", "eventListenerJar", "Ljava/nio/file/Path;", "getAllConnectors", "", "shutdownMavenConnectors", "", "project", "Lcom/intellij/openapi/project/Project;", "condition", "Ljava/util/function/Predicate;", "stopConnectors", "connectors", "", "doGetConnector", "workingDirectory", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getConnectorBlocking", "getConnector", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doGetOrCreateConnector", "multimoduleDirectory", "registerNewConnector", "registerDisposable", "connector", "dispose", "shutdownConnector", "", "wait", "removeConnector", "closeAllConnectorsAndWait", "closeAllConnectorsEventually", "shutdownNow", "getMavenEventListener", "Ljava/io/File;", "getMavenEventListenerPath", "createIndexer", "createDedicatedIndexer", "createLegacyIndexer", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenServerManagerImpl.kt\norg/jetbrains/idea/maven/server/MavenServerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n296#2,2:491\n1#3:493\n*S KotlinDebug\n*F\n+ 1 MavenServerManagerImpl.kt\norg/jetbrains/idea/maven/server/MavenServerManagerImpl\n*L\n182#1:491,2\n*E\n"})
public final class MavenServerManagerImpl
implements MavenServerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, MavenServerConnector> myMultimoduleDirToConnectorMap = new HashMap();
    @NotNull
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    @Nullable
    private MavenIndexingConnectorImpl myIndexingConnector;
    @Nullable
    private MavenIndexerWrapper myIndexerWrapper;
    @Nullable
    private Path eventListenerJar;

    public MavenServerManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                isShutdown.set(true);
                this.closeAllConnectorsEventually();
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)"org.jetbrains.idea.maven", (Object)pluginDescriptor.getPluginId().getIdString())) {
                    isShutdown.set(true);
                    this.closeAllConnectorsEventually();
                }
            }
        });
        connection.subscribe(TrustedProjectsListener.TOPIC, (Object)new TrustedProjectsListener(){

            public void onProjectTrusted(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenUtil.shutdownMavenConnectors(project, 3::onProjectTrusted$lambda$0);
                }
            }

            public void onProjectUntrusted(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenUtil.shutdownMavenConnectors(project, 3::onProjectUntrusted$lambda$1);
                }
            }

            public void onProjectTrustedFromNotification(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenLog.LOG.info("onProjectTrustedFromNotification forceUpdateAllProjectsOrFindAllAvailablePomFiles");
                    manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }

            private static final boolean onProjectTrusted$lambda$0(MavenServerConnector it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DummyMavenServerConnector.Companion.isDummy(it);
            }

            private static final boolean onProjectUntrusted$lambda$1(MavenServerConnector it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DummyMavenServerConnector.Companion.isDummy(it);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<MavenServerConnector> getAllConnectors() {
        Set<MavenServerConnector> set = Collections.newSetFromMap(new IdentityHashMap());
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            set.addAll(this.myMultimoduleDirToConnectorMap.values());
            if (this.myIndexingConnector != null) {
                MavenIndexingConnectorImpl mavenIndexingConnectorImpl = this.myIndexingConnector;
                Intrinsics.checkNotNull((Object)mavenIndexingConnectorImpl);
                set.add(mavenIndexingConnectorImpl);
            }
            Unit unit = Unit.INSTANCE;
        }
        Intrinsics.checkNotNull(set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownMavenConnectors(@NotNull Project project, @NotNull Predicate<MavenServerConnector> condition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        List connectorsToShutDown = new ArrayList();
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            this.getAllConnectors().forEach(arg_0 -> MavenServerManagerImpl.shutdownMavenConnectors$lambda$0$0(project, condition, this, connectorsToShutDown, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        MavenProjectsManager.getInstance(project).getEmbeddersManager().reset();
        this.stopConnectors(project, connectorsToShutDown);
    }

    private final void stopConnectors(Project project, List<? extends MavenServerConnector> connectors) {
        connectors.forEach(MavenServerManagerImpl::stopConnectors$lambda$0);
    }

    private final MavenServerConnector doGetConnector(Project project, String workingDirectory, Sdk jdk) {
        String string = MavenDistributionsCache.getInstance(project).getMultimoduleDirectory(workingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMultimoduleDirectory(...)");
        String multimoduleDirectory = string;
        MavenServerConnector connector = this.doGetOrCreateConnector(project, multimoduleDirectory, jdk);
        if (connector.isNew()) {
            connector.connect();
        } else if (!MavenUtil.INSTANCE.isCompatibleWith$intellij_maven(connector, project, jdk, multimoduleDirectory)) {
            MavenLog.LOG.info("[connector] " + connector + " is incompatible, restarting");
            this.shutdownConnector(connector, false);
            connector = this.doGetOrCreateConnector(project, multimoduleDirectory, jdk);
            connector.connect();
        }
        if (MavenLog.LOG.isTraceEnabled()) {
            MavenLog.LOG.trace("[connector] get " + connector);
        }
        return connector;
    }

    @Override
    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="getConnector", imports={}))
    @NotNull
    public MavenServerConnector getConnectorBlocking(@NotNull Project project, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return (MavenServerConnector)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenServerConnector>, Object>(this, project, workingDirectory, null){
            int label;
            final /* synthetic */ MavenServerManagerImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workingDirectory;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$workingDirectory = $workingDirectory;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getConnector(this.$project, this.$workingDirectory, (Continuation<? super MavenServerConnector>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MavenServerConnector> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getConnector(@NotNull Project project, @NotNull String workingDirectory, @NotNull Sdk jdk, @NotNull Continuation<? super MavenServerConnector> $completion) {
        if (!($completion instanceof getConnector.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ MavenServerManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getConnector(null, null, null, (Continuation<? super MavenServerConnector>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                connector = this.doGetConnector(project, workingDirectory, jdk);
                $continuation.L$0 = project;
                $continuation.L$1 = workingDirectory;
                $continuation.L$2 = jdk;
                $continuation.L$3 = connector;
                $continuation.label = 1;
                v0 = connector.ping((Continuation<? super Boolean>)$continuation);
                if (v0 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                connector = (MavenServerConnector)$continuation.L$3;
                jdk = (Sdk)$continuation.L$2;
                workingDirectory = (String)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.shutdownConnector(connector, true);
                    connector = this.doGetConnector(project, workingDirectory, jdk);
                }
                return connector;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenServerConnector doGetOrCreateConnector(Project project, String multimoduleDirectory, Sdk jdk) {
        if (this.isShutdown.get()) {
            throw new IllegalStateException("We are closed, sorry. No connectors anymore");
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            MavenServerConnector mavenServerConnector;
            Object v0;
            block9: {
                block8: {
                    boolean bl = false;
                    MavenServerConnector cachedConnector = this.myMultimoduleDirToConnectorMap.get(multimoduleDirectory);
                    if (cachedConnector == null) break block8;
                    MavenServerConnector mavenServerConnector2 = cachedConnector;
                    return mavenServerConnector2;
                }
                Iterable $this$firstOrNull$iv = this.myMultimoduleDirToConnectorMap.values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MavenServerConnector it = (MavenServerConnector)element$iv;
                    boolean bl = false;
                    if (!MavenUtil.INSTANCE.isCompatibleWith$intellij_maven(it, project, jdk, multimoduleDirectory)) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            MavenServerConnector compatibleConnector = v0;
            if (compatibleConnector != null) {
                MavenLog.LOG.debug("[connector] use existing connector for " + compatibleConnector);
                compatibleConnector.addMultimoduleDir(multimoduleDirectory);
            }
            if ((mavenServerConnector = compatibleConnector) == null) {
                mavenServerConnector = this.registerNewConnector(project, jdk, multimoduleDirectory);
            }
            MavenServerConnector connector = mavenServerConnector;
            this.myMultimoduleDirToConnectorMap.put(multimoduleDirectory, connector);
            MavenServerConnector mavenServerConnector3 = connector;
            return mavenServerConnector3;
        }
    }

    private final MavenServerConnector registerNewConnector(Project project, Sdk jdk, String multimoduleDirectory) {
        MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(project).getMavenDistribution(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
        MavenDistribution distribution = mavenDistribution;
        String string = MavenDistributionsCache.getInstance(project).getVmOptions(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVmOptions(...)");
        String vmOptions = string;
        Integer debugPort = MavenServerManagerImpl.Companion.getFreeDebugPort();
        MavenServerConnector connector = null;
        if (TrustedProjects.isProjectTrusted((Project)project) || project.isDefault()) {
            MavenServerManager.MavenServerConnectorFactory connectorFactory = (MavenServerManager.MavenServerConnectorFactory)ApplicationManager.getApplication().getService(MavenServerManager.MavenServerConnectorFactory.class);
            connector = connectorFactory.create(project, jdk, vmOptions, debugPort, distribution, multimoduleDirectory);
            MavenLog.LOG.debug("[connector] new maven connector " + connector);
        } else {
            MavenLog.LOG.warn("Project " + project + " not trusted enough. Will not start maven for it");
            connector = new DummyMavenServerConnector(project, jdk, vmOptions, distribution, multimoduleDirectory);
        }
        this.registerDisposable(project, connector);
        return connector;
    }

    private final void registerDisposable(Project project, MavenServerConnector connector) {
        Disposer.register((Disposable)MavenDisposable.getInstance(project), () -> MavenServerManagerImpl.registerDisposable$lambda$0(this, connector));
    }

    public void dispose() {
        this.shutdownNow();
    }

    @Override
    public boolean shutdownConnector(@NotNull MavenServerConnector connector, boolean wait) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        MavenServerConnector connectorToStop = this.removeConnector(connector);
        if (connectorToStop == null) {
            return false;
        }
        connectorToStop.stop(wait);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenServerConnector removeConnector(MavenServerConnector connector) {
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.myIndexingConnector != connector) break block5;
                    this.myIndexingConnector = null;
                    this.myIndexerWrapper = null;
                    MavenServerConnector mavenServerConnector = connector;
                    return mavenServerConnector;
                }
                if (this.myMultimoduleDirToConnectorMap.containsValue(connector)) break block6;
                MavenServerConnector mavenServerConnector = null;
                return mavenServerConnector;
            }
            boolean bl = this.myMultimoduleDirToConnectorMap.entrySet().removeIf(arg_0 -> MavenServerManagerImpl.removeConnector$lambda$0$1(arg_0 -> MavenServerManagerImpl.removeConnector$lambda$0$0(connector, arg_0), arg_0));
        }
        return connector;
    }

    @Override
    @TestOnly
    public void closeAllConnectorsAndWait() {
        this.shutdownNow();
    }

    private final void closeAllConnectorsEventually() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> MavenServerManagerImpl.closeAllConnectorsEventually$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdownNow() {
        ArrayList<MavenServerConnector> values = null;
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            values = new ArrayList<MavenServerConnector>(this.myMultimoduleDirToConnectorMap.values());
            Unit unit = Unit.INSTANCE;
        }
        MavenIndexingConnectorImpl indexingConnector = this.myIndexingConnector;
        if (indexingConnector != null) {
            this.shutdownConnector(indexingConnector, true);
        }
        ((Collection)values).forEach(arg_0 -> MavenServerManagerImpl.shutdownNow$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public File getMavenEventListener() {
        File file2 = this.getMavenEventListenerPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Path getMavenEventListenerPath() {
        Path path;
        Path alreadyCalculatedEventListenerJar = this.eventListenerJar;
        if (alreadyCalculatedEventListenerJar != null) {
            return alreadyCalculatedEventListenerJar;
        }
        if (MavenUtil.isRunningFromSources()) {
            Path sourceBuildOutput = MavenUtil.locateModuleOutput("intellij.maven.server.eventListener");
            if (sourceBuildOutput == null) {
                throw new IllegalStateException("Cannot locate module output for intellij.maven.server.eventListener".toString());
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(sourceBuildOutput, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n          Event listener does not exist at " + alreadyCalculatedEventListenerJar + "\n          \n          Please run rebuild for maven modules:\n          community/plugins/maven/maven-event-listener\n          ")).toString());
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(sourceBuildOutput, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Path tempFile = Files.createTempFile("idea", "-event-listener.jar", new FileAttribute[0]);
                tempFile.toFile().deleteOnExit();
                MavenLog.LOG.warn("compressing maven event listener from " + sourceBuildOutput);
                Closeable closeable = (Closeable)new Compressor.Zip(tempFile);
                Throwable throwable = null;
                try {
                    Compressor.Zip zip = (Compressor.Zip)closeable;
                    boolean bl = false;
                    zip.addDirectory(sourceBuildOutput);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.eventListenerJar = tempFile;
                Intrinsics.checkNotNull((Object)tempFile);
                return tempFile;
            }
            this.eventListenerJar = sourceBuildOutput;
            return sourceBuildOutput;
        }
        Path pluginDir = PluginManagerCoreKt.getPluginDistDirByClass(MavenServerManager.class);
        if (pluginDir == null) {
            MavenLog.LOG.warn("Cannot find path of maven plugin");
            path = Path.of("path-of-maven-plugin-was-not-found", new String[0]);
        } else {
            path = pluginDir.resolve("lib").resolve("intellij.maven.rt").resolve("maven-event-listener.jar");
        }
        Path jarFromDistribution = path;
        Intrinsics.checkNotNull((Object)jarFromDistribution);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(jarFromDistribution, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            MavenLog.LOG.warn("Event listener does not exist at " + jarFromDistribution + ". It should be built as part of plugin layout process and bundled along with maven plugin jars");
        }
        this.eventListenerJar = jarFromDistribution;
        return jarFromDistribution;
    }

    @Override
    @NotNull
    public MavenIndexerWrapper createIndexer() {
        MavenIndexerWrapper mavenIndexerWrapper = this.createDedicatedIndexer();
        Intrinsics.checkNotNull((Object)mavenIndexerWrapper);
        return mavenIndexerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenIndexerWrapper createDedicatedIndexer() {
        if (this.myIndexerWrapper != null) {
            return this.myIndexerWrapper;
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            block5: {
                boolean bl = false;
                if (this.myIndexerWrapper == null) break block5;
                MavenIndexerWrapper mavenIndexerWrapper = this.myIndexerWrapper;
                return mavenIndexerWrapper;
            }
            String workingDir = SystemUtils.getUserHome().getAbsolutePath();
            this.myIndexerWrapper = new MavenIndexerWrapper(this, workingDir){
                final /* synthetic */ MavenServerManagerImpl this$0;
                final /* synthetic */ String $workingDir;
                {
                    this.this$0 = $receiver;
                    this.$workingDir = $workingDir;
                }

                protected MavenIndices createMavenIndices(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().toFile(), project);
                    Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)indices);
                    return indices;
                }

                protected MavenServerIndexer createBlocking() throws RemoteException {
                    MavenServerConnector indexingConnector;
                    MavenServerConnector mavenServerConnector = indexingConnector = this.getIndexingConnector();
                    Intrinsics.checkNotNull((Object)mavenServerConnector);
                    return mavenServerConnector.createIndexer();
                }

                protected Object create(Continuation<? super MavenServerIndexer> $completion) throws RemoteException {
                    MavenServerConnector indexingConnector;
                    MavenServerConnector mavenServerConnector = indexingConnector = this.getIndexingConnector();
                    Intrinsics.checkNotNull((Object)mavenServerConnector);
                    return mavenServerConnector.createIndexer();
                }

                protected synchronized void handleRemoteError(RemoteException e) {
                    MavenIndexingConnectorImpl indexingConnector;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.handleRemoteError(e);
                    if (this.waitIfNotIdeaShutdown() && (indexingConnector = MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0)) != null && !indexingConnector.checkConnected()) {
                        this.this$0.shutdownConnector(indexingConnector, true);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final MavenServerConnector getIndexingConnector() {
                    if (MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0) != null) {
                        return MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                    }
                    Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
                    Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
                    Sdk jdk = sdk;
                    Map map = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                    MavenServerManagerImpl mavenServerManagerImpl = this.this$0;
                    String string = this.$workingDir;
                    Map map2 = map;
                    synchronized (map2) {
                        block5: {
                            boolean bl = false;
                            if (MavenServerManagerImpl.access$getMyIndexingConnector$p(mavenServerManagerImpl) == null) break block5;
                            MavenServerConnector mavenServerConnector = MavenServerManagerImpl.access$getMyIndexingConnector$p(mavenServerManagerImpl);
                            return mavenServerConnector;
                        }
                        Integer n = org.jetbrains.idea.maven.server.MavenServerManagerImpl$Companion.access$getFreeDebugPort(MavenServerManagerImpl.Companion);
                        LocalMavenDistribution localMavenDistribution = MavenDistributionsCache.resolveEmbeddedMavenHome();
                        Intrinsics.checkNotNullExpressionValue((Object)localMavenDistribution, (String)"resolveEmbeddedMavenHome(...)");
                        MavenDistribution mavenDistribution = localMavenDistribution;
                        Intrinsics.checkNotNull((Object)string);
                        MavenServerManagerImpl.access$setMyIndexingConnector$p(mavenServerManagerImpl, new MavenIndexingConnectorImpl(jdk, "", n, mavenDistribution, string));
                        Unit unit = Unit.INSTANCE;
                    }
                    MavenIndexingConnectorImpl mavenIndexingConnectorImpl = MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                    Intrinsics.checkNotNull((Object)mavenIndexingConnectorImpl);
                    mavenIndexingConnectorImpl.connect();
                    return MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                }

                private final boolean waitIfNotIdeaShutdown() {
                    try {
                        Thread.sleep(100L);
                        return true;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            };
            Unit unit = Unit.INSTANCE;
        }
        return this.myIndexerWrapper;
    }

    private final MavenIndexerWrapper createLegacyIndexer(Project project) {
        String path = project.getBasePath();
        if (path == null) {
            path = new File(".").getPath();
        }
        String finalPath = path;
        return new MavenIndexerWrapper(this, project, finalPath){
            final /* synthetic */ MavenServerManagerImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $finalPath;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$finalPath = $finalPath;
            }

            protected MavenIndices createMavenIndices(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().toFile(), project);
                Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)indices);
                return indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected MavenServerIndexer createBlocking() throws RemoteException {
                String workingDirectory;
                Ref.ObjectRef connector = new Ref.ObjectRef();
                Map map = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                MavenServerManagerImpl mavenServerManagerImpl = this.this$0;
                String string = this.$finalPath;
                Map map2 = map;
                synchronized (map2) {
                    Object v4;
                    block7: {
                        boolean bl = false;
                        Iterable iterable = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(mavenServerManagerImpl).values();
                        Ref.ObjectRef objectRef = connector;
                        Iterable iterable2 = iterable;
                        for (T t : iterable2) {
                            Object v2;
                            block6: {
                                MavenServerConnector c = (MavenServerConnector)t;
                                boolean bl2 = false;
                                Iterable iterable3 = c.getMultimoduleDirectories();
                                for (T t2 : iterable3) {
                                    String mDir = (String)t2;
                                    boolean bl3 = false;
                                    String string2 = string;
                                    Intrinsics.checkNotNull((Object)string2);
                                    String string3 = mDir;
                                    Intrinsics.checkNotNull((Object)string3);
                                    if (!FileUtil.isAncestor((String)string2, (String)string3, (boolean)false)) continue;
                                    v2 = t2;
                                    break block6;
                                }
                                v2 = null;
                            }
                            boolean bl4 = v2 != null;
                            if (!bl4) continue;
                            v4 = t;
                            break block7;
                        }
                        v4 = null;
                    }
                    objectRef.element = v4;
                    Unit unit = Unit.INSTANCE;
                }
                if (connector.element != null) {
                    Object object = connector.element;
                    Intrinsics.checkNotNull((Object)object);
                    return ((MavenServerConnector)object).createIndexer();
                }
                String string4 = workingDirectory = (String)ObjectUtils.chooseNotNull((Object)this.$project.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath());
                Intrinsics.checkNotNull((Object)string4);
                return this.this$0.getConnectorBlocking(this.$project, string4).createIndexer();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected Object create(Continuation<? super MavenServerIndexer> $completion) throws RemoteException {
                if (!($completion instanceof createLegacyIndexer.create.1)) ** GOTO lbl-1000
                var21_2 = $completion;
                if ((var21_2.label & -2147483648) != 0) {
                    var21_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ createLegacyIndexer.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.create((Continuation<? super MavenServerIndexer>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var22_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        connector = new Ref.ObjectRef();
                        var3_7 = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                        var4_9 = this.this$0;
                        var5_10 = this.$finalPath;
                        var6_11 = var3_7;
                        synchronized (var6_11) {
                            $i$a$-synchronized-MavenServerManagerImpl$createLegacyIndexer$1$create$2 = false;
                            var8_14 = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(var4_9).values();
                            var9_16 = connector;
                            var10_17 = var8_14;
                            for (T var12_19 : var10_17) {
                                c = (MavenServerConnector)var12_19;
                                $i$a$-find-MavenServerManagerImpl$createLegacyIndexer$1$create$2$1 = false;
                                var15_22 = c.getMultimoduleDirectories();
                                for (T var17_24 : var15_22) {
                                    mDir = (String)var17_24;
                                    $i$a$-find-MavenServerManagerImpl$createLegacyIndexer$1$create$2$1$1 = false;
                                    v0 = var5_10;
                                    Intrinsics.checkNotNull((Object)v0);
                                    v1 = mDir;
                                    Intrinsics.checkNotNull((Object)v1);
                                    if (!FileUtil.isAncestor((String)v0, (String)v1, (boolean)false)) continue;
                                    v2 = var17_24;
                                    ** GOTO lbl39
                                }
                                v2 = null;
lbl39:
                                // 2 sources

                                v3 = v2 != null;
                                if (!v3) continue;
                                v4 = var12_19;
                                ** GOTO lbl44
                            }
                            v4 = null;
lbl44:
                            // 2 sources

                            var9_16.element = v4;
                            var7_13 = Unit.INSTANCE;
                        }
                        if (connector.element != null) {
                            v5 = connector.element;
                            Intrinsics.checkNotNull((Object)v5);
                            return ((MavenServerConnector)v5).createIndexer();
                        }
                        v6 = workingDirectory = (String)ObjectUtils.chooseNotNull((Object)this.$project.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath());
                        Intrinsics.checkNotNull((Object)v6);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connector);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)workingDirectory);
                        $continuation.label = 1;
                        v7 = this.this$0.getConnector(this.$project, v6, (Continuation<? super MavenServerConnector>)$continuation);
                        if (v7 == var22_4) {
                            return var22_4;
                        }
                        ** GOTO lbl68
                    }
                    case 1: {
                        workingDirectory = (String)$continuation.L$1;
                        connector = (Ref.ObjectRef)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl68:
                        // 2 sources

                        return ((MavenServerConnector)v7).createIndexer();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    private static final void shutdownMavenConnectors$lambda$0$0(Project $project, Predicate $condition, MavenServerManagerImpl this$0, List $connectorsToShutDown, MavenServerConnector it) {
        MavenServerConnector removedConnector;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)$project, (Object)it.getProject()) && $condition.test(it) && (removedConnector = this$0.removeConnector(it)) != null) {
            $connectorsToShutDown.add(removedConnector);
        }
    }

    private static final void stopConnectors$lambda$0(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.stop(false);
    }

    private static final Boolean registerDisposable$lambda$0$0(MavenServerManagerImpl this$0, MavenServerConnector $connector) {
        return this$0.shutdownConnector($connector, false);
    }

    private static final void registerDisposable$lambda$0(MavenServerManagerImpl this$0, MavenServerConnector $connector) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> MavenServerManagerImpl.registerDisposable$lambda$0$0(this$0, $connector));
    }

    private static final boolean removeConnector$lambda$0$0(MavenServerConnector $connector, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getValue() == $connector;
    }

    private static final boolean removeConnector$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void closeAllConnectorsEventually$lambda$0(MavenServerManagerImpl this$0) {
        this$0.shutdownNow();
    }

    private static final void shutdownNow$lambda$1(MavenServerManagerImpl this$0, MavenServerConnector c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this$0.shutdownConnector(c, true);
    }

    public static final /* synthetic */ MavenIndexingConnectorImpl access$getMyIndexingConnector$p(MavenServerManagerImpl $this) {
        return $this.myIndexingConnector;
    }

    public static final /* synthetic */ Map access$getMyMultimoduleDirToConnectorMap$p(MavenServerManagerImpl $this) {
        return $this.myMultimoduleDirToConnectorMap;
    }

    public static final /* synthetic */ void access$setMyIndexingConnector$p(MavenServerManagerImpl $this, MavenIndexingConnectorImpl mavenIndexingConnectorImpl) {
        $this.myIndexingConnector = mavenIndexingConnectorImpl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerManagerImpl$Companion;", "", "<init>", "()V", "freeDebugPort", "", "getFreeDebugPort", "()Ljava/lang/Integer;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final Integer getFreeDebugPort() {
            String strVal = Registry.Companion.get("maven.server.debug").asString();
            Integer explicitPort = StringsKt.toIntOrNull((String)strVal);
            if (explicitPort != null) {
                return explicitPort;
            }
            if (Boolean.parseBoolean(strVal)) {
                try {
                    return NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    MavenLog.LOG.warn((Throwable)e);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

