/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.CommonBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    @Deprecated
    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(2);
        }
        this(project, indicator);
    }

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProgressIndicator = indicator;
    }

    @Override
    public void notifyError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(5);
        }
        if (message == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(6);
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.branch.operation.error", title, message);
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(@NotNull String title, @NotNull String message, @NotNull String rollbackProposal) {
        if (title == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(8);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(9);
        }
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            StringBuilder description = new StringBuilder();
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                description.append(message).append("<br/>");
            }
            description.append(rollbackProposal);
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<? extends GitRepository> repositories) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(10);
        }
        if (repositories == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(11);
        }
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.importantNotification().createNotification(title, description, NotificationType.ERROR).setDisplayId("git.unresolved.conflicts").addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("branch.ui.handler.unmerged.files.error.resolve.conflicts.action.text", new Object[0]), () -> new Task.Backgroundable(this, this.myProject, GitBundle.message("apply.changes.resolving.conflicts.progress.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDescription(GitBundle.message("branch.ui.handler.merge.notification.description", operationName)).setErrorNotificationTitle(GitBundle.message("branch.ui.handler.merge.error.notification.title", new Object[0]));
                new GitConflictResolver(this.myProject, GitUtil.getRootsFromRepositories(repositories), params).merge();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchUiHandlerImpl$1", "run"));
            }
        }.queue())).notify(this.myProject);
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(@NotNull String operationName, @NotNull String rollbackProposal) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(12);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(13);
        }
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String description = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("branch.ui.handler.you.have.to.resolve.all.conflicts.before.operation.name", operationName, rollbackProposal));
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(15);
        }
        if (relativePaths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(16);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(17);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(19);
        }
        if (relativePaths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(20);
        }
        return GitUntrackedFilesHelper.showUntrackedFilesDialogWithRollback(this.myProject, operationName, rollbackProposal, root, relativePaths);
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(21);
        }
        return progressIndicator;
    }

    @Override
    public GitSmartOperationDialog.Choice showSmartOperationDialog(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Collection<String> paths, @NotNull String operation, @Nullable String forceButtonTitle) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(22);
        }
        if (changes == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(23);
        }
        if (paths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(24);
        }
        if (operation == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(25);
        }
        Ref exitCode = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> exitCode.set((Object)GitSmartOperationDialog.show(project, changes, paths, StringUtil.capitalize((String)operation), forceButtonTitle)));
        return (GitSmartOperationDialog.Choice)((Object)exitCode.get());
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> history, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(26);
        }
        if (history == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(27);
        }
        if (baseBranches == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(28);
        }
        if (removedBranch == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(29);
        }
        AtomicBoolean restore = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> restore.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(this.myProject, history, baseBranches, removedBranch)));
        return restore.get();
    }

    @Override
    @NotNull
    public GitBranchUiHandler.DeleteRemoteBranchDecision confirmRemoteBranchDeletion(@NotNull List<String> branchNames, @NotNull Collection<@NlsSafe String> trackingBranches, @NotNull Collection<GitRepository> repositories) {
        String deleteButtonText;
        if (branchNames == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(30);
        }
        if (trackingBranches == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(31);
        }
        if (repositories == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(32);
        }
        boolean deleteMultipleBranches = branchNames.size() > 1;
        String title = GitBundle.message("branch.ui.handler.delete.remote.branches", branchNames.size());
        String remoteBranches2 = deleteMultipleBranches ? StringUtil.join(branchNames, (String)", ") : branchNames.iterator().next();
        String message = GitBundle.message("branch.ui.handler.delete.remote.branches.question", branchNames.size(), remoteBranches2);
        String string = deleteButtonText = deleteMultipleBranches ? GitBundle.message("branch.ui.handler.delete.all", new Object[0]) : CommonBundle.message((String)"button.delete", (Object[])new Object[0]);
        if (trackingBranches.isEmpty()) {
            GitBranchUiHandler.DeleteRemoteBranchDecision deleteRemoteBranchDecision = 0 == DialogManager.showOkCancelDialog(this.myProject, message, title, deleteButtonText, CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
            if (deleteRemoteBranchDecision == null) {
                GitBranchUiHandlerImpl.$$$reportNull$$$0(33);
            }
            return deleteRemoteBranchDecision;
        }
        String forBranch = GitBundle.message("branch.ui.handler.delete.tracking.local.branch.as.well", trackingBranches.iterator().next());
        String forBranches = new HtmlBuilder().append(GitBundle.message("branch.ui.handler.delete.tracking.local.branches", new Object[0])).br().appendWithSeparators(HtmlChunk.raw((String)(", " + String.valueOf(HtmlChunk.br()))), (Iterable)ContainerUtil.map(trackingBranches, it -> HtmlChunk.text((String)it))).wrapWith(HtmlChunk.html()).toString();
        final String checkboxMessage = trackingBranches.size() == 1 ? forBranch : forBranches;
        final Ref deleteChoice = Ref.create((Object)false);
        boolean delete2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(deleteButtonText)).noText(CommonBundle.getCancelButtonText())).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){

            public void rememberChoice(boolean isSelected, int exitCode) {
                deleteChoice.set((Object)isSelected);
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = checkboxMessage;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl$2", "getDoNotShowMessage"));
            }
        })).ask(this.myProject);
        boolean deleteTracking = (Boolean)deleteChoice.get();
        GitBranchUiHandler.DeleteRemoteBranchDecision deleteRemoteBranchDecision = delete2 ? (deleteTracking ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING : GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE) : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
        if (deleteRemoteBranchDecision == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(34);
        }
        return deleteRemoteBranchDecision;
    }

    @NlsContexts.DialogTitle
    @NotNull
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(35);
        }
        String string = GitBundle.message("branch.ui.handler.can.not.operation.name.because.of.unmerged.files", operationName);
        if (string == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        String string = GitBundle.message("branch.ui.handler.unmerged.files.error.notification.text", operationName);
        if (string == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 33, 34, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollbackProposal";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 11: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 21: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUiHandlerImpl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranches";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedBranch";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackingBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUiHandlerImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmRemoteBranchDeletion";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "unmergedFilesErrorTitle";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "unmergedFilesErrorNotificationDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyErrorWithRollbackProposal";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showUnmergedFilesNotification";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showUnmergedFilesMessageWithRollback";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesNotification";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesDialogWithRollback";
                break;
            }
            case 21: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showSmartOperationDialog";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showBranchIsNotFullyMergedDialog";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "confirmRemoteBranchDeletion";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unmergedFilesErrorTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 33, 34, 36, 37 -> new IllegalStateException(string);
        };
    }
}

