/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/commit/GitMergeCommitMessageReader;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "read", "", "repository", "Lgit4idea/repo/GitRepository;", "fixCommentCharsIfNeeded", "message", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitMergeCommitMessageReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMergeCommitMessageReader.kt\ngit4idea/commit/GitMergeCommitMessageReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n2792#2,3:64\n23#3:67\n*S KotlinDebug\n*F\n+ 1 GitMergeCommitMessageReader.kt\ngit4idea/commit/GitMergeCommitMessageReader\n*L\n52#1:64,3\n58#1:67\n*E\n"})
public final class GitMergeCommitMessageReader {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex COMMENT_CHAR_REGEX;

    public GitMergeCommitMessageReader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @RequiresBackgroundThread
    @Nullable
    public final String read(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        File file = repository2.getRepositoryFiles().getMergeMessageFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getMergeMessageFile(...)");
        File mergeMsgFile = file;
        if (!mergeMsgFile.exists()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merge message file " + mergeMsgFile + " exists");
        }
        try {
            String string;
            Charset charset = GitConfigUtil.getCommitEncodingCharset(this.project, repository2.getRoot());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCommitEncodingCharset(...)");
            Charset encoding = charset;
            String string2 = FileUtil.loadFile((File)mergeMsgFile, (Charset)encoding);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loadFile(...)");
            String mergeMsg = string2;
            File file2 = repository2.getRepositoryFiles().getSquashMessageFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getSquashMessageFile(...)");
            File squashMsgFile = file2;
            if (squashMsgFile.exists()) {
                LOG.debug("Squash message file " + squashMsgFile + " exists");
                string = FileUtil.loadFile((File)squashMsgFile, (Charset)encoding);
            } else {
                string = null;
            }
            String squashMsg = string;
            Object[] objectArray = new String[]{squashMsg, mergeMsg};
            return this.fixCommentCharsIfNeeded(DvcsUtil.joinMessagesOrNull((Collection)CollectionsKt.listOfNotNull((Object[])objectArray)), repository2);
        }
        catch (IOException e) {
            LOG.warn("Unable to load merge message", (Throwable)e);
            return null;
        }
    }

    private final String fixCommentCharsIfNeeded(String message, GitRepository repository2) {
        boolean bl;
        block6: {
            if (message == null) {
                return null;
            }
            Iterable $this$none$iv = StringsKt.lines((CharSequence)message);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"\u0001", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return message;
        }
        String string = GitConfigUtil.getValue(this.project, repository2.getRoot(), "core.commentChar");
        if (string == null) {
            string = "#";
        }
        String replaceWith = string;
        CharSequence charSequence = message;
        return COMMENT_CHAR_REGEX.replace(charSequence, replaceWith);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        COMMENT_CHAR_REGEX = new Regex("^\u0001", RegexOption.MULTILINE);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/commit/GitMergeCommitMessageReader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "COMMENT_CHAR_REGEX", "Lkotlin/text/Regex;", "getInstance", "Lgit4idea/commit/GitMergeCommitMessageReader;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitMergeCommitMessageReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMergeCommitMessageReader.kt\ngit4idea/commit/GitMergeCommitMessageReader$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 GitMergeCommitMessageReader.kt\ngit4idea/commit/GitMergeCommitMessageReader$Companion\n*L\n61#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitMergeCommitMessageReader getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitMergeCommitMessageReader> serviceClass$iv = GitMergeCommitMessageReader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitMergeCommitMessageReader)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

