/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitNewCommitMessageActionDialogKt;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\b\u0001\u0010\f\u001a\u00020\u0005\u0012\b\b\u0001\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fB-\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\f\u001a\u00020\u0005\u0012\b\b\u0001\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u0012J\b\u0010\u0019\u001a\u00020\u0017H\u0002J)\u0010\u001a\u001a\u00020\u00172!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00170\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\r\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"H\u0016J\b\u0010#\u001a\u00020\u0005H\u0014J\b\u0010$\u001a\u00020\u0014H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010&\u001a\u00020\u0017H\u0014J\b\u0010'\u001a\u00020\u0017H\u0014J\b\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgit4idea/rebase/log/GitNewCommitMessageActionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "originMessage", "", "selectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "validateCommitEditable", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "title", "dialogLabel", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/lang/String;)V", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "commitEditor", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "onOk", "Lkotlin/Function1;", "", "repositoryValidationResult", "updateOkButtonState", "show", "Lkotlin/ParameterName;", "name", "newMessage", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "Lcom/intellij/ui/EditorTextField;", "Lorg/jetbrains/annotations/NotNull;", "getDimensionServiceKey", "createCommitEditor", "doValidate", "doOKAction", "dispose", "shouldUpdateCommitHistory", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitNewCommitMessageActionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitNewCommitMessageActionDialog.kt\ngit4idea/rebase/log/GitNewCommitMessageActionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1586#2:178\n1661#2,3:179\n*S KotlinDebug\n*F\n+ 1 GitNewCommitMessageActionDialog.kt\ngit4idea/rebase/log/GitNewCommitMessageActionDialog\n*L\n55#1:178\n55#1:179,3\n*E\n"})
public final class GitNewCommitMessageActionDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String originMessage;
    @Nullable
    private final List<Change> selectedChanges;
    @NotNull
    private final Function0<ValidationInfo> validateCommitEditable;
    @NotNull
    private final String dialogLabel;
    @NotNull
    private final CommitMessage commitEditor;
    @NotNull
    private Function1<? super String, Unit> onOk;
    @Nullable
    private ValidationInfo repositoryValidationResult;

    public GitNewCommitMessageActionDialog(@NotNull Project project, @NotNull String originMessage, @Nullable List<? extends Change> selectedChanges, @NotNull Function0<ValidationInfo> validateCommitEditable, @Nls @NotNull String title, @Nls @NotNull String dialogLabel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originMessage, (String)"originMessage");
        Intrinsics.checkNotNullParameter(validateCommitEditable, (String)"validateCommitEditable");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dialogLabel, (String)"dialogLabel");
        super(project, true);
        this.project = project;
        this.originMessage = originMessage;
        this.selectedChanges = selectedChanges;
        this.validateCommitEditable = validateCommitEditable;
        this.dialogLabel = dialogLabel;
        this.commitEditor = this.createCommitEditor();
        this.onOk = GitNewCommitMessageActionDialog::onOk$lambda$0;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.commitEditor));
        this.init();
        this.setModal(false);
        this.setTitle(title);
        this.commitEditor.getEditorField().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateOkButtonState();
            }
        });
        this.updateOkButtonState();
    }

    public GitNewCommitMessageActionDialog(@NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData, @NotNull String originMessage, @Nls @NotNull String title, @Nls @NotNull String dialogLabel) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)originMessage, (String)"originMessage");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dialogLabel, (String)"dialogLabel");
        this(commitEditingData.getProject(), originMessage, GitNewCommitMessageActionDialogKt.access$getSelectedChanges(commitEditingData), (Function0<ValidationInfo>)((Function0)() -> GitNewCommitMessageActionDialog._init_$lambda$0(commitEditingData)), title, dialogLabel);
    }

    private final void updateOkButtonState() {
        if (this.repositoryValidationResult != null) {
            return;
        }
        String string = this.commitEditor.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        boolean isMessageEmpty = StringsKt.isBlank((CharSequence)string);
        this.setOKActionEnabled(!isMessageEmpty);
    }

    public final void show(@NotNull Function1<? super String, Unit> onOk) {
        Intrinsics.checkNotNullParameter(onOk, (String)"onOk");
        this.onOk = onOk;
        this.show();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> GitNewCommitMessageActionDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.commitEditor.getEditorField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        return editorTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Git.Rebase.Log.Action.NewCommitMessage.Dialog";
    }

    private final CommitMessage createCommitEditor() {
        CommitMessage commitMessage;
        CommitMessage $this$createCommitEditor_u24lambda_u240 = commitMessage = new CommitMessage(this.project, false, false, true);
        boolean bl = false;
        $this$createCommitEditor_u24lambda_u240.setText(this.originMessage);
        $this$createCommitEditor_u24lambda_u240.getEditorField().setCaretPosition(0);
        if (this.selectedChanges != null) {
            $this$createCommitEditor_u24lambda_u240.setChangesSupplier(() -> GitNewCommitMessageActionDialog.createCommitEditor$lambda$0$0(this));
        }
        return commitMessage;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.repositoryValidationResult = (ValidationInfo)this.validateCommitEditable.invoke();
        return this.repositoryValidationResult;
    }

    protected void doOKAction() {
        super.doOKAction();
        String string = this.commitEditor.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        this.onOk.invoke((Object)string);
    }

    protected void dispose() {
        if (this.shouldUpdateCommitHistory()) {
            VcsConfiguration.getInstance((Project)this.project).saveCommitMessage(this.commitEditor.getComment());
        }
        super.dispose();
    }

    private final boolean shouldUpdateCommitHistory() {
        return !Intrinsics.areEqual((Object)this.commitEditor.getComment(), (Object)this.originMessage);
    }

    private static final Unit onOk$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ValidationInfo _init_$lambda$0(GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData) {
        Collection<Hash> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $commitEditingData.getSelection().getCommits();
        GitRepository gitRepository = $commitEditingData.getRepository();
        VcsLogData vcsLogData = $commitEditingData.getLogData();
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommitId commitId = (CommitId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHash());
        }
        collection = (List)destination$iv$iv;
        return companion.validateCommitsEditable(vcsLogData, gitRepository, (List<? extends Hash>)collection, $commitEditingData.getRepository().getInfo().getCurrentRevision());
    }

    private static final Unit createCenterPanel$lambda$0(GitNewCommitMessageActionDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        GitNewCommitMessageActionDialogKt.commitMessageWithLabelAndToolbar($this$panel, this$0.commitEditor, this$0.dialogLabel);
        return Unit.INSTANCE;
    }

    private static final Iterable createCommitEditor$lambda$0$0(GitNewCommitMessageActionDialog this$0) {
        return this$0.selectedChanges;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/rebase/log/GitNewCommitMessageActionDialog$Companion;", "", "<init>", "()V", "validateCommitsEditable", "Lcom/intellij/openapi/ui/ValidationInfo;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "repository", "Lgit4idea/repo/GitRepository;", "commits", "", "Lcom/intellij/vcs/log/Hash;", "originalHEAD", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ValidationInfo validateCommitsEditable(@NotNull VcsLogData logData, @NotNull GitRepository repository2, @NotNull List<? extends Hash> commits, @Nullable String originalHEAD) {
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            if (!Intrinsics.areEqual((Object)repository2.getInfo().getCurrentRevision(), (Object)originalHEAD) || logData.isDisposed()) {
                Object[] objectArray = new Object[]{commits.size()};
                return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.repository.changed.message", objectArray));
            }
            Hash lastCommitHash = (Hash)CollectionsKt.last(commits);
            VirtualFile virtualFile = repository2.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, lastCommitHash);
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository2, (Collection<String>)branches);
            if (protectedBranch != null) {
                Object[] objectArray = new Object[]{commits.size(), lastCommitHash, protectedBranch};
                return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.pushed.to.protected.message", objectArray));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

