/*
 * Decompiled with CFR 0.152.
 */
package git4idea.search;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.util.TypeVisibilityStateHolder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.util.Processor;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.matching.MatchingMode;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRefsKt;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.search.GitSearchEverywhereFilterConfiguration;
import git4idea.search.GitSearchEverywhereItemType;
import git4idea.search.GitSearchUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u0013H\u0016J6\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u0013H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020!H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000fH\u0016J$\u0010)\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0+0*2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\u0012\u0010/\u001a\f0\u000f\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\b1H\u0016J\u0012\u00102\u001a\f0\u000f\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\b1H\u0016J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020$H\u0016J\b\u00105\u001a\u00020$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lgit4idea/search/GitSearchEverywhereContributor;", "Lcom/intellij/ide/actions/searcheverywhere/WeightedSearchEverywhereContributor;", "", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "filter", "Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;", "Lgit4idea/search/GitSearchEverywhereItemType;", "kotlin.jvm.PlatformType", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "processRefOfType", "ref", "Lcom/intellij/vcs/log/VcsRef;", "type", "matcher", "Lcom/intellij/util/text/Matcher;", "awaitFullLogDataPack", "Lcom/intellij/vcs/log/data/VcsLogGraphData;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "indicator", "renderer", "Ljavax/swing/ListCellRenderer;", "getElementsRenderer", "processSelectedItem", "", "selected", "modifiers", "", "searchText", "getActions", "", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFiltersAction;", "onChanged", "Ljava/lang/Runnable;", "getSearchProviderId", "getGroupName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFullGroupName", "getSortWeight", "showInFindResults", "isShownInSeparateTab", "Factory", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSearchEverywhereContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSearchEverywhereContributor.kt\ngit4idea/search/GitSearchEverywhereContributor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n30#2,2:202\n1342#3,2:204\n1786#4,3:206\n*S KotlinDebug\n*F\n+ 1 GitSearchEverywhereContributor.kt\ngit4idea/search/GitSearchEverywhereContributor\n*L\n46#1:202,2\n82#1:204,2\n94#1:206,3\n*E\n"})
public final class GitSearchEverywhereContributor
implements WeightedSearchEverywhereContributor<Object>,
DumbAware {
    @NotNull
    private final Project project;
    @NotNull
    private final PersistentSearchEverywhereContributorFilter<GitSearchEverywhereItemType> filter;
    @NotNull
    private final ListCellRenderer<Object> renderer;

    public GitSearchEverywhereContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitSearchEverywhereFilterConfiguration> serviceClass$iv = GitSearchEverywhereFilterConfiguration.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.filter = new PersistentSearchEverywhereContributorFilter(ArraysKt.asList((Object[])GitSearchEverywhereItemType.values()), (TypeVisibilityStateHolder)object, GitSearchEverywhereContributor::filter$lambda$0, GitSearchEverywhereContributor::filter$lambda$1);
        this.renderer = BuilderKt.listCellRenderer(arg_0 -> GitSearchEverywhereContributor.renderer$lambda$0(this, arg_0));
    }

    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer) {
        block14: {
            boolean allRootsIndexed;
            VcsLogIndex index;
            VcsLogData dataManager;
            block13: {
                CommitId commitId;
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                if (!ProjectLevelVcsManager.Companion.getInstance(this.project).checkVcsIsActive("Git")) {
                    return;
                }
                VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(this.project).getLogManager();
                if (vcsLogManager == null) {
                    return;
                }
                VcsLogManager logManager = vcsLogManager;
                dataManager = logManager.getDataManager();
                VcsLogStorage storage = dataManager.getStorage();
                index = dataManager.getIndex();
                VcsLogGraphData vcsLogGraphData = this.awaitFullLogDataPack(dataManager, progressIndicator);
                if (vcsLogGraphData == null) {
                    return;
                }
                VcsLogGraphData dataPack = vcsLogGraphData;
                if (this.filter.isSelected((Object)GitSearchEverywhereItemType.COMMIT_BY_HASH) && pattern.length() >= 7 && GitUtil.isHashString(pattern, false) && (commitId = storage.findCommitId(arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$1(arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$0(progressIndicator, pattern, dataPack, storage, arg_0), arg_0))) != null) {
                    CommitId commitId2 = commitId;
                    boolean bl = false;
                    Hash hash = commitId2.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                    VirtualFile virtualFile = commitId2.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    int id = storage.getCommitIndex(hash, virtualFile);
                    dataManager.getMiniDetailsGetter().loadCommitsDataSynchronously((Iterable)CollectionsKt.listOf((Object)id), progressIndicator, (arg_0, arg_1) -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$2$0(consumer, arg_0, arg_1));
                }
                MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).withMatchingMode(MatchingMode.IGNORE_CASE).typoTolerant().build();
                Sequence $this$forEach$iv = VcsLogRefsKt.getAllRefs((VcsLogRefs)dataPack.getRefsModel());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VcsRef it = (VcsRef)element$iv;
                    boolean bl = false;
                    progressIndicator.checkCanceled();
                    VcsRefType vcsRefType = it.getType();
                    if (Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.LOCAL_BRANCH) || Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.HEAD)) {
                        Intrinsics.checkNotNull((Object)matcher);
                        this.processRefOfType(it, GitSearchEverywhereItemType.LOCAL_BRANCH, (Matcher)matcher, consumer);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.REMOTE_BRANCH)) {
                        Intrinsics.checkNotNull((Object)matcher);
                        this.processRefOfType(it, GitSearchEverywhereItemType.REMOTE_BRANCH, (Matcher)matcher, consumer);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)vcsRefType, (Object)GitRefManager.TAG)) continue;
                    Intrinsics.checkNotNull((Object)matcher);
                    this.processRefOfType(it, GitSearchEverywhereItemType.TAG, (Matcher)matcher, consumer);
                }
                if (!this.filter.isSelected((Object)GitSearchEverywhereItemType.COMMIT_BY_MESSAGE) || !Registry.Companion.is("git.search.everywhere.commit.by.message")) break block14;
                if (pattern.length() < 3) {
                    return;
                }
                List<GitRepository> list = GitRepositoryManager.getInstance(this.project).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v5 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl = false;
                        if (index.isIndexed(it.getRoot())) continue;
                        v5 = false;
                        break block13;
                    }
                    v5 = allRootsIndexed = true;
                }
            }
            if (!allRootsIndexed) {
                return;
            }
            IndexDataGetter indexDataGetter = index.getDataGetter();
            if (indexDataGetter != null) {
                indexDataGetter.filterMessages(VcsLogFilterObject.fromPattern$default((String)pattern, (boolean)false, (boolean)false, (int)6, null), arg_0 -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$5(progressIndicator, dataManager, consumer, arg_0));
            }
        }
    }

    private final void processRefOfType(VcsRef ref, GitSearchEverywhereItemType type, Matcher matcher, Processor<? super FoundItemDescriptor<Object>> consumer) {
        if (!this.filter.isSelected((Object)type)) {
            return;
        }
        String string = ref.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (matcher.matches(string)) {
            consumer.process((Object)new FoundItemDescriptor((Object)ref, type.getWeight()));
        }
    }

    private final VcsLogGraphData awaitFullLogDataPack(VcsLogData dataManager, ProgressIndicator indicator) {
        if (!Registry.Companion.is("vcs.log.keep.up.to.date")) {
            return null;
        }
        VcsLogGraphData dataPack = null;
        do {
            indicator.checkCanceled();
            dataPack = dataManager.getGraphData();
            if (dataPack.isFull()) break;
            Thread.sleep(1000L);
        } while (Intrinsics.areEqual((Object)Unit.INSTANCE, (Object)Unit.INSTANCE));
        return dataPack;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return this.renderer;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        Hash hash = null;
        VirtualFile root = null;
        Object object = selected;
        if (object instanceof VcsRef) {
            hash = ((VcsRef)selected).getCommitHash();
            root = ((VcsRef)selected).getRoot();
        } else if (object instanceof VcsCommitMetadata) {
            hash = (Hash)((VcsCommitMetadata)selected).getId();
            root = ((VcsCommitMetadata)selected).getRoot();
        } else {
            hash = null;
            root = null;
        }
        if (hash != null && root != null) {
            VcsProjectLog.Companion.showRevisionInMainLog(this.project, root, hash);
            return true;
        }
        return false;
    }

    @NotNull
    public List<SearchEverywhereFiltersAction<GitSearchEverywhereItemType>> getActions(@NotNull Runnable onChanged) {
        Intrinsics.checkNotNullParameter((Object)onChanged, (String)"onChanged");
        return CollectionsKt.listOf((Object)new SearchEverywhereFiltersAction(this.filter, onChanged));
    }

    @NotNull
    public String getSearchProviderId() {
        return "Vcs.Git";
    }

    @NotNull
    public String getGroupName() {
        String string = GitBundle.message("search.everywhere.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFullGroupName() {
        String string = GitBundle.message("search.everywhere.group.full.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public int getSortWeight() {
        return 500;
    }

    public boolean showInFindResults() {
        return false;
    }

    public boolean isShownInSeparateTab() {
        return AdvancedSettings.Companion.getBoolean("git.search.everywhere.tab.enabled") && ProjectLevelVcsManager.Companion.getInstance(this.project).checkVcsIsActive("Git") && VcsProjectLog.Companion.getInstance(this.project).getLogManager() != null;
    }

    private static final String filter$lambda$0(GitSearchEverywhereItemType it) {
        return it.getDisplayName();
    }

    private static final Icon filter$lambda$1(GitSearchEverywhereItemType it) {
        return null;
    }

    private static final Unit fetchWeightedElements$lambda$2$0(Processor $consumer, int n, VcsCommitMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        $consumer.process((Object)new FoundItemDescriptor((Object)data2, GitSearchEverywhereItemType.COMMIT_BY_HASH.getWeight()));
        return Unit.INSTANCE;
    }

    private static final Unit fetchWeightedElements$lambda$5$0(Processor $consumer, int n, VcsCommitMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        $consumer.process((Object)new FoundItemDescriptor((Object)data2, GitSearchEverywhereItemType.COMMIT_BY_MESSAGE.getWeight()));
        return Unit.INSTANCE;
    }

    private static final boolean fetchWeightedElements$lambda$0(ProgressIndicator $progressIndicator, String $pattern, VcsLogGraphData $dataPack, VcsLogStorage $storage, CommitId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $progressIndicator.checkCanceled();
        String string = it.getHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return StringsKt.startsWith((String)string, (String)$pattern, (boolean)true) && DataPackUtilKt.containsAll((VcsLogGraphData)$dataPack, (Collection)CollectionsKt.listOf((Object)it), (VcsLogStorage)$storage);
    }

    private static final boolean fetchWeightedElements$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void fetchWeightedElements$lambda$5(ProgressIndicator $progressIndicator, VcsLogData $dataManager, Processor $consumer, int commitIdx) {
        $progressIndicator.checkCanceled();
        $dataManager.getMiniDetailsGetter().loadCommitsDataSynchronously((Iterable)CollectionsKt.listOf((Object)commitIdx), $progressIndicator, (arg_0, arg_1) -> GitSearchEverywhereContributor.fetchWeightedElements$lambda$5$0($consumer, arg_0, arg_1));
    }

    private static final Unit renderer$lambda$0$0(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAlign(LcrInitParams.Align.LEFT);
        return Unit.INSTANCE;
    }

    private static final Unit renderer$lambda$0$1(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setForeground($this$text.getGreyForeground());
        return Unit.INSTANCE;
    }

    private static final Unit renderer$lambda$0(GitSearchEverywhereContributor this$0, LcrRow $this$listCellRenderer) {
        String rightText;
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        Object value = $this$listCellRenderer.getValue();
        Color color = $this$listCellRenderer.getSelectionColor();
        if (color == null) {
            color = JBUI.CurrentTheme.List.BACKGROUND;
        }
        Color iconBg = color;
        Object object = value instanceof VcsRef ? (Icon)new LabelIcon((JComponent)$this$listCellRenderer.getList(), JBUI.scale((int)16), iconBg, CollectionsKt.listOf((Object)((VcsRef)value).getType().getBackgroundColor())) : AllIcons.Vcs.CommitNode;
        Intrinsics.checkNotNull((Object)object);
        LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)object, null, (int)2, null);
        Object object2 = value;
        object = object2 instanceof VcsRef ? ((VcsRef)value).getName() : (object2 instanceof VcsCommitMetadata ? ((VcsCommitMetadata)value).getSubject() : "");
        Intrinsics.checkNotNull((Object)object);
        $this$listCellRenderer.text((String)object, GitSearchEverywhereContributor::renderer$lambda$0$0);
        object2 = value;
        String string = object2 instanceof VcsRef ? GitSearchUtils.INSTANCE.getTrackingRemoteBranchName((VcsRef)value, this$0.project) : (rightText = object2 instanceof VcsCommitMetadata ? ((Hash)((VcsCommitMetadata)value).getId()).toShortString() : null);
        if (rightText != null) {
            $this$listCellRenderer.text(rightText, GitSearchEverywhereContributor::renderer$lambda$0$1);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/search/GitSearchEverywhereContributor$Factory;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributorFactory;", "", "<init>", "()V", "createContributor", "Lgit4idea/search/GitSearchEverywhereContributor;", "initEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public GitSearchEverywhereContributor createContributor(@NotNull AnActionEvent initEvent) {
            Intrinsics.checkNotNullParameter((Object)initEvent, (String)"initEvent");
            Object object = initEvent.getRequiredData(CommonDataKeys.PROJECT);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
            Project project = (Project)object;
            return new GitSearchEverywhereContributor(project);
        }
    }
}

