/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.notification.NotificationAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitLocalBranch;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.FixTrackedBranchDialog;
import git4idea.update.GitUpdateExecutionProcess;
import git4idea.update.GitUpdateProcess;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"notifyDetachedHeadError", "", "Lcom/intellij/openapi/vcs/VcsNotifier;", "repository", "Lgit4idea/repo/GitRepository;", "notifyNoTrackedBranchError", "currentBranch", "Lgit4idea/GitLocalBranch;", "showUpdateDialog", "intellij.vcs.git"})
public final class GitUpdateNotificationsKt {
    public static final void notifyDetachedHeadError(@NotNull VcsNotifier $this$notifyDetachedHeadError, @NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyDetachedHeadError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        $this$notifyDetachedHeadError.notifyError("git.update.detached.head.error", GitBundle.message("notification.title.can.t.update.no.current.branch", new Object[0]), GitUpdateProcess.getDetachedHeadErrorNotificationContent(repository2));
    }

    public static final void notifyNoTrackedBranchError(@NotNull VcsNotifier $this$notifyNoTrackedBranchError, @NotNull GitRepository repository2, @NotNull GitLocalBranch currentBranch) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyNoTrackedBranchError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)currentBranch, (String)"currentBranch");
        NotificationAction[] notificationActionArray = new NotificationAction[]{NotificationAction.createSimple((String)GitBundle.message("update.notification.choose.upstream.branch", new Object[0]), () -> GitUpdateNotificationsKt.notifyNoTrackedBranchError$lambda$0(repository2))};
        $this$notifyNoTrackedBranchError.notifyError("git.update.no.tracked.branch.error", GitBundle.message("update.notification.update.error", new Object[0]), GitUpdateProcess.getNoTrackedBranchError(repository2, currentBranch.getName()), notificationActionArray);
    }

    private static final void showUpdateDialog(GitRepository repository2) {
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FixTrackedBranchDialog updateDialog = new FixTrackedBranchDialog(project);
        if (updateDialog.showAndGet()) {
            Project project2 = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            GitUpdateExecutionProcess.launchUpdate(project2, CollectionsKt.listOf((Object)repository2), updateDialog.getUpdateConfig(), updateDialog.getUpdateMethod(), updateDialog.shouldSetAsTrackedBranch());
        }
    }

    private static final void notifyNoTrackedBranchError$lambda$0(GitRepository $repository) {
        GitUpdateNotificationsKt.showUpdateDialog($repository);
    }
}

