/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import org.jetbrains.annotations.NotNull;

public final class TextEditorLocation
implements FileEditorLocation {
    private final TextEditor myEditor;
    private final LogicalPosition myPosition;

    public TextEditorLocation(int offset, @NotNull TextEditor editor) {
        if (editor == null) {
            TextEditorLocation.$$$reportNull$$$0(0);
        }
        this(editor.getEditor().offsetToLogicalPosition(offset), editor);
    }

    public TextEditorLocation(@NotNull LogicalPosition position, @NotNull TextEditor editor) {
        if (position == null) {
            TextEditorLocation.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            TextEditorLocation.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.myPosition = position;
    }

    @NotNull
    public FileEditor getEditor() {
        TextEditor textEditor = this.myEditor;
        if (textEditor == null) {
            TextEditorLocation.$$$reportNull$$$0(3);
        }
        return textEditor;
    }

    @NotNull
    public LogicalPosition getPosition() {
        LogicalPosition logicalPosition = this.myPosition;
        if (logicalPosition == null) {
            TextEditorLocation.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    public int compareTo(@NotNull FileEditorLocation fileEditorLocation) {
        if (fileEditorLocation == null) {
            TextEditorLocation.$$$reportNull$$$0(5);
        }
        TextEditorLocation otherLocation = (TextEditorLocation)fileEditorLocation;
        if (this.myEditor != otherLocation.myEditor) {
            Logger.getInstance(TextEditorLocation.class).error("Different editors: " + String.valueOf(this.myEditor) + "; and " + String.valueOf(otherLocation.myEditor));
        }
        return this.myPosition.compareTo(otherLocation.myPosition);
    }

    public String toString() {
        return this.myPosition.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

